/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class CountingInputStream
extends FilterInputStream {
    private long markPos = 0L;
    private long readCount = 0L;

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private synchronized void bytesRead(long l) {
        if (l >= 0L) {
            this.readCount += l;
        }
    }

    public synchronized long getReadCount() {
        return this.readCount;
    }

    @Override
    public synchronized void mark(int n) {
        super.mark(n);
        this.markPos = this.readCount;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        this.bytesRead(1L);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        this.bytesRead(n3);
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        CountingInputStream countingInputStream = this;
        synchronized (countingInputStream) {
            this.readCount = this.markPos;
        }
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.bytesRead(l2);
        return l2;
    }
}

