/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputstream
extends OutputStream {
    private long count = 0L;
    private final OutputStream wrapped;

    public CountingOutputstream(OutputStream outputStream) {
        assert (outputStream != null);
        this.wrapped = outputStream;
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public void flush() throws IOException {
        this.wrapped.flush();
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.wrapped.write(byArray);
        this.count += (long)byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.wrapped.write(byArray, n, n2);
        this.count += (long)n2;
    }

    @Override
    public void write(int n) throws IOException {
        this.wrapped.write(n);
        ++this.count;
    }
}

