/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.LanguageList;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class LanguageListReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_LANGUAGE_LIST};

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    @Override
    public Chunk read(GUID gUID, InputStream inputStream, long l) throws IOException {
        assert (GUID.GUID_LANGUAGE_LIST.equals(gUID));
        BigInteger bigInteger = Utils.readBig64(inputStream);
        int n = Utils.readUINT16(inputStream);
        LanguageList languageList = new LanguageList(l, bigInteger);
        for (int i = 0; i < n; ++i) {
            int n2 = inputStream.read() & 0xFF;
            String string = Utils.readFixedSizeUTF16Str(inputStream, n2);
            assert (string.length() == n2 / 2 - 1 || string.length() == n2 / 2);
            languageList.addLanguage(string);
        }
        return languageList;
    }
}

