/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.images.Artwork;

public abstract class AbstractTag
implements Tag {
    protected int commonNumber = 0;
    protected Map<String, List<TagField>> fields = new LinkedHashMap<String, List<TagField>>();

    @Override
    public void addField(TagField tagField) {
        if (tagField == null) {
            return;
        }
        List<TagField> list = this.fields.get(tagField.getId());
        if (list == null) {
            list = new ArrayList<TagField>();
            list.add(tagField);
            this.fields.put(tagField.getId(), list);
            if (tagField.isCommon()) {
                ++this.commonNumber;
            }
        } else {
            list.add(tagField);
        }
    }

    @Override
    public List<TagField> getFields(String string) {
        List<TagField> list = this.fields.get(string);
        if (list == null) {
            return new ArrayList<TagField>();
        }
        return list;
    }

    public List<String> getAll(String string) throws KeyNotFoundException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<TagField> list = this.getFields(string);
        for (TagField tagField : list) {
            arrayList.add(tagField.toString());
        }
        return arrayList;
    }

    public String getItem(String string, int n) {
        List<TagField> list = this.getFields(string);
        return list.size() > n ? list.get(n).toString() : "";
    }

    @Override
    public String getFirst(FieldKey fieldKey) throws KeyNotFoundException {
        return this.getValue(fieldKey, 0);
    }

    @Override
    public String getFirst(String string) {
        List<TagField> list = this.getFields(string);
        return list.size() != 0 ? list.get(0).toString() : "";
    }

    @Override
    public TagField getFirstField(String string) {
        List<TagField> list = this.getFields(string);
        return list.size() != 0 ? list.get(0) : null;
    }

    @Override
    public Iterator<TagField> getFields() {
        final Iterator<Map.Entry<String, List<TagField>>> iterator = this.fields.entrySet().iterator();
        return new Iterator<TagField>(){
            private Iterator<TagField> fieldsIt;

            private void changeIt() {
                if (!iterator.hasNext()) {
                    return;
                }
                Map.Entry entry = (Map.Entry)iterator.next();
                List list = (List)entry.getValue();
                this.fieldsIt = list.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.fieldsIt == null) {
                    this.changeIt();
                }
                return iterator.hasNext() || this.fieldsIt != null && this.fieldsIt.hasNext();
            }

            @Override
            public TagField next() {
                if (!this.fieldsIt.hasNext()) {
                    this.changeIt();
                }
                return this.fieldsIt.next();
            }

            @Override
            public void remove() {
                this.fieldsIt.remove();
            }
        };
    }

    @Override
    public int getFieldCount() {
        Iterator<TagField> iterator = this.getFields();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    @Override
    public int getFieldCountIncludingSubValues() {
        return this.getFieldCount();
    }

    @Override
    public boolean hasCommonFields() {
        return this.commonNumber != 0;
    }

    @Override
    public boolean hasField(String string) {
        return this.getFields(string).size() != 0;
    }

    @Override
    public boolean hasField(FieldKey fieldKey) {
        return this.hasField(fieldKey.name());
    }

    protected abstract boolean isAllowedEncoding(String var1);

    @Override
    public boolean isEmpty() {
        return this.fields.size() == 0;
    }

    @Override
    public void setField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagField = this.createField(fieldKey, string);
        this.setField(tagField);
    }

    @Override
    public void addField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagField = this.createField(fieldKey, string);
        this.addField(tagField);
    }

    @Override
    public void setField(TagField tagField) {
        if (tagField == null) {
            return;
        }
        List<TagField> list = this.fields.get(tagField.getId());
        if (list != null) {
            list.set(0, tagField);
            return;
        }
        list = new ArrayList<TagField>();
        list.add(tagField);
        this.fields.put(tagField.getId(), list);
        if (tagField.isCommon()) {
            ++this.commonNumber;
        }
    }

    @Override
    public boolean setEncoding(String string) {
        if (!this.isAllowedEncoding(string)) {
            return false;
        }
        Iterator<TagField> iterator = this.getFields();
        while (iterator.hasNext()) {
            TagField tagField = iterator.next();
            if (!(tagField instanceof TagTextField)) continue;
            ((TagTextField)tagField).setEncoding(string);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tag content:\n");
        Iterator<TagField> iterator = this.getFields();
        while (iterator.hasNext()) {
            TagField tagField = iterator.next();
            stringBuffer.append("\t");
            stringBuffer.append(tagField.getId());
            stringBuffer.append(":");
            stringBuffer.append(tagField.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
    }

    @Override
    public abstract TagField createField(FieldKey var1, String var2) throws KeyNotFoundException, FieldDataInvalidException;

    @Override
    public abstract TagField getFirstField(FieldKey var1) throws KeyNotFoundException;

    @Override
    public abstract void deleteField(FieldKey var1) throws KeyNotFoundException;

    @Override
    public void deleteField(String string) {
        this.fields.remove(string);
    }

    @Override
    public Artwork getFirstArtwork() {
        List<Artwork> list = this.getArtworkList();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        this.setField(this.createField(artwork));
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        this.addField(this.createField(artwork));
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        this.deleteField(FieldKey.COVER_ART);
    }
}

