/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;

public class Utils {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.generic.utils");
    private static final int MAX_BASE_TEMP_FILENAME_LENGTH = 20;

    public static void copy(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
    }

    public static byte[] getDefaultBytes(String string, String string2) {
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String getExtension(File file) {
        String string = file.getName().toLowerCase();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static long getLongLE(ByteBuffer byteBuffer, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2 - n + 1; ++i) {
            l += (long)((byteBuffer.get(n + i) & 0xFF) << i * 8);
        }
        return l;
    }

    public static long getLongBE(ByteBuffer byteBuffer, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2 - n + 1; ++i) {
            l += (long)(byteBuffer.get(n2 - i) & 0xFF) << i * 8;
        }
        return l;
    }

    public static int getIntLE(byte[] byArray) {
        return (int)Utils.getLongLE(ByteBuffer.wrap(byArray), 0, byArray.length - 1);
    }

    public static int getIntLE(byte[] byArray, int n, int n2) {
        return (int)Utils.getLongLE(ByteBuffer.wrap(byArray), n, n2);
    }

    public static int getIntBE(byte[] byArray, int n, int n2) {
        return (int)Utils.getLongBE(ByteBuffer.wrap(byArray), n, n2);
    }

    public static int getIntBE(ByteBuffer byteBuffer, int n, int n2) {
        return (int)Utils.getLongBE(byteBuffer, n, n2);
    }

    public static short getShortBE(ByteBuffer byteBuffer, int n, int n2) {
        return (short)Utils.getIntBE(byteBuffer, n, n2);
    }

    public static byte[] getSizeBEInt32(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public static byte[] getSizeBEInt16(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)};
        return byArray;
    }

    public static byte[] getSizeLEInt32(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)((long)(n >>> 8) & 0xFFL), (byte)((long)(n >>> 16) & 0xFFL), (byte)((long)(n >>> 24) & 0xFFL)};
        return byArray;
    }

    public static String getString(byte[] byArray, int n, int n2, String string) {
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String getString(ByteBuffer byteBuffer, int n, int n2, String string) {
        byte[] byArray = new byte[n2];
        byteBuffer.position(byteBuffer.position() + n);
        byteBuffer.get(byArray);
        try {
            return new String(byArray, 0, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static byte[] getUTF8Bytes(String string) throws UnsupportedEncodingException {
        return string.getBytes("UTF-8");
    }

    public static int readUint32AsInt(DataInput dataInput) throws IOException {
        long l = Utils.readUint32(dataInput);
        if (l > Integer.MAX_VALUE) {
            throw new IOException("uint32 value read overflows int");
        }
        return (int)l;
    }

    public static long readUint32(DataInput dataInput) throws IOException {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        dataInput.readFully(byArray, 4, 4);
        long l = ByteBuffer.wrap(byArray).getLong();
        return l;
    }

    public static int readUint16(DataInput dataInput) throws IOException {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        dataInput.readFully(byArray, 2, 2);
        int n = ByteBuffer.wrap(byArray).getInt();
        return n;
    }

    public static int readInt16(DataInput dataInput) throws IOException {
        byte[] byArray = new byte[]{0, 0};
        dataInput.readFully(byArray, 0, 2);
        short s = ByteBuffer.wrap(byArray).getShort();
        return s;
    }

    public static String readString(DataInput dataInput, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return new String(byArray);
    }

    public static long readUInt64(ByteBuffer byteBuffer) {
        long l = 0L;
        l += (long)(Utils.readUBEInt32(byteBuffer) << 32);
        return l += (long)Utils.readUBEInt32(byteBuffer);
    }

    public static int readUBEInt32(ByteBuffer byteBuffer) {
        int n = 0;
        n += Utils.readUBEInt16(byteBuffer) << 16;
        return n += Utils.readUBEInt16(byteBuffer);
    }

    public static int readUBEInt24(ByteBuffer byteBuffer) {
        int n = 0;
        n += Utils.readUBEInt16(byteBuffer) << 16;
        return n += Utils.readUInt8(byteBuffer);
    }

    public static int readUBEInt16(ByteBuffer byteBuffer) {
        int n = 0;
        n += Utils.readUInt8(byteBuffer) << 8;
        return n += Utils.readUInt8(byteBuffer);
    }

    public static int readUInt8(ByteBuffer byteBuffer) {
        return Utils.read(byteBuffer);
    }

    public static int read(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        return n;
    }

    public static String getBaseFilenameForTempFile(File file) {
        String string = Utils.getMinBaseFilenameAllowedForTempFile(file);
        if (string.length() <= 20) {
            return string;
        }
        return string.substring(0, 20);
    }

    public static String getMinBaseFilenameAllowedForTempFile(File file) {
        String string = AudioFile.getBaseFilename(file);
        if (string.length() >= 3) {
            return string;
        }
        if (string.length() == 1) {
            return string + "000";
        }
        if (string.length() == 1) {
            return string + "00";
        }
        if (string.length() == 2) {
            return string + "0";
        }
        return string;
    }

    public static boolean rename(File file, File file2) {
        logger.log(Level.CONFIG, "Renaming From:" + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
        if (file2.exists()) {
            logger.log(Level.SEVERE, "Destination File:" + file2 + " already exists");
            return false;
        }
        boolean bl = file.renameTo(file2);
        if (!bl) {
            if (Utils.copy(file, file2)) {
                boolean bl2 = file.delete();
                if (!bl2) {
                    logger.log(Level.SEVERE, "Unable to delete File:" + file);
                    file2.delete();
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean copy(File file, File file2) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[8192];
            while ((n = fileInputStream.read(byArray)) > -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream.close();
            if (file.length() != file2.length()) {
                file2.delete();
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }
}

