/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.ogg.util.OggPageHeader;
import org.jaudiotagger.audio.ogg.util.VorbisPacketType;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentReader;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class OggVorbisTagReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg");
    private VorbisCommentReader vorbisCommentReader = new VorbisCommentReader();

    public Tag read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        logger.config("Starting to read ogg vorbis tag from file:");
        byte[] byArray = this.readRawPacketData(randomAccessFile);
        VorbisCommentTag vorbisCommentTag = this.vorbisCommentReader.read(byArray, true);
        logger.fine("CompletedReadCommentTag");
        return vorbisCommentTag;
    }

    public int readOggVorbisRawSize(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        byte[] byArray = this.readRawPacketData(randomAccessFile);
        return byArray.length + 1 + 6;
    }

    public byte[] readRawPacketData(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        logger.fine("Read 1st page");
        OggPageHeader oggPageHeader = OggPageHeader.read(randomAccessFile);
        randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)oggPageHeader.getPageLength());
        logger.fine("Read 2nd page");
        oggPageHeader = OggPageHeader.read(randomAccessFile);
        byte[] byArray = new byte[7];
        randomAccessFile.read(byArray);
        if (!this.isVorbisCommentHeader(byArray)) {
            throw new CannotReadException("Cannot find comment block (no vorbiscomment header)");
        }
        byte[] byArray2 = this.convertToVorbisCommentPacket(oggPageHeader, randomAccessFile);
        return byArray2;
    }

    public boolean isVorbisCommentHeader(byte[] byArray) {
        String string = Utils.getString(byArray, 1, 6, "ISO-8859-1");
        return byArray[0] == VorbisPacketType.COMMENT_HEADER.getType() && string.equals("vorbis");
    }

    public boolean isVorbisSetupHeader(byte[] byArray) {
        String string = Utils.getString(byArray, 1, 6, "ISO-8859-1");
        return byArray[0] == VorbisPacketType.SETUP_HEADER.getType() && string.equals("vorbis");
    }

    private byte[] convertToVorbisCommentPacket(OggPageHeader oggPageHeader, RandomAccessFile randomAccessFile) throws IOException, CannotReadException {
        OggPageHeader oggPageHeader2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[oggPageHeader.getPacketList().get(0).getLength() - 7];
        randomAccessFile.read(byArray);
        byteArrayOutputStream.write(byArray);
        if (oggPageHeader.getPacketList().size() > 1) {
            logger.config("Comments finish on 2nd Page because there is another packet on this page");
            return byteArrayOutputStream.toByteArray();
        }
        if (!oggPageHeader.isLastPacketIncomplete()) {
            logger.config("Comments finish on 2nd Page because this packet is complete");
            return byteArrayOutputStream.toByteArray();
        }
        do {
            logger.config("Reading next page");
            oggPageHeader2 = OggPageHeader.read(randomAccessFile);
            byArray = new byte[oggPageHeader2.getPacketList().get(0).getLength()];
            randomAccessFile.read(byArray);
            byteArrayOutputStream.write(byArray);
            if (oggPageHeader2.getPacketList().size() <= 1) continue;
            logger.config("Comments finish on Page because there is another packet on this page");
            return byteArrayOutputStream.toByteArray();
        } while (oggPageHeader2.isLastPacketIncomplete());
        logger.config("Comments finish on Page because this packet is complete");
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] convertToVorbisSetupHeaderPacket(long l, RandomAccessFile randomAccessFile) throws IOException, CannotReadException {
        OggPageHeader oggPageHeader;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        randomAccessFile.seek(l);
        OggPageHeader oggPageHeader2 = OggPageHeader.read(randomAccessFile);
        if (oggPageHeader2.getPacketList().size() > 1) {
            randomAccessFile.skipBytes(oggPageHeader2.getPacketList().get(0).getLength());
        }
        byte[] byArray = new byte[7];
        randomAccessFile.read(byArray);
        if (!this.isVorbisSetupHeader(byArray)) {
            throw new CannotReadException("Unable to find setup header(2), unable to write ogg file");
        }
        randomAccessFile.seek(randomAccessFile.getFilePointer() - 7L);
        if (oggPageHeader2.getPacketList().size() > 1) {
            byArray = new byte[oggPageHeader2.getPacketList().get(1).getLength()];
            randomAccessFile.read(byArray);
            byteArrayOutputStream.write(byArray);
        } else {
            byArray = new byte[oggPageHeader2.getPacketList().get(0).getLength()];
            randomAccessFile.read(byArray);
            byteArrayOutputStream.write(byArray);
        }
        if (!oggPageHeader2.isLastPacketIncomplete() || oggPageHeader2.getPacketList().size() > 2) {
            logger.config("Setupheader finishes on this page");
            return byteArrayOutputStream.toByteArray();
        }
        do {
            logger.config("Reading another page");
            oggPageHeader = OggPageHeader.read(randomAccessFile);
            byArray = new byte[oggPageHeader.getPacketList().get(0).getLength()];
            randomAccessFile.read(byArray);
            byteArrayOutputStream.write(byArray);
            if (oggPageHeader.getPacketList().size() <= 1) continue;
            logger.config("Setupheader finishes on this page");
            return byteArrayOutputStream.toByteArray();
        } while (oggPageHeader.isLastPacketIncomplete());
        logger.config("Setupheader finish on Page because this packet is complete");
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] convertToVorbisSetupHeaderPacketAndAdditionalPackets(long l, RandomAccessFile randomAccessFile) throws IOException, CannotReadException {
        OggPageHeader oggPageHeader;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        randomAccessFile.seek(l);
        OggPageHeader oggPageHeader2 = OggPageHeader.read(randomAccessFile);
        if (oggPageHeader2.getPacketList().size() > 1) {
            randomAccessFile.skipBytes(oggPageHeader2.getPacketList().get(0).getLength());
        }
        byte[] byArray = new byte[7];
        randomAccessFile.read(byArray);
        if (!this.isVorbisSetupHeader(byArray)) {
            throw new CannotReadException("Unable to find setup header(2), unable to write ogg file");
        }
        randomAccessFile.seek(randomAccessFile.getFilePointer() - 7L);
        if (oggPageHeader2.getPacketList().size() > 1) {
            byArray = new byte[oggPageHeader2.getPacketList().get(1).getLength()];
            randomAccessFile.read(byArray);
            byteArrayOutputStream.write(byArray);
        } else {
            byArray = new byte[oggPageHeader2.getPacketList().get(0).getLength()];
            randomAccessFile.read(byArray);
            byteArrayOutputStream.write(byArray);
        }
        if (!oggPageHeader2.isLastPacketIncomplete() || oggPageHeader2.getPacketList().size() > 2) {
            logger.config("Setupheader finishes on this page");
            if (oggPageHeader2.getPacketList().size() > 2) {
                for (int i = 2; i < oggPageHeader2.getPacketList().size(); ++i) {
                    byArray = new byte[oggPageHeader2.getPacketList().get(i).getLength()];
                    randomAccessFile.read(byArray);
                    byteArrayOutputStream.write(byArray);
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
        do {
            logger.config("Reading another page");
            oggPageHeader = OggPageHeader.read(randomAccessFile);
            byArray = new byte[oggPageHeader.getPacketList().get(0).getLength()];
            randomAccessFile.read(byArray);
            byteArrayOutputStream.write(byArray);
            if (oggPageHeader.getPacketList().size() <= 1) continue;
            logger.config("Setupheader finishes on this page");
            return byteArrayOutputStream.toByteArray();
        } while (oggPageHeader.isLastPacketIncomplete());
        logger.config("Setupheader finish on Page because this packet is complete");
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public OggVorbisHeaderSizes readOggVorbisHeaderSizes(RandomAccessFile var1_1) throws CannotReadException, IOException {
        block15: {
            OggVorbisTagReader.logger.fine("Started to read comment and setup header sizes:");
            var2_2 = var1_1.getFilePointer();
            var4_3 /* !! */  = new ArrayList<E>();
            var9_4 = 0;
            var11_5 = OggPageHeader.read(var1_1);
            var1_1.seek(var1_1.getFilePointer() + (long)var11_5.getPageLength());
            var11_5 = OggPageHeader.read(var1_1);
            var5_6 = var1_1.getFilePointer() - (long)(27 + var11_5.getSegmentTable().length);
            var12_7 = new byte[7];
            var1_1.read(var12_7);
            if (!this.isVorbisCommentHeader(var12_7)) {
                throw new CannotReadException("Cannot find comment block (no vorbiscomment header)");
            }
            var1_1.seek(var1_1.getFilePointer() - 7L);
            OggVorbisTagReader.logger.config("Found start of comment header at:" + var1_1.getFilePointer());
            while (true) {
                var13_8 = var11_5.getPacketList();
                var9_4 += var13_8.get(0).getLength();
                var1_1.skipBytes(var13_8.get(0).getLength());
                if (var13_8.size() > 1 || !var11_5.isLastPacketIncomplete()) break;
                var11_5 = OggPageHeader.read(var1_1);
            }
            OggVorbisTagReader.logger.config("Found end of comment:size:" + var9_4 + "finishes at file position:" + var1_1.getFilePointer());
            if (var11_5.getPacketList().size() != 1) ** GOTO lbl60
            var11_5 = OggPageHeader.read(var1_1);
            var14_9 = var11_5.getPacketList();
            var13_8 = var11_5.getPacketList().get(0);
            var12_7 = new byte[7];
            var1_1.read(var12_7);
            if (!this.isVorbisSetupHeader(var12_7)) {
                throw new CannotReadException(ErrorMessage.OGG_VORBIS_NO_VORBIS_HEADER_FOUND.getMsg());
            }
            var1_1.seek(var1_1.getFilePointer() - 7L);
            OggVorbisTagReader.logger.config("Found start of vorbis setup header at file position:" + var1_1.getFilePointer());
            var7_11 = var1_1.getFilePointer() - (long)(27 + var11_5.getSegmentTable().length);
            var10_12 = var13_8.getLength();
            OggVorbisTagReader.logger.fine("Adding:" + var13_8.getLength() + " to setup header size");
            var1_1.skipBytes(var13_8.getLength());
            if (var14_9.size() > 1 || !var11_5.isLastPacketIncomplete()) {
                OggVorbisTagReader.logger.config("Found end of setupheader:size:" + var10_12 + "finishes at:" + var1_1.getFilePointer());
                if (var14_9.size() > 1) {
                    var4_3 /* !! */  = var14_9.subList(1, var14_9.size());
                }
            } else {
                var11_5 = OggPageHeader.read(var1_1);
                var14_9 = var11_5.getPacketList();
                while (true) {
                    var10_12 += var14_9.get(0).getLength();
                    OggVorbisTagReader.logger.fine("Adding:" + var14_9.get(0).getLength() + " to setup header size");
                    var1_1.skipBytes(var14_9.get(0).getLength());
                    if (var14_9.size() > 1 || !var11_5.isLastPacketIncomplete()) {
                        OggVorbisTagReader.logger.fine("Found end of setupheader:size:" + var10_12 + "finishes at:" + var1_1.getFilePointer());
                        if (var14_9.size() > 1) {
                            var4_3 /* !! */  = var14_9.subList(1, var14_9.size());
                        }
                        break block15;
                    }
                    var11_5 = OggPageHeader.read(var1_1);
                }
lbl60:
                // 1 sources

                var13_8 = var11_5.getPacketList().get(1);
                var14_10 = var11_5.getPacketList();
                var12_7 = new byte[7];
                var1_1.read(var12_7);
                if (!this.isVorbisSetupHeader(var12_7)) {
                    OggVorbisTagReader.logger.warning("Expecting but got:" + new String(var12_7) + "at " + (var1_1.getFilePointer() - (long)var12_7.length));
                    throw new CannotReadException(ErrorMessage.OGG_VORBIS_NO_VORBIS_HEADER_FOUND.getMsg());
                }
                var1_1.seek(var1_1.getFilePointer() - 7L);
                OggVorbisTagReader.logger.config("Found start of vorbis setup header at file position:" + var1_1.getFilePointer());
                var7_11 = var1_1.getFilePointer() - (long)(27 + var11_5.getSegmentTable().length) - (long)var11_5.getPacketList().get(0).getLength();
                var10_12 = var13_8.getLength();
                OggVorbisTagReader.logger.fine("Adding:" + var13_8.getLength() + " to setup header size");
                var1_1.skipBytes(var13_8.getLength());
                if (var14_10.size() > 2 || !var11_5.isLastPacketIncomplete()) {
                    OggVorbisTagReader.logger.fine("Found end of setupheader:size:" + var10_12 + "finishes at:" + var1_1.getFilePointer());
                    if (var14_10.size() > 2) {
                        var4_3 /* !! */  = var14_10.subList(2, var14_10.size());
                    }
                } else {
                    var11_5 = OggPageHeader.read(var1_1);
                    var14_10 = var11_5.getPacketList();
                    while (true) {
                        var10_12 += var14_10.get(0).getLength();
                        OggVorbisTagReader.logger.fine("Adding:" + var14_10.get(0).getLength() + " to setup header size");
                        var1_1.skipBytes(var14_10.get(0).getLength());
                        if (var14_10.size() > 1 || !var11_5.isLastPacketIncomplete()) {
                            OggVorbisTagReader.logger.fine("Found end of setupheader:size:" + var10_12 + "finishes at:" + var1_1.getFilePointer());
                            if (var14_10.size() <= 1) break;
                            var4_3 /* !! */  = var14_10.subList(1, var14_10.size());
                            break;
                        }
                        var11_5 = OggPageHeader.read(var1_1);
                    }
                }
            }
        }
        var1_1.seek(var2_2);
        return new OggVorbisHeaderSizes(var5_6, var7_11, var9_4, var10_12, var4_3 /* !! */ );
    }

    public static class OggVorbisHeaderSizes {
        private long commentHeaderStartPosition;
        private long setupHeaderStartPosition;
        private int commentHeaderSize;
        private int setupHeaderSize;
        private List<OggPageHeader.PacketStartAndLength> packetList;

        OggVorbisHeaderSizes(long l, long l2, int n, int n2, List<OggPageHeader.PacketStartAndLength> list) {
            this.packetList = list;
            this.commentHeaderStartPosition = l;
            this.setupHeaderStartPosition = l2;
            this.commentHeaderSize = n;
            this.setupHeaderSize = n2;
        }

        public int getCommentHeaderSize() {
            return this.commentHeaderSize;
        }

        public int getSetupHeaderSize() {
            return this.setupHeaderSize;
        }

        public int getExtraPacketDataSize() {
            int n = 0;
            for (OggPageHeader.PacketStartAndLength packetStartAndLength : this.packetList) {
                n += packetStartAndLength.getLength();
            }
            return n;
        }

        public long getCommentHeaderStartPosition() {
            return this.commentHeaderStartPosition;
        }

        public long getSetupHeaderStartPosition() {
            return this.setupHeaderStartPosition;
        }

        public List<OggPageHeader.PacketStartAndLength> getExtraPacketList() {
            return this.packetList;
        }
    }
}

