/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public final class LogFormatter
extends Formatter {
    private boolean isObsfucated = false;
    public static final String ACTION_PERFORMED = "actionPerformed";
    private final String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    private final SimpleDateFormat sfDateOut = new SimpleDateFormat("dd/MM/yyyy HH.mm.ss:");
    private final Date date = new Date();
    public static final String IDENT = "$Id: LogFormatter.java 836 2009-11-12 15:44:07Z paultaylor $";

    @Override
    public final String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        this.date.setTime(logRecord.getMillis());
        stringBuffer.append(this.sfDateOut.format(this.date));
        String string = logRecord.getSourceClassName() != null ? logRecord.getSourceClassName() + ":" + logRecord.getSourceMethodName() : logRecord.getLoggerName() + ":";
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        String string2 = this.formatMessage(logRecord);
        stringBuffer.append(logRecord.getLevel().getLocalizedName());
        stringBuffer.append(": ");
        stringBuffer.append(string2);
        stringBuffer.append(this.lineSeparator);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }
}

