/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.HashMapInterface;
import org.jaudiotagger.tag.datatype.NumberFixedLength;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.ChannelTypes;
import org.jaudiotagger.tag.id3.valuepair.EventTimingTimestampTypes;
import org.jaudiotagger.tag.id3.valuepair.EventTimingTypes;
import org.jaudiotagger.tag.id3.valuepair.InterpolationTypes;
import org.jaudiotagger.tag.id3.valuepair.ReceivedAsTypes;
import org.jaudiotagger.tag.id3.valuepair.SynchronisedLyricsContentType;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.tag.reference.GenreTypes;
import org.jaudiotagger.tag.reference.PictureTypes;
import org.jaudiotagger.utils.EqualsUtil;

public class NumberHashMap
extends NumberFixedLength
implements HashMapInterface<Integer, String> {
    private Map<Integer, String> keyToValue = null;
    private Map<String, Integer> valueToKey = null;
    private boolean hasEmptyValue = false;

    public NumberHashMap(String string, AbstractTagFrameBody abstractTagFrameBody, int n) {
        super(string, abstractTagFrameBody, n);
        if (string.equals("Genre")) {
            this.valueToKey = GenreTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = GenreTypes.getInstanceOf().getIdToValueMap();
            this.hasEmptyValue = true;
        } else if (string.equals("TextEncoding")) {
            this.valueToKey = TextEncoding.getInstanceOf().getValueToIdMap();
            this.keyToValue = TextEncoding.getInstanceOf().getIdToValueMap();
        } else if (string.equals("InterpolationMethod")) {
            this.valueToKey = InterpolationTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = InterpolationTypes.getInstanceOf().getIdToValueMap();
        } else if (string.equals("PictureType")) {
            this.valueToKey = PictureTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = PictureTypes.getInstanceOf().getIdToValueMap();
            this.hasEmptyValue = true;
        } else if (string.equals("TypeOfEvent")) {
            this.valueToKey = EventTimingTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = EventTimingTypes.getInstanceOf().getIdToValueMap();
        } else if (string.equals("TimeStampFormat")) {
            this.valueToKey = EventTimingTimestampTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = EventTimingTimestampTypes.getInstanceOf().getIdToValueMap();
        } else if (string.equals("TypeOfChannel")) {
            this.valueToKey = ChannelTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = ChannelTypes.getInstanceOf().getIdToValueMap();
        } else if (string.equals("RecievedAs")) {
            this.valueToKey = ReceivedAsTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = ReceivedAsTypes.getInstanceOf().getIdToValueMap();
        } else if (string.equals("contentType")) {
            this.valueToKey = SynchronisedLyricsContentType.getInstanceOf().getValueToIdMap();
            this.keyToValue = SynchronisedLyricsContentType.getInstanceOf().getIdToValueMap();
        } else {
            throw new IllegalArgumentException("Hashmap identifier not defined in this class: " + string);
        }
    }

    public NumberHashMap(NumberHashMap numberHashMap) {
        super(numberHashMap);
        this.hasEmptyValue = numberHashMap.hasEmptyValue;
        this.keyToValue = numberHashMap.keyToValue;
        this.valueToKey = numberHashMap.valueToKey;
    }

    @Override
    public Map<Integer, String> getKeyToValue() {
        return this.keyToValue;
    }

    @Override
    public Map<String, Integer> getValueToKey() {
        return this.valueToKey;
    }

    @Override
    public void setValue(Object object) {
        this.value = object instanceof Byte ? Long.valueOf(((Byte)object).byteValue()) : (object instanceof Short ? Long.valueOf(((Short)object).shortValue()) : (object instanceof Integer ? Long.valueOf(((Integer)object).intValue()) : object));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberHashMap)) {
            return false;
        }
        NumberHashMap numberHashMap = (NumberHashMap)object;
        return EqualsUtil.areEqual(this.hasEmptyValue, numberHashMap.hasEmptyValue) && EqualsUtil.areEqual(this.keyToValue, numberHashMap.keyToValue) && EqualsUtil.areEqual(this.valueToKey, numberHashMap.valueToKey) && super.equals(numberHashMap);
    }

    @Override
    public Iterator<String> iterator() {
        if (this.keyToValue == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>(this.keyToValue.values());
        if (this.hasEmptyValue) {
            treeSet.add("");
        }
        return treeSet.iterator();
    }

    @Override
    public void readByteArray(byte[] byArray, int n) throws InvalidDataTypeException {
        super.readByteArray(byArray, n);
        Integer n2 = ((Long)this.value).intValue();
        if (!this.keyToValue.containsKey(n2)) {
            if (!this.hasEmptyValue) {
                throw new InvalidDataTypeException(ErrorMessage.MP3_REFERENCE_KEY_INVALID.getMsg(this.identifier, n2));
            }
            if (this.identifier.equals("PictureType")) {
                logger.warning(ErrorMessage.MP3_PICTURE_TYPE_INVALID.getMsg(this.value));
            }
        }
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.keyToValue.get(this.value) == null) {
            return "";
        }
        return this.keyToValue.get(this.value);
    }
}

