/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.logging.Level;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.UnableToCreateFileException;
import org.jaudiotagger.audio.exceptions.UnableToModifyFileException;
import org.jaudiotagger.audio.exceptions.UnableToRenameFileException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.logging.FileSystemMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.datatype.Pair;
import org.jaudiotagger.tag.datatype.PairedTextEncodedStringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractID3Tag;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.AggregatedFrame;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v23Frames;
import org.jaudiotagger.tag.id3.ID3v24Frames;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyEncrypted;
import org.jaudiotagger.tag.id3.framebody.FrameBodyIPLS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPOPM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIPL;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPOS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRCK;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTXXX;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUFID;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAR;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWXXX;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.reference.PictureTypes;

public abstract class AbstractID3v2Tag
extends AbstractID3Tag
implements Tag {
    protected static final String TYPE_HEADER = "header";
    protected static final String TYPE_BODY = "body";
    protected static final byte[] TAG_ID = new byte[]{73, 68, 51};
    public static final int TAG_HEADER_LENGTH = 10;
    protected static final int FIELD_TAGID_LENGTH = 3;
    protected static final int FIELD_TAG_MAJOR_VERSION_LENGTH = 1;
    protected static final int FIELD_TAG_MINOR_VERSION_LENGTH = 1;
    protected static final int FIELD_TAG_FLAG_LENGTH = 1;
    protected static final int FIELD_TAG_SIZE_LENGTH = 4;
    protected static final int FIELD_TAGID_POS = 0;
    protected static final int FIELD_TAG_MAJOR_VERSION_POS = 3;
    protected static final int FIELD_TAG_MINOR_VERSION_POS = 4;
    protected static final int FIELD_TAG_FLAG_POS = 5;
    protected static final int FIELD_TAG_SIZE_POS = 6;
    protected static final int TAG_SIZE_INCREMENT = 100;
    private static final long MAXIMUM_WRITABLE_CHUNK_SIZE = 10000000L;
    public HashMap<String, Object> frameMap = null;
    public HashMap<String, Object> encryptedFrameMap = null;
    protected static final String TYPE_DUPLICATEFRAMEID = "duplicateFrameId";
    protected String duplicateFrameId = "";
    protected static final String TYPE_DUPLICATEBYTES = "duplicateBytes";
    protected int duplicateBytes = 0;
    protected static final String TYPE_EMPTYFRAMEBYTES = "emptyFrameBytes";
    protected int emptyFrameBytes = 0;
    protected static final String TYPE_FILEREADSIZE = "fileReadSize";
    protected int fileReadSize = 0;
    protected static final String TYPE_INVALIDFRAMES = "invalidFrames";
    protected int invalidFrames = 0;

    private static boolean isID3V2Header(RandomAccessFile randomAccessFile) throws IOException {
        long l = randomAccessFile.getFilePointer();
        byte[] byArray = new byte[3];
        randomAccessFile.read(byArray);
        randomAccessFile.seek(l);
        return Arrays.equals(byArray, TAG_ID);
    }

    public static boolean isId3Tag(RandomAccessFile randomAccessFile) throws IOException {
        if (!AbstractID3v2Tag.isID3V2Header(randomAccessFile)) {
            return false;
        }
        byte[] byArray = new byte[4];
        randomAccessFile.seek(randomAccessFile.getFilePointer() + 6L);
        randomAccessFile.read(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = ID3SyncSafeInteger.bufferToValue(byteBuffer);
        randomAccessFile.seek(n + 10);
        return true;
    }

    public AbstractID3v2Tag() {
    }

    protected AbstractID3v2Tag(AbstractID3v2Tag abstractID3v2Tag) {
    }

    protected void copyPrimitives(AbstractID3v2Tag abstractID3v2Tag) {
        logger.config("Copying Primitives");
        this.duplicateFrameId = abstractID3v2Tag.duplicateFrameId;
        this.duplicateBytes = abstractID3v2Tag.duplicateBytes;
        this.emptyFrameBytes = abstractID3v2Tag.emptyFrameBytes;
        this.fileReadSize = abstractID3v2Tag.fileReadSize;
        this.invalidFrames = abstractID3v2Tag.invalidFrames;
    }

    protected void copyFrames(AbstractID3v2Tag abstractID3v2Tag) {
        this.frameMap = new LinkedHashMap<String, Object>();
        this.encryptedFrameMap = new LinkedHashMap<String, Object>();
        for (String string : abstractID3v2Tag.frameMap.keySet()) {
            String string2 = string;
            Object object = abstractID3v2Tag.frameMap.get(string2);
            if (object instanceof AbstractID3v2Frame) {
                this.addFrame((AbstractID3v2Frame)object);
                continue;
            }
            if (!(object instanceof ArrayList)) continue;
            for (AbstractID3v2Frame abstractID3v2Frame : (ArrayList)object) {
                this.addFrame(abstractID3v2Frame);
            }
        }
    }

    protected abstract void addFrame(AbstractID3v2Frame var1);

    public int getDuplicateBytes() {
        return this.duplicateBytes;
    }

    public String getDuplicateFrameId() {
        return this.duplicateFrameId;
    }

    public int getEmptyFrameBytes() {
        return this.emptyFrameBytes;
    }

    public int getInvalidFrames() {
        return this.invalidFrames;
    }

    public int getFileReadBytes() {
        return this.fileReadSize;
    }

    public boolean hasFrame(String string) {
        return this.frameMap.containsKey(string);
    }

    public boolean hasFrameAndBody(String string) {
        if (this.hasFrame(string)) {
            Object object = this.getFrame(string);
            if (object instanceof AbstractID3v2Frame) {
                return !(((AbstractID3v2Frame)object).getBody() instanceof FrameBodyUnsupported);
            }
            return true;
        }
        return false;
    }

    public boolean hasFrameOfType(String string) {
        Iterator<String> iterator = this.frameMap.keySet().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = iterator.next();
            if (!string2.startsWith(string)) continue;
            bl = true;
        }
        return bl;
    }

    public Object getFrame(String string) {
        return this.frameMap.get(string);
    }

    public Object getEncryptedFrame(String string) {
        return this.encryptedFrameMap.get(string);
    }

    @Override
    public String getFirst(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFirstField(string);
        if (abstractID3v2Frame == null) {
            return "";
        }
        return this.getTextValueForFrame(abstractID3v2Frame);
    }

    private String getTextValueForFrame(AbstractID3v2Frame abstractID3v2Frame) {
        return abstractID3v2Frame.getBody().getUserFriendlyValue();
    }

    @Override
    public TagField getFirstField(FieldKey fieldKey) throws KeyNotFoundException {
        List<TagField> list = this.getFields(fieldKey);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AbstractID3v2Frame getFirstField(String string) {
        Object object = this.getFrame(string);
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            return (AbstractID3v2Frame)((List)object).get(0);
        }
        return (AbstractID3v2Frame)object;
    }

    public void setFrame(AbstractID3v2Frame abstractID3v2Frame) {
        this.frameMap.put(abstractID3v2Frame.getIdentifier(), abstractID3v2Frame);
    }

    protected abstract ID3Frames getID3Frames();

    @Override
    public void setField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagField = this.createField(fieldKey, string);
        this.setField(tagField);
    }

    @Override
    public void addField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagField = this.createField(fieldKey, string);
        this.addField(tagField);
    }

    public void mergeDuplicateFrames(AbstractID3v2Frame abstractID3v2Frame, List<AbstractID3v2Frame> list) {
        ListIterator<AbstractID3v2Frame> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            AbstractID3v2Frame abstractID3v2Frame2 = listIterator.next();
            if (abstractID3v2Frame.getBody() instanceof FrameBodyTXXX) {
                if (!((FrameBodyTXXX)abstractID3v2Frame.getBody()).getDescription().equals(((FrameBodyTXXX)abstractID3v2Frame2.getBody()).getDescription())) continue;
                listIterator.set(abstractID3v2Frame);
                this.frameMap.put(abstractID3v2Frame.getId(), list);
                return;
            }
            if (abstractID3v2Frame.getBody() instanceof FrameBodyWXXX) {
                if (!((FrameBodyWXXX)abstractID3v2Frame.getBody()).getDescription().equals(((FrameBodyWXXX)abstractID3v2Frame2.getBody()).getDescription())) continue;
                listIterator.set(abstractID3v2Frame);
                this.frameMap.put(abstractID3v2Frame.getId(), list);
                return;
            }
            if (abstractID3v2Frame.getBody() instanceof FrameBodyCOMM) {
                if (!((FrameBodyCOMM)abstractID3v2Frame.getBody()).getDescription().equals(((FrameBodyCOMM)abstractID3v2Frame2.getBody()).getDescription())) continue;
                listIterator.set(abstractID3v2Frame);
                this.frameMap.put(abstractID3v2Frame.getId(), list);
                return;
            }
            if (abstractID3v2Frame.getBody() instanceof FrameBodyUFID) {
                if (!((FrameBodyUFID)abstractID3v2Frame.getBody()).getOwner().equals(((FrameBodyUFID)abstractID3v2Frame2.getBody()).getOwner())) continue;
                listIterator.set(abstractID3v2Frame);
                this.frameMap.put(abstractID3v2Frame.getId(), list);
                return;
            }
            if (abstractID3v2Frame.getBody() instanceof FrameBodyUSLT) {
                if (!((FrameBodyUSLT)abstractID3v2Frame.getBody()).getDescription().equals(((FrameBodyUSLT)abstractID3v2Frame2.getBody()).getDescription())) continue;
                listIterator.set(abstractID3v2Frame);
                this.frameMap.put(abstractID3v2Frame.getId(), list);
                return;
            }
            if (abstractID3v2Frame.getBody() instanceof FrameBodyPOPM) {
                if (!((FrameBodyPOPM)abstractID3v2Frame.getBody()).getEmailToUser().equals(((FrameBodyPOPM)abstractID3v2Frame2.getBody()).getEmailToUser())) continue;
                listIterator.set(abstractID3v2Frame);
                this.frameMap.put(abstractID3v2Frame.getId(), list);
                return;
            }
            if (abstractID3v2Frame.getBody() instanceof FrameBodyTRCK) {
                FrameBodyTRCK frameBodyTRCK = (FrameBodyTRCK)abstractID3v2Frame.getBody();
                FrameBodyTRCK frameBodyTRCK2 = (FrameBodyTRCK)abstractID3v2Frame2.getBody();
                if (frameBodyTRCK.getTrackNo() != null && frameBodyTRCK.getTrackNo() > 0) {
                    frameBodyTRCK2.setTrackNo(frameBodyTRCK.getTrackNoAsText());
                }
                if (frameBodyTRCK.getTrackTotal() != null && frameBodyTRCK.getTrackTotal() > 0) {
                    frameBodyTRCK2.setTrackTotal(frameBodyTRCK.getTrackTotalAsText());
                }
                return;
            }
            if (abstractID3v2Frame.getBody() instanceof FrameBodyTPOS) {
                Integer n;
                FrameBodyTPOS frameBodyTPOS = (FrameBodyTPOS)abstractID3v2Frame.getBody();
                FrameBodyTPOS frameBodyTPOS2 = (FrameBodyTPOS)abstractID3v2Frame2.getBody();
                Integer n2 = frameBodyTPOS.getDiscNo();
                if (n2 != null && n2 > 0) {
                    frameBodyTPOS2.setDiscNo(frameBodyTPOS.getDiscNoAsText());
                }
                if ((n = frameBodyTPOS.getDiscTotal()) != null && n > 0) {
                    frameBodyTPOS2.setDiscTotal(frameBodyTPOS.getDiscTotalAsText());
                }
                return;
            }
            if (abstractID3v2Frame.getBody() instanceof FrameBodyIPLS) {
                FrameBodyIPLS frameBodyIPLS = (FrameBodyIPLS)abstractID3v2Frame.getBody();
                FrameBodyIPLS frameBodyIPLS2 = (FrameBodyIPLS)abstractID3v2Frame2.getBody();
                frameBodyIPLS2.addPair(frameBodyIPLS.getText());
                return;
            }
            if (!(abstractID3v2Frame.getBody() instanceof FrameBodyTIPL)) continue;
            FrameBodyTIPL frameBodyTIPL = (FrameBodyTIPL)abstractID3v2Frame.getBody();
            FrameBodyTIPL frameBodyTIPL2 = (FrameBodyTIPL)abstractID3v2Frame2.getBody();
            frameBodyTIPL2.addPair(frameBodyTIPL.getText());
            return;
        }
        if (!this.getID3Frames().isMultipleAllowed(abstractID3v2Frame.getId())) {
            this.frameMap.put(abstractID3v2Frame.getId(), abstractID3v2Frame);
        } else {
            list.add(abstractID3v2Frame);
            this.frameMap.put(abstractID3v2Frame.getId(), list);
        }
    }

    private void addNewFrameToMap(List<TagField> list, HashMap hashMap, AbstractID3v2Frame abstractID3v2Frame, AbstractID3v2Frame abstractID3v2Frame2) {
        if (list.size() == 0) {
            list.add(abstractID3v2Frame);
            list.add(abstractID3v2Frame2);
            hashMap.put(abstractID3v2Frame2.getId(), list);
        } else {
            list.add(abstractID3v2Frame2);
        }
    }

    private void addNewFrameOrAddField(List<TagField> list, HashMap hashMap, AbstractID3v2Frame abstractID3v2Frame, AbstractID3v2Frame abstractID3v2Frame2) {
        ArrayList<TagField> arrayList = new ArrayList<TagField>();
        if (abstractID3v2Frame != null) {
            arrayList.add(abstractID3v2Frame);
        } else {
            arrayList.addAll(list);
        }
        if (abstractID3v2Frame2.getBody() instanceof FrameBodyTXXX) {
            FrameBodyTXXX frameBodyTXXX = (FrameBodyTXXX)abstractID3v2Frame2.getBody();
            boolean bl = false;
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                FrameBodyTXXX frameBodyTXXX2 = (FrameBodyTXXX)((AbstractID3v2Frame)listIterator.next()).getBody();
                if (!frameBodyTXXX.getDescription().equals(frameBodyTXXX2.getDescription())) continue;
                frameBodyTXXX2.addTextValue(frameBodyTXXX.getText());
                bl = true;
                break;
            }
            if (!bl) {
                this.addNewFrameToMap(list, hashMap, abstractID3v2Frame, abstractID3v2Frame2);
            }
        } else if (abstractID3v2Frame2.getBody() instanceof FrameBodyWXXX) {
            FrameBodyWXXX frameBodyWXXX = (FrameBodyWXXX)abstractID3v2Frame2.getBody();
            boolean bl = false;
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                FrameBodyWXXX frameBodyWXXX2 = (FrameBodyWXXX)((AbstractID3v2Frame)listIterator.next()).getBody();
                if (!frameBodyWXXX.getDescription().equals(frameBodyWXXX2.getDescription())) continue;
                frameBodyWXXX2.addUrlLink(frameBodyWXXX.getUrlLink());
                bl = true;
                break;
            }
            if (!bl) {
                this.addNewFrameToMap(list, hashMap, abstractID3v2Frame, abstractID3v2Frame2);
            }
        } else if (abstractID3v2Frame2.getBody() instanceof AbstractFrameBodyTextInfo) {
            AbstractFrameBodyTextInfo abstractFrameBodyTextInfo = (AbstractFrameBodyTextInfo)abstractID3v2Frame2.getBody();
            AbstractFrameBodyTextInfo abstractFrameBodyTextInfo2 = (AbstractFrameBodyTextInfo)abstractID3v2Frame.getBody();
            abstractFrameBodyTextInfo2.addTextValue(abstractFrameBodyTextInfo.getText());
        } else if (abstractID3v2Frame2.getBody() instanceof FrameBodyIPLS) {
            FrameBodyIPLS frameBodyIPLS = (FrameBodyIPLS)abstractID3v2Frame2.getBody();
            FrameBodyIPLS frameBodyIPLS2 = (FrameBodyIPLS)abstractID3v2Frame.getBody();
            frameBodyIPLS2.addPair(frameBodyIPLS.getText());
        } else if (abstractID3v2Frame2.getBody() instanceof FrameBodyTIPL) {
            FrameBodyTIPL frameBodyTIPL = (FrameBodyTIPL)abstractID3v2Frame2.getBody();
            FrameBodyTIPL frameBodyTIPL2 = (FrameBodyTIPL)abstractID3v2Frame.getBody();
            frameBodyTIPL2.addPair(frameBodyTIPL.getText());
        } else if (abstractID3v2Frame2.getBody() instanceof FrameBodyTRCK) {
            FrameBodyTRCK frameBodyTRCK = (FrameBodyTRCK)abstractID3v2Frame2.getBody();
            FrameBodyTRCK frameBodyTRCK2 = (FrameBodyTRCK)abstractID3v2Frame.getBody();
            if (frameBodyTRCK.getTrackNo() != null && frameBodyTRCK.getTrackNo() > 0) {
                frameBodyTRCK2.setTrackNo(frameBodyTRCK.getTrackNoAsText());
            }
            if (frameBodyTRCK.getTrackTotal() != null && frameBodyTRCK.getTrackTotal() > 0) {
                frameBodyTRCK2.setTrackTotal(frameBodyTRCK.getTrackTotalAsText());
            }
        } else if (abstractID3v2Frame2.getBody() instanceof FrameBodyTPOS) {
            FrameBodyTPOS frameBodyTPOS = (FrameBodyTPOS)abstractID3v2Frame2.getBody();
            FrameBodyTPOS frameBodyTPOS2 = (FrameBodyTPOS)abstractID3v2Frame.getBody();
            if (frameBodyTPOS.getDiscNo() != null && frameBodyTPOS.getDiscNo() > 0) {
                frameBodyTPOS2.setDiscNo(frameBodyTPOS.getDiscNoAsText());
            }
            if (frameBodyTPOS.getDiscTotal() != null && frameBodyTPOS.getDiscTotal() > 0) {
                frameBodyTPOS2.setDiscTotal(frameBodyTPOS.getDiscTotalAsText());
            }
        } else {
            this.addNewFrameToMap(list, hashMap, abstractID3v2Frame, abstractID3v2Frame2);
        }
    }

    @Override
    public void setField(TagField tagField) throws FieldDataInvalidException {
        if (!(tagField instanceof AbstractID3v2Frame) && !(tagField instanceof AggregatedFrame)) {
            throw new FieldDataInvalidException("Field " + tagField + " is not of type AbstractID3v2Frame nor AggregatedFrame");
        }
        if (tagField instanceof AbstractID3v2Frame) {
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)tagField;
            Object object = this.frameMap.get(tagField.getId());
            if (object == null) {
                this.frameMap.put(tagField.getId(), tagField);
            } else if (object instanceof AbstractID3v2Frame) {
                ArrayList<AbstractID3v2Frame> arrayList = new ArrayList<AbstractID3v2Frame>();
                arrayList.add((AbstractID3v2Frame)object);
                this.mergeDuplicateFrames(abstractID3v2Frame, arrayList);
            } else if (object instanceof List) {
                this.mergeDuplicateFrames(abstractID3v2Frame, (List)object);
            }
        } else {
            this.frameMap.put(tagField.getId(), tagField);
        }
    }

    @Override
    public void addField(TagField tagField) throws FieldDataInvalidException {
        if (tagField == null) {
            return;
        }
        if (!(tagField instanceof AbstractID3v2Frame) && !(tagField instanceof AggregatedFrame)) {
            throw new FieldDataInvalidException("Field " + tagField + " is not of type AbstractID3v2Frame or AggregatedFrame");
        }
        if (tagField instanceof AbstractID3v2Frame) {
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)tagField;
            Object object = this.frameMap.get(tagField.getId());
            if (object == null) {
                this.frameMap.put(tagField.getId(), tagField);
            } else if (object instanceof List) {
                List list = (List)object;
                this.addNewFrameOrAddField(list, this.frameMap, null, abstractID3v2Frame);
            } else {
                AbstractID3v2Frame abstractID3v2Frame2 = (AbstractID3v2Frame)object;
                ArrayList<TagField> arrayList = new ArrayList<TagField>();
                this.addNewFrameOrAddField(arrayList, this.frameMap, abstractID3v2Frame2, abstractID3v2Frame);
            }
        } else {
            this.frameMap.put(tagField.getId(), tagField);
        }
    }

    public void setFrame(String string, List<AbstractID3v2Frame> list) {
        logger.finest("Adding " + list.size() + " frames for " + string);
        this.frameMap.put(string, list);
    }

    public Iterator getFrameOfType(String string) {
        Iterator<String> iterator = this.frameMap.keySet().iterator();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string)) continue;
            Object object = this.frameMap.get(string2);
            if (object instanceof List) {
                for (Object e : (List)object) {
                    hashSet.add(e);
                }
                continue;
            }
            hashSet.add(object);
        }
        return hashSet.iterator();
    }

    @Override
    public void delete(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[3];
        FileChannel fileChannel = randomAccessFile.getChannel();
        fileChannel.position();
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        fileChannel.read(byteBuffer, 0L);
        byteBuffer.flip();
        if (this.seek(byteBuffer)) {
            randomAccessFile.seek(0L);
            randomAccessFile.write(byArray);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractID3v2Tag)) {
            return false;
        }
        AbstractID3v2Tag abstractID3v2Tag = (AbstractID3v2Tag)object;
        return this.frameMap.equals(abstractID3v2Tag.frameMap) && super.equals(object);
    }

    @Override
    public Iterator iterator() {
        return this.frameMap.values().iterator();
    }

    public void removeFrame(String string) {
        logger.finest("Removing frame with identifier:" + string);
        this.frameMap.remove(string);
    }

    public void removeUnsupportedFrames() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AbstractID3v2Frame) || !(((AbstractID3v2Frame)e).getBody() instanceof FrameBodyUnsupported)) continue;
            logger.finest("Removing frame" + ((AbstractID3v2Frame)e).getIdentifier());
            iterator.remove();
        }
    }

    public void removeFrameOfType(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : this.frameMap.keySet()) {
            String string3 = string2;
            if (!string3.startsWith(string)) continue;
            hashSet.add(string3);
        }
        for (String string2 : hashSet) {
            logger.finest("Removing frame with identifier:" + string2 + "because starts with:" + string);
            this.frameMap.remove(string2);
        }
    }

    public void write(File file, long l) throws IOException {
    }

    protected FileLock getFileLockForWriting(FileChannel fileChannel, String string) throws IOException {
        FileLock fileLock;
        logger.finest("locking fileChannel for " + string);
        try {
            fileLock = fileChannel.tryLock();
        }
        catch (IOException iOException) {
            return null;
        }
        if (fileLock == null) {
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_FILE_LOCKED.getMsg(string));
        }
        return fileLock;
    }

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
    }

    public void write(WritableByteChannel writableByteChannel) throws IOException {
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(Channels.newChannel(outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getV2TagSizeIfExists(File file) throws IOException {
        FileInputStream fileInputStream = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        ByteBuffer byteBuffer = null;
        try {
            fileInputStream = new FileInputStream(file);
            abstractInterruptibleChannel = fileInputStream.getChannel();
            byteBuffer = ByteBuffer.allocate(10);
            ((FileChannel)abstractInterruptibleChannel).read(byteBuffer);
            byteBuffer.flip();
            if (byteBuffer.limit() < 10) {
                long l = 0L;
                return l;
            }
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        byte[] byArray = new byte[3];
        byteBuffer.get(byArray, 0, 3);
        if (!Arrays.equals(byArray, TAG_ID)) {
            return 0L;
        }
        byte by = byteBuffer.get();
        if (by != 2 && by != 3 && by != 4) {
            return 0L;
        }
        byteBuffer.get();
        byteBuffer.get();
        int n = ID3SyncSafeInteger.bufferToValue(byteBuffer);
        return n += 10;
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        logger.config("ByteBuffer pos:" + byteBuffer.position() + ":limit" + byteBuffer.limit() + ":cap" + byteBuffer.capacity());
        byte[] byArray = new byte[3];
        byteBuffer.get(byArray, 0, 3);
        if (!Arrays.equals(byArray, TAG_ID)) {
            return false;
        }
        if (byteBuffer.get() != this.getMajorVersion()) {
            return false;
        }
        return byteBuffer.get() == this.getRevision();
    }

    protected int calculateTagSize(int n, int n2) {
        if (n <= n2) {
            return n2;
        }
        return n + 100;
    }

    public void adjustPadding(File file, int n, long l) throws FileNotFoundException, IOException {
        FileChannel fileChannel;
        File file2;
        logger.finer("Need to move audio file to accommodate tag");
        FileChannel fileChannel2 = null;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[n]);
        try {
            file2 = File.createTempFile(Utils.getBaseFilenameForTempFile(file), ".new", file.getParentFile());
            logger.finest("Created temp file:" + file2.getName() + " for " + file.getName());
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
            if (iOException.getMessage().equals(FileSystemMessage.ACCESS_IS_DENIED.getMsg())) {
                logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
                throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
            }
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
            throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
        }
        try {
            fileChannel = new FileOutputStream(file2).getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.SEVERE, fileNotFoundException.getMessage(), fileNotFoundException);
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_MODIFY_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
            throw new UnableToModifyFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_MODIFY_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
        }
        try {
            long l2;
            fileChannel2 = new FileInputStream(file).getChannel();
            long l3 = fileChannel.write(byteBuffer);
            logger.finer("Copying:" + (file.length() - l) + "bytes");
            long l4 = file.length() - l;
            if (l4 <= 10000000L) {
                fileChannel2.position(l);
                l2 = fileChannel.transferFrom(fileChannel2, n, l4);
                logger.finer("Written padding:" + l3 + " Data:" + l2);
                if (l2 != l4) {
                    throw new RuntimeException(ErrorMessage.MP3_UNABLE_TO_ADJUST_PADDING.getMsg(l4, l2));
                }
            } else {
                l2 = l4 / 10000000L;
                long l5 = l4 % 10000000L;
                long l6 = 0L;
                int n2 = 0;
                while ((long)n2 < l2) {
                    l6 += fileChannel2.transferTo(l + (long)n2 * 10000000L, 10000000L, fileChannel);
                    ++n2;
                }
                logger.finer("Written padding:" + l3 + " Data:" + (l6 += fileChannel2.transferTo(l + l2 * 10000000L, l5, fileChannel)));
                if (l6 != l4) {
                    throw new RuntimeException(ErrorMessage.MP3_UNABLE_TO_ADJUST_PADDING.getMsg(l4, l6));
                }
            }
            l2 = file.lastModified();
            if (fileChannel2 != null && fileChannel2.isOpen()) {
                fileChannel2.close();
            }
            if (fileChannel != null && fileChannel.isOpen()) {
                fileChannel.close();
            }
            this.replaceFile(file, file2);
            file2.setLastModified(l2);
        }
        catch (UnableToRenameFileException unableToRenameFileException) {
            file2.delete();
            throw unableToRenameFileException;
        }
        finally {
            try {
                if (fileChannel2 != null && fileChannel2.isOpen()) {
                    fileChannel2.close();
                }
                if (fileChannel != null && fileChannel.isOpen()) {
                    fileChannel.close();
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Problem closing channels and locks:" + exception.getMessage(), exception);
            }
        }
    }

    protected void writeBufferToFile(File file, ByteBuffer byteBuffer, byte[] byArray, int n, int n2, long l) throws IOException {
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        if ((long)n2 > l) {
            logger.finest("Adjusting Padding");
            this.adjustPadding(file, n2, l);
        }
        try {
            fileChannel = new RandomAccessFile(file, "rws").getChannel();
            fileLock = this.getFileLockForWriting(fileChannel, file.getPath());
            fileChannel.write(byteBuffer);
            fileChannel.write(ByteBuffer.wrap(byArray));
            fileChannel.write(ByteBuffer.wrap(new byte[n]));
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.SEVERE, this.getLoggingFilename() + fileNotFoundException.getMessage(), fileNotFoundException);
            if (fileNotFoundException.getMessage().equals(FileSystemMessage.ACCESS_IS_DENIED.getMsg())) {
                logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getPath()));
                throw new UnableToModifyFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getPath()));
            }
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getPath()));
            throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getPath()));
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, this.getLoggingFilename() + iOException.getMessage(), iOException);
            if (iOException.getMessage().equals(FileSystemMessage.ACCESS_IS_DENIED.getMsg())) {
                logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
                throw new UnableToModifyFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
            }
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
            throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
        }
        finally {
            if (fileChannel != null) {
                if (fileLock != null) {
                    fileLock.release();
                }
                fileChannel.close();
            }
        }
    }

    private void replaceFile(File file, File file2) throws IOException {
        File file3 = new File(file.getAbsoluteFile().getParentFile().getPath(), AudioFile.getBaseFilename(file) + ".old");
        int n = 1;
        while (file3.exists()) {
            file3 = new File(file.getAbsoluteFile().getParentFile().getPath(), AudioFile.getBaseFilename(file) + ".old" + n);
            ++n;
        }
        boolean bl = file.renameTo(file3);
        if (!bl) {
            logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_FILE_TO_BACKUP.getMsg(file.getAbsolutePath(), file3.getName()));
            file2.delete();
            throw new UnableToRenameFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_FILE_TO_BACKUP.getMsg(file.getAbsolutePath(), file3.getName()));
        }
        boolean bl2 = file2.renameTo(file);
        if (!bl2) {
            if (!file2.exists()) {
                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_NEW_FILE_DOESNT_EXIST.getMsg(file2.getAbsolutePath()));
            }
            if (!(bl = file3.renameTo(file))) {
                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_BACKUP_TO_ORIGINAL.getMsg(file3.getAbsolutePath(), file.getName()));
            }
            logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(file.getAbsolutePath(), file2.getName()));
            file2.delete();
            throw new UnableToRenameFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(file.getAbsolutePath(), file2.getName()));
        }
        boolean bl3 = file3.delete();
        if (!bl3) {
            logger.warning(ErrorMessage.GENERAL_WRITE_WARNING_UNABLE_TO_DELETE_BACKUP_FILE.getMsg(file3.getAbsolutePath()));
        }
    }

    protected void copyFrameIntoMap(String string, AbstractID3v2Frame abstractID3v2Frame) {
        if (this.frameMap.containsKey(abstractID3v2Frame.getIdentifier())) {
            Object object = this.frameMap.get(abstractID3v2Frame.getIdentifier());
            if (object instanceof AbstractID3v2Frame) {
                ArrayList<AbstractID3v2Frame> arrayList = new ArrayList<AbstractID3v2Frame>();
                arrayList.add((AbstractID3v2Frame)object);
                arrayList.add(abstractID3v2Frame);
                this.frameMap.put(abstractID3v2Frame.getIdentifier(), arrayList);
            } else {
                List list = (List)object;
                list.add(abstractID3v2Frame);
            }
        } else {
            this.frameMap.put(abstractID3v2Frame.getIdentifier(), abstractID3v2Frame);
        }
    }

    protected void loadFrameIntoMap(String string, AbstractID3v2Frame abstractID3v2Frame) {
        if (abstractID3v2Frame.getBody() instanceof FrameBodyEncrypted) {
            this.loadFrameIntoSpecifiedMap(this.encryptedFrameMap, string, abstractID3v2Frame);
        } else {
            this.loadFrameIntoSpecifiedMap(this.frameMap, string, abstractID3v2Frame);
        }
    }

    protected void loadFrameIntoSpecifiedMap(HashMap hashMap, String string, AbstractID3v2Frame abstractID3v2Frame) {
        if (ID3v24Frames.getInstanceOf().isMultipleAllowed(string) || ID3v23Frames.getInstanceOf().isMultipleAllowed(string) || ID3v22Frames.getInstanceOf().isMultipleAllowed(string)) {
            if (hashMap.containsKey(string)) {
                Object v = hashMap.get(string);
                if (v instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)v;
                    arrayList.add(abstractID3v2Frame);
                    logger.finer("Adding Multi Frame(1)" + string);
                } else {
                    ArrayList<AbstractID3v2Frame> arrayList = new ArrayList<AbstractID3v2Frame>();
                    arrayList.add((AbstractID3v2Frame)v);
                    arrayList.add(abstractID3v2Frame);
                    hashMap.put(string, arrayList);
                    logger.finer("Adding Multi Frame(2)" + string);
                }
            } else {
                logger.finer("Adding Multi FrameList(3)" + string);
                hashMap.put(string, abstractID3v2Frame);
            }
        } else if (hashMap.containsKey(string)) {
            logger.warning("Ignoring Duplicate Frame:" + string);
            if (this.duplicateFrameId.length() > 0) {
                this.duplicateFrameId = this.duplicateFrameId + ";";
            }
            this.duplicateFrameId = this.duplicateFrameId + string;
            this.duplicateBytes += ((AbstractID3v2Frame)this.frameMap.get(string)).getSize();
        } else {
            logger.finer("Adding Frame" + string);
            hashMap.put(string, abstractID3v2Frame);
        }
    }

    @Override
    public int getSize() {
        int n = 0;
        for (Object object : this.frameMap.values()) {
            AbstractID3v2Frame abstractID3v2Frame;
            if (object instanceof AbstractID3v2Frame) {
                abstractID3v2Frame = (AbstractID3v2Frame)object;
                n += abstractID3v2Frame.getSize();
                continue;
            }
            ArrayList arrayList = (ArrayList)object;
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                abstractID3v2Frame = (AbstractID3v2Frame)listIterator.next();
                n += abstractID3v2Frame.getSize();
            }
        }
        return n;
    }

    protected ByteArrayOutputStream writeFramesToBuffer() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeFramesToBufferStream(this.frameMap, byteArrayOutputStream);
        this.writeFramesToBufferStream(this.encryptedFrameMap, byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    private void writeFramesToBufferStream(Map map, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        TreeSet treeSet = new TreeSet(this.getPreferredFrameOrderComparator());
        treeSet.addAll(map.keySet());
        for (String string : treeSet) {
            Object object;
            Object v = map.get(string);
            if (v instanceof AbstractID3v2Frame) {
                AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)v;
                abstractID3v2Frame.setLoggingFilename(this.getLoggingFilename());
                abstractID3v2Frame.write(byteArrayOutputStream);
                continue;
            }
            if (v instanceof AggregatedFrame) {
                object = (AggregatedFrame)v;
                for (AbstractID3v2Frame abstractID3v2Frame : ((AggregatedFrame)object).getFrames()) {
                    abstractID3v2Frame.setLoggingFilename(this.getLoggingFilename());
                    abstractID3v2Frame.write(byteArrayOutputStream);
                }
                continue;
            }
            object = (List)v;
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                AbstractID3v2Frame abstractID3v2Frame;
                abstractID3v2Frame = (AbstractID3v2Frame)iterator.next();
                abstractID3v2Frame.setLoggingFilename(this.getLoggingFilename());
                abstractID3v2Frame.write(byteArrayOutputStream);
            }
        }
    }

    public abstract Comparator getPreferredFrameOrderComparator();

    public void createStructure() {
        this.createStructureHeader();
        this.createStructureBody();
    }

    public void createStructureHeader() {
        MP3File.getStructureFormatter().addElement(TYPE_DUPLICATEBYTES, this.duplicateBytes);
        MP3File.getStructureFormatter().addElement(TYPE_DUPLICATEFRAMEID, this.duplicateFrameId);
        MP3File.getStructureFormatter().addElement(TYPE_EMPTYFRAMEBYTES, this.emptyFrameBytes);
        MP3File.getStructureFormatter().addElement(TYPE_FILEREADSIZE, this.fileReadSize);
        MP3File.getStructureFormatter().addElement(TYPE_INVALIDFRAMES, this.invalidFrames);
    }

    public void createStructureBody() {
        MP3File.getStructureFormatter().openHeadingElement(TYPE_BODY, "");
        for (Object object : this.frameMap.values()) {
            AbstractID3v2Frame abstractID3v2Frame;
            if (object instanceof AbstractID3v2Frame) {
                abstractID3v2Frame = (AbstractID3v2Frame)object;
                abstractID3v2Frame.createStructure();
                continue;
            }
            ArrayList arrayList = (ArrayList)object;
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                abstractID3v2Frame = (AbstractID3v2Frame)listIterator.next();
                abstractID3v2Frame.createStructure();
            }
        }
        MP3File.getStructureFormatter().closeHeadingElement(TYPE_BODY);
    }

    @Override
    public List<String> getAll(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == FieldKey.TRACK || fieldKey == FieldKey.TRACK_TOTAL || fieldKey == FieldKey.DISC_NO || fieldKey == FieldKey.DISC_TOTAL) {
            ArrayList<String> arrayList = new ArrayList<String>();
            List<TagField> list = this.getFields(fieldKey);
            if (list != null && list.size() > 0) {
                AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)list.get(0);
                if (fieldKey == FieldKey.TRACK) {
                    arrayList.add(((FrameBodyTRCK)abstractID3v2Frame.getBody()).getTrackNoAsText());
                } else if (fieldKey == FieldKey.TRACK_TOTAL) {
                    arrayList.add(((FrameBodyTRCK)abstractID3v2Frame.getBody()).getTrackTotalAsText());
                } else if (fieldKey == FieldKey.DISC_NO) {
                    arrayList.add(((FrameBodyTPOS)abstractID3v2Frame.getBody()).getDiscNoAsText());
                } else if (fieldKey == FieldKey.DISC_TOTAL) {
                    arrayList.add(((FrameBodyTPOS)abstractID3v2Frame.getBody()).getDiscTotalAsText());
                } else if (fieldKey == FieldKey.RATING) {
                    arrayList.add(String.valueOf(((FrameBodyPOPM)abstractID3v2Frame.getBody()).getRating()));
                }
            }
            return arrayList;
        }
        return this.doGetValues(this.getFrameAndSubIdFromGenericKey(fieldKey));
    }

    @Override
    public List<TagField> getFields(String string) throws KeyNotFoundException {
        Object object = this.getFrame(string);
        if (object == null) {
            return new ArrayList<TagField>();
        }
        if (object instanceof List) {
            return (List)object;
        }
        if (object instanceof AbstractID3v2Frame) {
            ArrayList<TagField> arrayList = new ArrayList<TagField>();
            arrayList.add((TagField)object);
            return arrayList;
        }
        throw new RuntimeException("Found entry in frameMap that was not a frame or a list:" + object);
    }

    public abstract AbstractID3v2Frame createFrame(String var1);

    @Override
    public boolean hasCommonFields() {
        return true;
    }

    @Override
    public boolean hasField(FieldKey fieldKey) {
        if (fieldKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        try {
            return this.getFirstField(fieldKey) != null;
        }
        catch (KeyNotFoundException keyNotFoundException) {
            logger.log(Level.SEVERE, keyNotFoundException.getMessage(), keyNotFoundException);
            return false;
        }
    }

    @Override
    public boolean hasField(String string) {
        return this.hasFrame(string);
    }

    @Override
    public boolean isEmpty() {
        return this.frameMap.size() == 0;
    }

    @Override
    public Iterator<TagField> getFields() {
        final Iterator<Map.Entry<String, Object>> iterator = this.frameMap.entrySet().iterator();
        final Iterator<Map.Entry<String, Object>> iterator2 = this.frameMap.entrySet().iterator();
        return new Iterator<TagField>(){
            Map.Entry<String, Object> latestEntry = null;
            private Iterator<TagField> fieldsIt;

            private void changeIt() {
                if (!iterator.hasNext()) {
                    return;
                }
                while (iterator.hasNext()) {
                    ArrayList<TagField> arrayList;
                    Map.Entry entry = (Map.Entry)iterator.next();
                    this.latestEntry = (Map.Entry)iterator2.next();
                    if (entry.getValue() instanceof List) {
                        arrayList = (ArrayList<TagField>)entry.getValue();
                        if (arrayList.size() == 0) continue;
                        this.fieldsIt = arrayList.iterator();
                        break;
                    }
                    arrayList = new ArrayList<TagField>();
                    arrayList.add((TagField)entry.getValue());
                    this.fieldsIt = arrayList.iterator();
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.fieldsIt != null && this.fieldsIt.hasNext()) {
                    return true;
                }
                if (!iterator2.hasNext()) {
                    return false;
                }
                return iterator2.hasNext();
            }

            @Override
            public TagField next() {
                if (this.fieldsIt == null) {
                    this.changeIt();
                }
                if (this.fieldsIt != null && !this.fieldsIt.hasNext()) {
                    this.changeIt();
                }
                if (this.fieldsIt == null) {
                    throw new NoSuchElementException();
                }
                return this.fieldsIt.next();
            }

            @Override
            public void remove() {
                this.fieldsIt.remove();
            }
        };
    }

    @Override
    public int getFieldCount() {
        Iterator<TagField> iterator = this.getFields();
        int n = 0;
        try {
            while (true) {
                TagField tagField = iterator.next();
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return n;
        }
    }

    @Override
    public int getFieldCountIncludingSubValues() {
        Iterator<TagField> iterator = this.getFields();
        int n = 0;
        try {
            while (true) {
                AbstractID3v2Frame abstractID3v2Frame;
                TagField tagField;
                if ((tagField = iterator.next()) instanceof AbstractID3v2Frame && (abstractID3v2Frame = (AbstractID3v2Frame)tagField).getBody() instanceof AbstractFrameBodyTextInfo && !(abstractID3v2Frame.getBody() instanceof FrameBodyTXXX)) {
                    AbstractFrameBodyTextInfo abstractFrameBodyTextInfo = (AbstractFrameBodyTextInfo)abstractID3v2Frame.getBody();
                    n += abstractFrameBodyTextInfo.getNumberOfValues();
                    continue;
                }
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return n;
        }
    }

    @Override
    public boolean setEncoding(String string) throws FieldDataInvalidException {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    @Override
    public String getFirst(FieldKey fieldKey) throws KeyNotFoundException {
        return this.getValue(fieldKey, 0);
    }

    @Override
    public String getValue(FieldKey fieldKey, int n) throws KeyNotFoundException {
        AbstractID3v2Frame abstractID3v2Frame;
        List<TagField> list;
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        if (fieldKey == FieldKey.TRACK || fieldKey == FieldKey.TRACK_TOTAL || fieldKey == FieldKey.DISC_NO || fieldKey == FieldKey.DISC_TOTAL) {
            list = this.getFields(fieldKey);
            if (list != null && list.size() > 0) {
                abstractID3v2Frame = (AbstractID3v2Frame)list.get(0);
                if (fieldKey == FieldKey.TRACK) {
                    return ((FrameBodyTRCK)abstractID3v2Frame.getBody()).getTrackNoAsText();
                }
                if (fieldKey == FieldKey.TRACK_TOTAL) {
                    return ((FrameBodyTRCK)abstractID3v2Frame.getBody()).getTrackTotalAsText();
                }
                if (fieldKey == FieldKey.DISC_NO) {
                    return ((FrameBodyTPOS)abstractID3v2Frame.getBody()).getDiscNoAsText();
                }
                if (fieldKey == FieldKey.DISC_TOTAL) {
                    return ((FrameBodyTPOS)abstractID3v2Frame.getBody()).getDiscTotalAsText();
                }
            } else {
                return "";
            }
        }
        if (fieldKey == FieldKey.RATING) {
            list = this.getFields(fieldKey);
            if (list != null && list.size() > n) {
                abstractID3v2Frame = (AbstractID3v2Frame)list.get(n);
                return String.valueOf(((FrameBodyPOPM)abstractID3v2Frame.getBody()).getRating());
            }
            return "";
        }
        list = this.getFrameAndSubIdFromGenericKey(fieldKey);
        return this.doGetValueAtIndex((FrameAndSubId)((Object)list), n);
    }

    @Override
    public TagField createField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        FrameAndSubId frameAndSubId = this.getFrameAndSubIdFromGenericKey(fieldKey);
        if (fieldKey == FieldKey.TRACK) {
            AbstractID3v2Frame abstractID3v2Frame = this.createFrame(frameAndSubId.getFrameId());
            FrameBodyTRCK frameBodyTRCK = (FrameBodyTRCK)abstractID3v2Frame.getBody();
            frameBodyTRCK.setTrackNo(string);
            return abstractID3v2Frame;
        }
        if (fieldKey == FieldKey.TRACK_TOTAL) {
            AbstractID3v2Frame abstractID3v2Frame = this.createFrame(frameAndSubId.getFrameId());
            FrameBodyTRCK frameBodyTRCK = (FrameBodyTRCK)abstractID3v2Frame.getBody();
            frameBodyTRCK.setTrackTotal(string);
            return abstractID3v2Frame;
        }
        if (fieldKey == FieldKey.DISC_NO) {
            AbstractID3v2Frame abstractID3v2Frame = this.createFrame(frameAndSubId.getFrameId());
            FrameBodyTPOS frameBodyTPOS = (FrameBodyTPOS)abstractID3v2Frame.getBody();
            frameBodyTPOS.setDiscNo(string);
            return abstractID3v2Frame;
        }
        if (fieldKey == FieldKey.DISC_TOTAL) {
            AbstractID3v2Frame abstractID3v2Frame = this.createFrame(frameAndSubId.getFrameId());
            FrameBodyTPOS frameBodyTPOS = (FrameBodyTPOS)abstractID3v2Frame.getBody();
            frameBodyTPOS.setDiscTotal(string);
            return abstractID3v2Frame;
        }
        return this.doCreateTagField(frameAndSubId, string);
    }

    protected TagField doCreateTagField(FrameAndSubId frameAndSubId, String string) throws KeyNotFoundException, FieldDataInvalidException {
        AbstractID3v2Frame abstractID3v2Frame = this.createFrame(frameAndSubId.getFrameId());
        if (abstractID3v2Frame.getBody() instanceof FrameBodyUFID) {
            ((FrameBodyUFID)abstractID3v2Frame.getBody()).setOwner(frameAndSubId.getSubId());
            try {
                ((FrameBodyUFID)abstractID3v2Frame.getBody()).setUniqueIdentifier(string.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("When encoding UFID charset ISO-8859-1 was deemed unsupported");
            }
        } else if (abstractID3v2Frame.getBody() instanceof FrameBodyTXXX) {
            ((FrameBodyTXXX)abstractID3v2Frame.getBody()).setDescription(frameAndSubId.getSubId());
            ((FrameBodyTXXX)abstractID3v2Frame.getBody()).setText(string);
        } else if (abstractID3v2Frame.getBody() instanceof FrameBodyWXXX) {
            ((FrameBodyWXXX)abstractID3v2Frame.getBody()).setDescription(frameAndSubId.getSubId());
            ((FrameBodyWXXX)abstractID3v2Frame.getBody()).setUrlLink(string);
        } else if (abstractID3v2Frame.getBody() instanceof FrameBodyCOMM) {
            if (frameAndSubId.getSubId() != null) {
                ((FrameBodyCOMM)abstractID3v2Frame.getBody()).setDescription(frameAndSubId.getSubId());
                if (((FrameBodyCOMM)abstractID3v2Frame.getBody()).isMediaMonkeyFrame()) {
                    ((FrameBodyCOMM)abstractID3v2Frame.getBody()).setLanguage("XXX");
                }
            }
            ((FrameBodyCOMM)abstractID3v2Frame.getBody()).setText(string);
        } else if (abstractID3v2Frame.getBody() instanceof FrameBodyUSLT) {
            ((FrameBodyUSLT)abstractID3v2Frame.getBody()).setDescription("");
            ((FrameBodyUSLT)abstractID3v2Frame.getBody()).setLyric(string);
        } else if (abstractID3v2Frame.getBody() instanceof FrameBodyWOAR) {
            ((FrameBodyWOAR)abstractID3v2Frame.getBody()).setUrlLink(string);
        } else if (abstractID3v2Frame.getBody() instanceof AbstractFrameBodyTextInfo) {
            ((AbstractFrameBodyTextInfo)abstractID3v2Frame.getBody()).setText(string);
        } else if (abstractID3v2Frame.getBody() instanceof FrameBodyPOPM) {
            ((FrameBodyPOPM)abstractID3v2Frame.getBody()).parseString(string);
        } else if (abstractID3v2Frame.getBody() instanceof FrameBodyIPLS) {
            PairedTextEncodedStringNullTerminated.ValuePairs valuePairs = new PairedTextEncodedStringNullTerminated.ValuePairs();
            valuePairs.add(frameAndSubId.getSubId(), string);
            abstractID3v2Frame.getBody().setObjectValue("Text", valuePairs);
        } else if (abstractID3v2Frame.getBody() instanceof FrameBodyTIPL) {
            PairedTextEncodedStringNullTerminated.ValuePairs valuePairs = new PairedTextEncodedStringNullTerminated.ValuePairs();
            valuePairs.add(frameAndSubId.getSubId(), string);
            abstractID3v2Frame.getBody().setObjectValue("Text", valuePairs);
        } else {
            if (abstractID3v2Frame.getBody() instanceof FrameBodyAPIC || abstractID3v2Frame.getBody() instanceof FrameBodyPIC) {
                throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
            }
            throw new FieldDataInvalidException("Field with key of:" + frameAndSubId.getFrameId() + ":does not accept cannot parse data:" + string);
        }
        return abstractID3v2Frame;
    }

    protected List<String> doGetValues(FrameAndSubId frameAndSubId) throws KeyNotFoundException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (frameAndSubId.getSubId() == null) {
            List<TagField> list = this.getFields(frameAndSubId.getFrameId());
            for (TagField tagField : list) {
                AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)tagField;
                if (abstractID3v2Frame == null) continue;
                if (abstractID3v2Frame.getBody() instanceof AbstractFrameBodyTextInfo) {
                    AbstractFrameBodyTextInfo abstractFrameBodyTextInfo = (AbstractFrameBodyTextInfo)abstractID3v2Frame.getBody();
                    arrayList.addAll(abstractFrameBodyTextInfo.getValues());
                    continue;
                }
                arrayList.add(this.getTextValueForFrame(abstractID3v2Frame));
            }
            return arrayList;
        }
        List<TagField> list = this.getFields(frameAndSubId.getFrameId());
        ListIterator<TagField> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            AbstractTagFrameBody abstractTagFrameBody = ((AbstractID3v2Frame)listIterator.next()).getBody();
            if (abstractTagFrameBody instanceof FrameBodyTXXX) {
                if (!((FrameBodyTXXX)abstractTagFrameBody).getDescription().equals(frameAndSubId.getSubId())) continue;
                arrayList.addAll(((FrameBodyTXXX)abstractTagFrameBody).getValues());
                continue;
            }
            if (abstractTagFrameBody instanceof FrameBodyWXXX) {
                if (!((FrameBodyWXXX)abstractTagFrameBody).getDescription().equals(frameAndSubId.getSubId())) continue;
                arrayList.addAll(((FrameBodyWXXX)abstractTagFrameBody).getUrlLinks());
                continue;
            }
            if (abstractTagFrameBody instanceof FrameBodyCOMM) {
                if (!((FrameBodyCOMM)abstractTagFrameBody).getDescription().equals(frameAndSubId.getSubId())) continue;
                arrayList.addAll(((FrameBodyCOMM)abstractTagFrameBody).getValues());
                continue;
            }
            if (abstractTagFrameBody instanceof FrameBodyUFID) {
                if (!((FrameBodyUFID)abstractTagFrameBody).getOwner().equals(frameAndSubId.getSubId())) continue;
                arrayList.add(new String(((FrameBodyUFID)abstractTagFrameBody).getUniqueIdentifier()));
                continue;
            }
            if (abstractTagFrameBody instanceof FrameBodyIPLS) {
                for (Pair pair : ((FrameBodyIPLS)abstractTagFrameBody).getPairing().getMapping()) {
                    if (!pair.getKey().equals(frameAndSubId.getSubId())) continue;
                    arrayList.add(pair.getValue());
                }
                continue;
            }
            if (abstractTagFrameBody instanceof FrameBodyTIPL) {
                for (Pair pair : ((FrameBodyTIPL)abstractTagFrameBody).getPairing().getMapping()) {
                    if (!pair.getKey().equals(frameAndSubId.getSubId())) continue;
                    arrayList.add(pair.getValue());
                }
                continue;
            }
            throw new RuntimeException("Need to implement getFields(FieldKey genericKey) for:" + abstractTagFrameBody.getClass());
        }
        return arrayList;
    }

    protected String doGetValueAtIndex(FrameAndSubId frameAndSubId, int n) throws KeyNotFoundException {
        List<String> list = this.doGetValues(frameAndSubId);
        if (list.size() > n) {
            return list.get(n);
        }
        return "";
    }

    public TagField createLinkedArtworkField(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        if (abstractID3v2Frame.getBody() instanceof FrameBodyAPIC) {
            FrameBodyAPIC frameBodyAPIC = (FrameBodyAPIC)abstractID3v2Frame.getBody();
            frameBodyAPIC.setObjectValue("PictureData", Utils.getDefaultBytes(string, "ISO-8859-1"));
            frameBodyAPIC.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
            frameBodyAPIC.setObjectValue("MIMEType", "-->");
            frameBodyAPIC.setObjectValue("Description", "");
        } else if (abstractID3v2Frame.getBody() instanceof FrameBodyPIC) {
            FrameBodyPIC frameBodyPIC = (FrameBodyPIC)abstractID3v2Frame.getBody();
            frameBodyPIC.setObjectValue("PictureData", Utils.getDefaultBytes(string, "ISO-8859-1"));
            frameBodyPIC.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
            frameBodyPIC.setObjectValue("ImageType", "-->");
            frameBodyPIC.setObjectValue("Description", "");
        }
        return abstractID3v2Frame;
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        FrameAndSubId frameAndSubId = this.getFrameAndSubIdFromGenericKey(fieldKey);
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        if (fieldKey == FieldKey.TRACK) {
            String string = this.getFirst(FieldKey.TRACK_TOTAL);
            if (string.length() == 0) {
                this.doDeleteTagField(frameAndSubId);
                return;
            }
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)this.getFrame(frameAndSubId.getFrameId());
            FrameBodyTRCK frameBodyTRCK = (FrameBodyTRCK)abstractID3v2Frame.getBody();
            frameBodyTRCK.setTrackNo(0);
            return;
        }
        if (fieldKey == FieldKey.TRACK_TOTAL) {
            String string = this.getFirst(FieldKey.TRACK);
            if (string.length() == 0) {
                this.doDeleteTagField(frameAndSubId);
                return;
            }
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)this.getFrame(frameAndSubId.getFrameId());
            FrameBodyTRCK frameBodyTRCK = (FrameBodyTRCK)abstractID3v2Frame.getBody();
            frameBodyTRCK.setTrackTotal(0);
            return;
        }
        if (fieldKey == FieldKey.DISC_NO) {
            String string = this.getFirst(FieldKey.DISC_TOTAL);
            if (string.length() == 0) {
                this.doDeleteTagField(frameAndSubId);
                return;
            }
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)this.getFrame(frameAndSubId.getFrameId());
            FrameBodyTPOS frameBodyTPOS = (FrameBodyTPOS)abstractID3v2Frame.getBody();
            frameBodyTPOS.setDiscNo(0);
            return;
        }
        if (fieldKey == FieldKey.DISC_TOTAL) {
            String string = this.getFirst(FieldKey.DISC_NO);
            if (string.length() == 0) {
                this.doDeleteTagField(frameAndSubId);
                return;
            }
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)this.getFrame(frameAndSubId.getFrameId());
            FrameBodyTPOS frameBodyTPOS = (FrameBodyTPOS)abstractID3v2Frame.getBody();
            frameBodyTPOS.setDiscTotal(0);
            return;
        }
        this.doDeleteTagField(frameAndSubId);
    }

    protected void doDeleteTagField(FrameAndSubId frameAndSubId) throws KeyNotFoundException {
        if (frameAndSubId.getSubId() == null) {
            this.removeFrame(frameAndSubId.getFrameId());
        } else {
            List<TagField> list = this.getFields(frameAndSubId.getFrameId());
            ListIterator<TagField> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Pair pair;
                ListIterator<Pair> listIterator2;
                PairedTextEncodedStringNullTerminated.ValuePairs valuePairs;
                AbstractTagFrameBody abstractTagFrameBody = ((AbstractID3v2Frame)listIterator.next()).getBody();
                if (abstractTagFrameBody instanceof FrameBodyTXXX) {
                    if (!((FrameBodyTXXX)abstractTagFrameBody).getDescription().equals(frameAndSubId.getSubId())) continue;
                    if (list.size() == 1) {
                        this.removeFrame(frameAndSubId.getFrameId());
                        continue;
                    }
                    listIterator.remove();
                    continue;
                }
                if (abstractTagFrameBody instanceof FrameBodyCOMM) {
                    if (!((FrameBodyCOMM)abstractTagFrameBody).getDescription().equals(frameAndSubId.getSubId())) continue;
                    if (list.size() == 1) {
                        this.removeFrame(frameAndSubId.getFrameId());
                        continue;
                    }
                    listIterator.remove();
                    continue;
                }
                if (abstractTagFrameBody instanceof FrameBodyWXXX) {
                    if (!((FrameBodyWXXX)abstractTagFrameBody).getDescription().equals(frameAndSubId.getSubId())) continue;
                    if (list.size() == 1) {
                        this.removeFrame(frameAndSubId.getFrameId());
                        continue;
                    }
                    listIterator.remove();
                    continue;
                }
                if (abstractTagFrameBody instanceof FrameBodyUFID) {
                    if (!((FrameBodyUFID)abstractTagFrameBody).getOwner().equals(frameAndSubId.getSubId())) continue;
                    if (list.size() == 1) {
                        this.removeFrame(frameAndSubId.getFrameId());
                        continue;
                    }
                    listIterator.remove();
                    continue;
                }
                if (abstractTagFrameBody instanceof FrameBodyTIPL) {
                    valuePairs = ((FrameBodyTIPL)abstractTagFrameBody).getPairing();
                    listIterator2 = valuePairs.getMapping().listIterator();
                    while (listIterator2.hasNext()) {
                        pair = listIterator2.next();
                        if (!pair.getKey().equals(frameAndSubId.getSubId())) continue;
                        listIterator2.remove();
                    }
                    if (valuePairs.getMapping().size() != 0) continue;
                    this.removeFrame(frameAndSubId.getFrameId());
                    continue;
                }
                if (abstractTagFrameBody instanceof FrameBodyIPLS) {
                    valuePairs = ((FrameBodyIPLS)abstractTagFrameBody).getPairing();
                    listIterator2 = valuePairs.getMapping().listIterator();
                    while (listIterator2.hasNext()) {
                        pair = listIterator2.next();
                        if (!pair.getKey().equals(frameAndSubId.getSubId())) continue;
                        listIterator2.remove();
                    }
                    if (valuePairs.getMapping().size() != 0) continue;
                    this.removeFrame(frameAndSubId.getFrameId());
                    continue;
                }
                throw new RuntimeException("Need to implement getFields(FieldKey genericKey) for:" + abstractTagFrameBody.getClass());
            }
        }
    }

    protected abstract FrameAndSubId getFrameAndSubIdFromGenericKey(FieldKey var1);

    @Override
    public List<TagField> getFields(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        FrameAndSubId frameAndSubId = this.getFrameAndSubIdFromGenericKey(fieldKey);
        List<TagField> list = this.getFields(frameAndSubId.getFrameId());
        ArrayList<TagField> arrayList = new ArrayList<TagField>();
        String string = frameAndSubId.getSubId();
        if (string != null) {
            for (TagField tagField : list) {
                AbstractTagFrameBody abstractTagFrameBody = ((AbstractID3v2Frame)tagField).getBody();
                if (abstractTagFrameBody instanceof FrameBodyTXXX) {
                    if (!((FrameBodyTXXX)abstractTagFrameBody).getDescription().equals(frameAndSubId.getSubId())) continue;
                    arrayList.add(tagField);
                    continue;
                }
                if (abstractTagFrameBody instanceof FrameBodyWXXX) {
                    if (!((FrameBodyWXXX)abstractTagFrameBody).getDescription().equals(frameAndSubId.getSubId())) continue;
                    arrayList.add(tagField);
                    continue;
                }
                if (abstractTagFrameBody instanceof FrameBodyCOMM) {
                    if (!((FrameBodyCOMM)abstractTagFrameBody).getDescription().equals(frameAndSubId.getSubId())) continue;
                    arrayList.add(tagField);
                    continue;
                }
                if (abstractTagFrameBody instanceof FrameBodyUFID) {
                    if (!((FrameBodyUFID)abstractTagFrameBody).getOwner().equals(frameAndSubId.getSubId())) continue;
                    arrayList.add(tagField);
                    continue;
                }
                if (abstractTagFrameBody instanceof FrameBodyIPLS) {
                    for (Pair pair : ((FrameBodyIPLS)abstractTagFrameBody).getPairing().getMapping()) {
                        if (!pair.getKey().equals(frameAndSubId.getSubId())) continue;
                        arrayList.add(tagField);
                    }
                    continue;
                }
                if (abstractTagFrameBody instanceof FrameBodyTIPL) {
                    for (Pair pair : ((FrameBodyTIPL)abstractTagFrameBody).getPairing().getMapping()) {
                        if (!pair.getKey().equals(frameAndSubId.getSubId())) continue;
                        arrayList.add(tagField);
                    }
                    continue;
                }
                throw new RuntimeException("Need to implement getFields(FieldKey genericKey) for:" + abstractTagFrameBody.getClass());
            }
            return arrayList;
        }
        if (fieldKey == FieldKey.TRACK) {
            for (TagField tagField : list) {
                AbstractTagFrameBody abstractTagFrameBody = ((AbstractID3v2Frame)tagField).getBody();
                if (!(abstractTagFrameBody instanceof FrameBodyTRCK) || ((FrameBodyTRCK)abstractTagFrameBody).getTrackNo() == null) continue;
                arrayList.add(tagField);
            }
            return arrayList;
        }
        if (fieldKey == FieldKey.TRACK_TOTAL) {
            for (TagField tagField : list) {
                AbstractTagFrameBody abstractTagFrameBody = ((AbstractID3v2Frame)tagField).getBody();
                if (!(abstractTagFrameBody instanceof FrameBodyTRCK) || ((FrameBodyTRCK)abstractTagFrameBody).getTrackTotal() == null) continue;
                arrayList.add(tagField);
            }
            return arrayList;
        }
        if (fieldKey == FieldKey.DISC_NO) {
            for (TagField tagField : list) {
                AbstractTagFrameBody abstractTagFrameBody = ((AbstractID3v2Frame)tagField).getBody();
                if (!(abstractTagFrameBody instanceof FrameBodyTPOS) || ((FrameBodyTPOS)abstractTagFrameBody).getDiscNo() == null) continue;
                arrayList.add(tagField);
            }
            return arrayList;
        }
        if (fieldKey == FieldKey.DISC_TOTAL) {
            for (TagField tagField : list) {
                AbstractTagFrameBody abstractTagFrameBody = ((AbstractID3v2Frame)tagField).getBody();
                if (!(abstractTagFrameBody instanceof FrameBodyTPOS) || ((FrameBodyTPOS)abstractTagFrameBody).getDiscTotal() == null) continue;
                arrayList.add(tagField);
            }
            return arrayList;
        }
        return list;
    }

    @Override
    public Artwork getFirstArtwork() {
        List<Artwork> list = this.getArtworkList();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        this.setField(this.createField(artwork));
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        this.addField(this.createField(artwork));
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        this.deleteField(FieldKey.COVER_ART);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tag content:\n");
        Iterator<TagField> iterator = this.getFields();
        while (iterator.hasNext()) {
            TagField tagField = iterator.next();
            stringBuilder.append("\t");
            stringBuilder.append(tagField.getId());
            stringBuilder.append(":");
            stringBuilder.append(tagField.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    class FrameAndSubId {
        private String frameId;
        private String subId;

        public FrameAndSubId(String string, String string2) {
            this.frameId = string;
            this.subId = string2;
        }

        public String getFrameId() {
            return this.frameId;
        }

        public String getSubId() {
            return this.subId;
        }
    }
}

