/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.nio.ByteBuffer;

public class ID3SyncSafeInteger {
    public static final int INTEGRAL_SIZE = 4;
    public static final int MAX_SAFE_SIZE = 127;

    private static int bufferToValue(byte[] byArray) {
        return ((byArray[0] & 0xFF) << 21) + ((byArray[1] & 0xFF) << 14) + ((byArray[2] & 0xFF) << 7) + (byArray[3] & 0xFF);
    }

    protected static int bufferToValue(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray, 0, 4);
        return ID3SyncSafeInteger.bufferToValue(byArray);
    }

    protected static boolean isBufferNotSyncSafe(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        for (int i = 0; i < 4; ++i) {
            byte by = byteBuffer.get(n + i);
            if ((by & 0x80) <= 0) continue;
            return true;
        }
        return false;
    }

    protected static boolean isBufferEmpty(byte[] byArray) {
        for (byte by : byArray) {
            if (by == 0) continue;
            return false;
        }
        return true;
    }

    protected static byte[] valueToBuffer(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFE00000) >> 21), (byte)((n & 0x1FC000) >> 14), (byte)((n & 0x3F80) >> 7), (byte)(n & 0x7F)};
        return byArray;
    }
}

