/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v1Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3v1FieldKey;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v1TagField;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTALB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCON;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRCK;

public class ID3v11Tag
extends ID3v1Tag {
    protected static final String TYPE_TRACK = "track";
    protected static final int TRACK_UNDEFINED = 0;
    protected static final int TRACK_MAX_VALUE = 255;
    protected static final int TRACK_MIN_VALUE = 1;
    protected static final int FIELD_COMMENT_LENGTH = 28;
    protected static final int FIELD_COMMENT_POS = 97;
    protected static final int FIELD_TRACK_INDICATOR_LENGTH = 1;
    protected static final int FIELD_TRACK_INDICATOR_POS = 125;
    protected static final int FIELD_TRACK_LENGTH = 1;
    protected static final int FIELD_TRACK_POS = 126;
    protected byte track = 0;
    private static final byte RELEASE = 1;
    private static final byte MAJOR_VERSION = 1;
    private static final byte REVISION = 0;

    @Override
    public byte getRelease() {
        return 1;
    }

    @Override
    public byte getMajorVersion() {
        return 1;
    }

    @Override
    public byte getRevision() {
        return 0;
    }

    public ID3v11Tag() {
    }

    @Override
    public int getFieldCount() {
        return 7;
    }

    public ID3v11Tag(ID3v11Tag iD3v11Tag) {
        super(iD3v11Tag);
        this.track = iD3v11Tag.track;
    }

    public ID3v11Tag(AbstractTag abstractTag) {
        if (abstractTag != null) {
            if (abstractTag instanceof ID3v1Tag) {
                if (abstractTag instanceof ID3v11Tag) {
                    throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
                }
                ID3v1Tag iD3v1Tag = (ID3v1Tag)abstractTag;
                this.title = iD3v1Tag.title;
                this.artist = iD3v1Tag.artist;
                this.album = iD3v1Tag.album;
                this.comment = iD3v1Tag.comment;
                this.year = iD3v1Tag.year;
                this.genre = iD3v1Tag.genre;
            } else {
                String string;
                ID3v24Frame iD3v24Frame;
                ID3v24Tag iD3v24Tag = !(abstractTag instanceof ID3v24Tag) ? new ID3v24Tag(abstractTag) : (ID3v24Tag)abstractTag;
                if (iD3v24Tag.hasFrame("TIT2")) {
                    iD3v24Frame = (ID3v24Frame)iD3v24Tag.getFrame("TIT2");
                    string = ((FrameBodyTIT2)iD3v24Frame.getBody()).getText();
                    this.title = ID3Tags.truncate(string, 30);
                }
                if (iD3v24Tag.hasFrame("TPE1")) {
                    iD3v24Frame = (ID3v24Frame)iD3v24Tag.getFrame("TPE1");
                    string = ((FrameBodyTPE1)iD3v24Frame.getBody()).getText();
                    this.artist = ID3Tags.truncate(string, 30);
                }
                if (iD3v24Tag.hasFrame("TALB")) {
                    iD3v24Frame = (ID3v24Frame)iD3v24Tag.getFrame("TALB");
                    string = ((FrameBodyTALB)iD3v24Frame.getBody()).getText();
                    this.album = ID3Tags.truncate(string, 30);
                }
                if (iD3v24Tag.hasFrame("TDRC")) {
                    iD3v24Frame = (ID3v24Frame)iD3v24Tag.getFrame("TDRC");
                    string = ((FrameBodyTDRC)iD3v24Frame.getBody()).getText();
                    this.year = ID3Tags.truncate(string, 4);
                }
                if (iD3v24Tag.hasFrame("COMM")) {
                    Iterator iterator = iD3v24Tag.getFrameOfType("COMM");
                    string = "";
                    while (iterator.hasNext()) {
                        iD3v24Frame = (ID3v24Frame)iterator.next();
                        string = string + ((FrameBodyCOMM)iD3v24Frame.getBody()).getText() + " ";
                    }
                    this.comment = ID3Tags.truncate(string, 28);
                }
                if (iD3v24Tag.hasFrame("TCON")) {
                    iD3v24Frame = (ID3v24Frame)iD3v24Tag.getFrame("TCON");
                    string = ((FrameBodyTCON)iD3v24Frame.getBody()).getText();
                    try {
                        this.genre = (byte)ID3Tags.findNumber(string);
                    }
                    catch (TagException tagException) {
                        logger.log(Level.WARNING, this.getLoggingFilename() + ":" + "Unable to convert TCON frame to format suitable for v11 tag", tagException);
                        this.genre = (byte)-1;
                    }
                }
                if (iD3v24Tag.hasFrame("TRCK")) {
                    iD3v24Frame = (ID3v24Frame)iD3v24Tag.getFrame("TRCK");
                    this.track = (byte)((FrameBodyTRCK)iD3v24Frame.getBody()).getTrackNo().intValue();
                }
            }
        }
    }

    public ID3v11Tag(RandomAccessFile randomAccessFile, String string) throws TagNotFoundException, IOException {
        this.setLoggingFilename(string);
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        FileChannel fileChannel = randomAccessFile.getChannel();
        fileChannel.position(randomAccessFile.length() - 128L);
        fileChannel.read(byteBuffer);
        byteBuffer.flip();
        this.read(byteBuffer);
    }

    public ID3v11Tag(RandomAccessFile randomAccessFile) throws TagNotFoundException, IOException {
        this(randomAccessFile, "");
    }

    @Override
    public void setComment(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.comment = ID3Tags.truncate(string, 28);
    }

    @Override
    public String getFirstComment() {
        return this.comment;
    }

    public void setTrack(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        this.track = n > 255 || n < 1 ? (byte)0 : (byte)Integer.parseInt(string);
    }

    @Override
    public String getFirstTrack() {
        return String.valueOf(this.track & 0xFF);
    }

    public void addTrack(String string) {
        this.setTrack(string);
    }

    @Override
    public List<TagField> getTrack() {
        if (this.getFirst(FieldKey.TRACK).length() > 0) {
            ID3v1TagField iD3v1TagField = new ID3v1TagField(ID3v1FieldKey.TRACK.name(), this.getFirst(FieldKey.TRACK));
            return this.returnFieldToList(iD3v1TagField);
        }
        return new ArrayList<TagField>();
    }

    @Override
    public void setField(TagField tagField) {
        FieldKey fieldKey = FieldKey.valueOf(tagField.getId());
        if (fieldKey == FieldKey.TRACK) {
            this.setTrack(tagField.toString());
        } else {
            super.setField(tagField);
        }
    }

    @Override
    public List<TagField> getFields(FieldKey fieldKey) {
        if (fieldKey == FieldKey.TRACK) {
            return this.getTrack();
        }
        return super.getFields(fieldKey);
    }

    @Override
    public String getFirst(FieldKey fieldKey) {
        switch (fieldKey) {
            case ARTIST: {
                return this.getFirstArtist();
            }
            case ALBUM: {
                return this.getFirstAlbum();
            }
            case TITLE: {
                return this.getFirstTitle();
            }
            case GENRE: {
                return this.getFirstGenre();
            }
            case YEAR: {
                return this.getFirstYear();
            }
            case TRACK: {
                return this.getFirstTrack();
            }
            case COMMENT: {
                return this.getFirstComment();
            }
        }
        return "";
    }

    @Override
    public TagField getFirstField(String string) {
        if (FieldKey.TRACK.name().equals(string)) {
            List<TagField> list = this.getTrack();
            if (list != null && list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
        return super.getFirstField(string);
    }

    @Override
    public boolean isEmpty() {
        return this.track <= 0 && super.isEmpty();
    }

    @Override
    public void deleteField(FieldKey fieldKey) {
        if (fieldKey == FieldKey.TRACK) {
            this.track = 0;
        } else {
            super.deleteField(fieldKey);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ID3v11Tag)) {
            return false;
        }
        ID3v11Tag iD3v11Tag = (ID3v11Tag)object;
        return this.track == iD3v11Tag.track && super.equals(object);
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[3];
        byteBuffer.get(byArray, 0, 3);
        if (!Arrays.equals(byArray, TAG_ID)) {
            return false;
        }
        byteBuffer.position(125);
        if (byteBuffer.get() != 0) {
            return false;
        }
        return byteBuffer.get() != 0;
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagNotFoundException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException("ID3v1 tag not found");
        }
        logger.finer("Reading v1.1 tag");
        byte[] byArray = new byte[128];
        byteBuffer.position(0);
        byteBuffer.get(byArray, 0, 128);
        this.title = Utils.getString(byArray, 3, 30, "ISO-8859-1").trim();
        Matcher matcher = AbstractID3v1Tag.endofStringPattern.matcher(this.title);
        if (matcher.find()) {
            this.title = this.title.substring(0, matcher.start());
        }
        this.artist = Utils.getString(byArray, 33, 30, "ISO-8859-1").trim();
        matcher = AbstractID3v1Tag.endofStringPattern.matcher(this.artist);
        if (matcher.find()) {
            this.artist = this.artist.substring(0, matcher.start());
        }
        this.album = Utils.getString(byArray, 63, 30, "ISO-8859-1").trim();
        matcher = AbstractID3v1Tag.endofStringPattern.matcher(this.album);
        if (matcher.find()) {
            this.album = this.album.substring(0, matcher.start());
        }
        this.year = Utils.getString(byArray, 93, 4, "ISO-8859-1").trim();
        matcher = AbstractID3v1Tag.endofStringPattern.matcher(this.year);
        if (matcher.find()) {
            this.year = this.year.substring(0, matcher.start());
        }
        this.comment = Utils.getString(byArray, 97, 28, "ISO-8859-1").trim();
        matcher = AbstractID3v1Tag.endofStringPattern.matcher(this.comment);
        if (matcher.find()) {
            this.comment = this.comment.substring(0, matcher.start());
        }
        this.track = byArray[126];
        this.genre = byArray[127];
    }

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        String string;
        logger.config("Saving ID3v11 tag to file");
        byte[] byArray = new byte[128];
        this.delete(randomAccessFile);
        randomAccessFile.seek(randomAccessFile.length());
        System.arraycopy(TAG_ID, 0, byArray, 0, TAG_ID.length);
        int n2 = 3;
        if (TagOptionSingleton.getInstance().isId3v1SaveTitle()) {
            string = ID3Tags.truncate(this.title, 30);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 = 33;
        if (TagOptionSingleton.getInstance().isId3v1SaveArtist()) {
            string = ID3Tags.truncate(this.artist, 30);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 = 63;
        if (TagOptionSingleton.getInstance().isId3v1SaveAlbum()) {
            string = ID3Tags.truncate(this.album, 30);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 = 93;
        if (TagOptionSingleton.getInstance().isId3v1SaveYear()) {
            string = ID3Tags.truncate(this.year, 4);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 = 97;
        if (TagOptionSingleton.getInstance().isId3v1SaveComment()) {
            string = ID3Tags.truncate(this.comment, 28);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 = 126;
        byArray[n2] = this.track;
        n2 = 127;
        if (TagOptionSingleton.getInstance().isId3v1SaveGenre()) {
            byArray[n2] = this.genre;
        }
        randomAccessFile.write(byArray);
        logger.config("Saved ID3v11 tag to file");
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("title", this.title);
        MP3File.getStructureFormatter().addElement("artist", this.artist);
        MP3File.getStructureFormatter().addElement("album", this.album);
        MP3File.getStructureFormatter().addElement("year", this.year);
        MP3File.getStructureFormatter().addElement("comment", this.comment);
        MP3File.getStructureFormatter().addElement(TYPE_TRACK, this.track);
        MP3File.getStructureFormatter().addElement("genre", this.genre);
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }
}

