/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v1Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1FieldKey;
import org.jaudiotagger.tag.id3.ID3v1Iterator;
import org.jaudiotagger.tag.id3.ID3v1TagField;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.reference.GenreTypes;

public class ID3v1Tag
extends AbstractID3v1Tag
implements Tag {
    static EnumMap<FieldKey, ID3v1FieldKey> tagFieldToID3v1Field = new EnumMap(FieldKey.class);
    protected static final String TYPE_COMMENT = "comment";
    protected static final int FIELD_COMMENT_LENGTH = 30;
    protected static final int FIELD_COMMENT_POS = 97;
    protected static final int BYTE_TO_UNSIGNED = 255;
    protected static final int GENRE_UNDEFINED = 255;
    protected String album = "";
    protected String artist = "";
    protected String comment = "";
    protected String title = "";
    protected String year = "";
    protected byte genre = (byte)-1;
    private static final byte RELEASE = 1;
    private static final byte MAJOR_VERSION = 0;
    private static final byte REVISION = 0;

    @Override
    public byte getRelease() {
        return 1;
    }

    @Override
    public byte getMajorVersion() {
        return 0;
    }

    @Override
    public byte getRevision() {
        return 0;
    }

    public ID3v1Tag() {
    }

    public ID3v1Tag(ID3v1Tag iD3v1Tag) {
        super(iD3v1Tag);
        this.album = iD3v1Tag.album;
        this.artist = iD3v1Tag.artist;
        this.comment = iD3v1Tag.comment;
        this.title = iD3v1Tag.title;
        this.year = iD3v1Tag.year;
        this.genre = iD3v1Tag.genre;
    }

    public ID3v1Tag(AbstractTag abstractTag) {
        if (abstractTag != null) {
            if (abstractTag instanceof ID3v1Tag) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v11Tag iD3v11Tag = abstractTag instanceof ID3v11Tag ? (ID3v11Tag)abstractTag : new ID3v11Tag(abstractTag);
            this.album = iD3v11Tag.album;
            this.artist = iD3v11Tag.artist;
            this.comment = iD3v11Tag.comment;
            this.title = iD3v11Tag.title;
            this.year = iD3v11Tag.year;
            this.genre = iD3v11Tag.genre;
        }
    }

    public ID3v1Tag(RandomAccessFile randomAccessFile, String string) throws TagNotFoundException, IOException {
        this.setLoggingFilename(string);
        FileChannel fileChannel = randomAccessFile.getChannel();
        fileChannel.position(randomAccessFile.length() - 128L);
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        fileChannel.read(byteBuffer);
        byteBuffer.flip();
        this.read(byteBuffer);
    }

    public ID3v1Tag(RandomAccessFile randomAccessFile) throws TagNotFoundException, IOException {
        this(randomAccessFile, "");
    }

    @Override
    public void addField(TagField tagField) {
    }

    @Override
    public List<String> getAll(FieldKey fieldKey) throws KeyNotFoundException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getFirst(fieldKey.name()));
        return arrayList;
    }

    @Override
    public List<TagField> getFields(String string) {
        if (FieldKey.ARTIST.name().equals(string)) {
            return this.getArtist();
        }
        if (FieldKey.ALBUM.name().equals(string)) {
            return this.getAlbum();
        }
        if (FieldKey.TITLE.name().equals(string)) {
            return this.getTitle();
        }
        if (FieldKey.GENRE.name().equals(string)) {
            return this.getGenre();
        }
        if (FieldKey.YEAR.name().equals(string)) {
            return this.getYear();
        }
        if (FieldKey.COMMENT.name().equals(string)) {
            return this.getComment();
        }
        return new ArrayList<TagField>();
    }

    @Override
    public int getFieldCount() {
        return 6;
    }

    @Override
    public int getFieldCountIncludingSubValues() {
        return this.getFieldCount();
    }

    protected List<TagField> returnFieldToList(ID3v1TagField iD3v1TagField) {
        ArrayList<TagField> arrayList = new ArrayList<TagField>();
        arrayList.add(iD3v1TagField);
        return arrayList;
    }

    public void setAlbum(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.album = ID3Tags.truncate(string, 30);
    }

    public String getFirstAlbum() {
        return this.album;
    }

    public List<TagField> getAlbum() {
        if (this.getFirstAlbum().length() > 0) {
            ID3v1TagField iD3v1TagField = new ID3v1TagField(ID3v1FieldKey.ALBUM.name(), this.getFirstAlbum());
            return this.returnFieldToList(iD3v1TagField);
        }
        return new ArrayList<TagField>();
    }

    public void setArtist(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.artist = ID3Tags.truncate(string, 30);
    }

    public String getFirstArtist() {
        return this.artist;
    }

    public List<TagField> getArtist() {
        if (this.getFirstArtist().length() > 0) {
            ID3v1TagField iD3v1TagField = new ID3v1TagField(ID3v1FieldKey.ARTIST.name(), this.getFirstArtist());
            return this.returnFieldToList(iD3v1TagField);
        }
        return new ArrayList<TagField>();
    }

    public void setComment(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.comment = ID3Tags.truncate(string, 30);
    }

    public List<TagField> getComment() {
        if (this.getFirstComment().length() > 0) {
            ID3v1TagField iD3v1TagField = new ID3v1TagField(ID3v1FieldKey.COMMENT.name(), this.getFirstComment());
            return this.returnFieldToList(iD3v1TagField);
        }
        return new ArrayList<TagField>();
    }

    public String getFirstComment() {
        return this.comment;
    }

    public void setGenre(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        Integer n = GenreTypes.getInstanceOf().getIdForValue(string);
        this.genre = n != null ? n.byteValue() : (byte)-1;
    }

    public String getFirstGenre() {
        Integer n = this.genre & 0xFF;
        String string = GenreTypes.getInstanceOf().getValueForId(n);
        if (string == null) {
            return "";
        }
        return string;
    }

    public List<TagField> getGenre() {
        if (this.getFirst(FieldKey.GENRE).length() > 0) {
            ID3v1TagField iD3v1TagField = new ID3v1TagField(ID3v1FieldKey.GENRE.name(), this.getFirst(FieldKey.GENRE));
            return this.returnFieldToList(iD3v1TagField);
        }
        return new ArrayList<TagField>();
    }

    public void setTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.title = ID3Tags.truncate(string, 30);
    }

    public String getFirstTitle() {
        return this.title;
    }

    public List<TagField> getTitle() {
        if (this.getFirst(FieldKey.TITLE).length() > 0) {
            ID3v1TagField iD3v1TagField = new ID3v1TagField(ID3v1FieldKey.TITLE.name(), this.getFirst(FieldKey.TITLE));
            return this.returnFieldToList(iD3v1TagField);
        }
        return new ArrayList<TagField>();
    }

    public void setYear(String string) {
        this.year = ID3Tags.truncate(string, 4);
    }

    public String getFirstYear() {
        return this.year;
    }

    public List<TagField> getYear() {
        if (this.getFirst(FieldKey.YEAR).length() > 0) {
            ID3v1TagField iD3v1TagField = new ID3v1TagField(ID3v1FieldKey.YEAR.name(), this.getFirst(FieldKey.YEAR));
            return this.returnFieldToList(iD3v1TagField);
        }
        return new ArrayList<TagField>();
    }

    public String getFirstTrack() {
        throw new UnsupportedOperationException("ID3v10 cannot store track numbers");
    }

    public List<TagField> getTrack() {
        throw new UnsupportedOperationException("ID3v10 cannot store track numbers");
    }

    @Override
    public TagField getFirstField(String string) {
        List<TagField> list = null;
        if (FieldKey.ARTIST.name().equals(string)) {
            list = this.getArtist();
        } else if (FieldKey.ALBUM.name().equals(string)) {
            list = this.getAlbum();
        } else if (FieldKey.TITLE.name().equals(string)) {
            list = this.getTitle();
        } else if (FieldKey.GENRE.name().equals(string)) {
            list = this.getGenre();
        } else if (FieldKey.YEAR.name().equals(string)) {
            list = this.getYear();
        } else if (FieldKey.COMMENT.name().equals(string)) {
            list = this.getComment();
        }
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Iterator<TagField> getFields() {
        throw new UnsupportedOperationException("TODO:Not done yet");
    }

    @Override
    public boolean hasCommonFields() {
        return true;
    }

    @Override
    public boolean hasField(FieldKey fieldKey) {
        return this.getFirst(fieldKey).length() > 0;
    }

    @Override
    public boolean hasField(String string) {
        try {
            FieldKey fieldKey = FieldKey.valueOf(string.toUpperCase());
            return this.hasField(fieldKey);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getFirst(FieldKey.TITLE).length() <= 0 && this.getFirstArtist().length() <= 0 && this.getFirstAlbum().length() <= 0 && this.getFirst(FieldKey.GENRE).length() <= 0 && this.getFirst(FieldKey.YEAR).length() <= 0 && this.getFirstComment().length() <= 0;
    }

    @Override
    public void setField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagField = this.createField(fieldKey, string);
        this.setField(tagField);
    }

    @Override
    public void addField(FieldKey fieldKey, String string) throws KeyNotFoundException, FieldDataInvalidException {
        this.setField(fieldKey, string);
    }

    @Override
    public void setField(TagField tagField) {
        FieldKey fieldKey = FieldKey.valueOf(tagField.getId());
        switch (fieldKey) {
            case ARTIST: {
                this.setArtist(tagField.toString());
                break;
            }
            case ALBUM: {
                this.setAlbum(tagField.toString());
                break;
            }
            case TITLE: {
                this.setTitle(tagField.toString());
                break;
            }
            case GENRE: {
                this.setGenre(tagField.toString());
                break;
            }
            case YEAR: {
                this.setYear(tagField.toString());
                break;
            }
            case COMMENT: {
                this.setComment(tagField.toString());
            }
        }
    }

    @Override
    public boolean setEncoding(String string) {
        return true;
    }

    @Override
    public TagField createField(FieldKey fieldKey, String string) {
        if (fieldKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        ID3v1FieldKey iD3v1FieldKey = tagFieldToID3v1Field.get((Object)fieldKey);
        if (iD3v1FieldKey == null) {
            throw new KeyNotFoundException(ErrorMessage.INVALID_FIELD_FOR_ID3V1TAG.getMsg(fieldKey.name()));
        }
        return new ID3v1TagField(iD3v1FieldKey.name(), string);
    }

    public String getEncoding() {
        return "ISO-8859-1";
    }

    @Override
    public TagField getFirstField(FieldKey fieldKey) {
        List<TagField> list = this.getFields(fieldKey);
        return list.size() != 0 ? list.get(0) : null;
    }

    @Override
    public List<TagField> getFields(FieldKey fieldKey) {
        switch (fieldKey) {
            case ARTIST: {
                return this.getArtist();
            }
            case ALBUM: {
                return this.getAlbum();
            }
            case TITLE: {
                return this.getTitle();
            }
            case GENRE: {
                return this.getGenre();
            }
            case YEAR: {
                return this.getYear();
            }
            case COMMENT: {
                return this.getComment();
            }
        }
        return new ArrayList<TagField>();
    }

    @Override
    public String getFirst(String string) {
        FieldKey fieldKey = FieldKey.valueOf(string);
        if (fieldKey != null) {
            return this.getFirst(fieldKey);
        }
        return "";
    }

    @Override
    public String getFirst(FieldKey fieldKey) {
        switch (fieldKey) {
            case ARTIST: {
                return this.getFirstArtist();
            }
            case ALBUM: {
                return this.getFirstAlbum();
            }
            case TITLE: {
                return this.getFirstTitle();
            }
            case GENRE: {
                return this.getFirstGenre();
            }
            case YEAR: {
                return this.getFirstYear();
            }
            case COMMENT: {
                return this.getFirstComment();
            }
        }
        return "";
    }

    public String getSubValue(FieldKey fieldKey, int n, int n2) {
        return this.getValue(fieldKey, n);
    }

    @Override
    public String getValue(FieldKey fieldKey, int n) {
        return this.getFirst(fieldKey);
    }

    @Override
    public void deleteField(FieldKey fieldKey) {
        switch (fieldKey) {
            case ARTIST: {
                this.setArtist("");
                break;
            }
            case ALBUM: {
                this.setAlbum("");
                break;
            }
            case TITLE: {
                this.setTitle("");
                break;
            }
            case GENRE: {
                this.setGenre("");
                break;
            }
            case YEAR: {
                this.setYear("");
                break;
            }
            case COMMENT: {
                this.setComment("");
            }
        }
    }

    @Override
    public void deleteField(String string) {
        FieldKey fieldKey = FieldKey.valueOf(string);
        if (fieldKey != null) {
            this.deleteField(fieldKey);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ID3v1Tag)) {
            return false;
        }
        ID3v1Tag iD3v1Tag = (ID3v1Tag)object;
        if (!this.album.equals(iD3v1Tag.album)) {
            return false;
        }
        if (!this.artist.equals(iD3v1Tag.artist)) {
            return false;
        }
        if (!this.comment.equals(iD3v1Tag.comment)) {
            return false;
        }
        if (this.genre != iD3v1Tag.genre) {
            return false;
        }
        if (!this.title.equals(iD3v1Tag.title)) {
            return false;
        }
        return this.year.equals(iD3v1Tag.year) && super.equals(object);
    }

    @Override
    public Iterator iterator() {
        return new ID3v1Iterator(this);
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagNotFoundException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException(this.getLoggingFilename() + ":" + "ID3v1 tag not found");
        }
        logger.finer(this.getLoggingFilename() + ":" + "Reading v1 tag");
        byte[] byArray = new byte[128];
        byteBuffer.position(0);
        byteBuffer.get(byArray, 0, 128);
        this.title = Utils.getString(byArray, 3, 30, "ISO-8859-1").trim();
        Matcher matcher = AbstractID3v1Tag.endofStringPattern.matcher(this.title);
        if (matcher.find()) {
            this.title = this.title.substring(0, matcher.start());
        }
        this.artist = Utils.getString(byArray, 33, 30, "ISO-8859-1").trim();
        matcher = AbstractID3v1Tag.endofStringPattern.matcher(this.artist);
        if (matcher.find()) {
            this.artist = this.artist.substring(0, matcher.start());
        }
        this.album = Utils.getString(byArray, 63, 30, "ISO-8859-1").trim();
        matcher = AbstractID3v1Tag.endofStringPattern.matcher(this.album);
        logger.finest(this.getLoggingFilename() + ":" + "Orig Album is:" + this.comment + ":");
        if (matcher.find()) {
            this.album = this.album.substring(0, matcher.start());
            logger.finest(this.getLoggingFilename() + ":" + "Album is:" + this.album + ":");
        }
        this.year = Utils.getString(byArray, 93, 4, "ISO-8859-1").trim();
        matcher = AbstractID3v1Tag.endofStringPattern.matcher(this.year);
        if (matcher.find()) {
            this.year = this.year.substring(0, matcher.start());
        }
        this.comment = Utils.getString(byArray, 97, 30, "ISO-8859-1").trim();
        matcher = AbstractID3v1Tag.endofStringPattern.matcher(this.comment);
        logger.finest(this.getLoggingFilename() + ":" + "Orig Comment is:" + this.comment + ":");
        if (matcher.find()) {
            this.comment = this.comment.substring(0, matcher.start());
            logger.finest(this.getLoggingFilename() + ":" + "Comment is:" + this.comment + ":");
        }
        this.genre = byArray[127];
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[3];
        byteBuffer.get(byArray, 0, 3);
        return Arrays.equals(byArray, TAG_ID);
    }

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        String string;
        logger.config("Saving ID3v1 tag to file");
        byte[] byArray = new byte[128];
        this.delete(randomAccessFile);
        randomAccessFile.seek(randomAccessFile.length());
        System.arraycopy(TAG_ID, 0, byArray, 0, TAG_ID.length);
        int n2 = 3;
        if (TagOptionSingleton.getInstance().isId3v1SaveTitle()) {
            string = ID3Tags.truncate(this.title, 30);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 = 33;
        if (TagOptionSingleton.getInstance().isId3v1SaveArtist()) {
            string = ID3Tags.truncate(this.artist, 30);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 = 63;
        if (TagOptionSingleton.getInstance().isId3v1SaveAlbum()) {
            string = ID3Tags.truncate(this.album, 30);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 = 93;
        if (TagOptionSingleton.getInstance().isId3v1SaveYear()) {
            string = ID3Tags.truncate(this.year, 4);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 = 97;
        if (TagOptionSingleton.getInstance().isId3v1SaveComment()) {
            string = ID3Tags.truncate(this.comment, 30);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 = 127;
        if (TagOptionSingleton.getInstance().isId3v1SaveGenre()) {
            byArray[n2] = this.genre;
        }
        randomAccessFile.write(byArray);
        logger.config("Saved ID3v1 tag to file");
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("title", this.title);
        MP3File.getStructureFormatter().addElement("artist", this.artist);
        MP3File.getStructureFormatter().addElement("album", this.album);
        MP3File.getStructureFormatter().addElement("year", this.year);
        MP3File.getStructureFormatter().addElement(TYPE_COMMENT, this.comment);
        MP3File.getStructureFormatter().addElement("genre", this.genre);
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }

    @Override
    public List<Artwork> getArtworkList() {
        return Collections.emptyList();
    }

    @Override
    public Artwork getFirstArtwork() {
        return null;
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    static {
        tagFieldToID3v1Field.put(FieldKey.ARTIST, ID3v1FieldKey.ARTIST);
        tagFieldToID3v1Field.put(FieldKey.ALBUM, ID3v1FieldKey.ALBUM);
        tagFieldToID3v1Field.put(FieldKey.TITLE, ID3v1FieldKey.TITLE);
        tagFieldToID3v1Field.put(FieldKey.TRACK, ID3v1FieldKey.TRACK);
        tagFieldToID3v1Field.put(FieldKey.YEAR, ID3v1FieldKey.YEAR);
        tagFieldToID3v1Field.put(FieldKey.GENRE, ID3v1FieldKey.GENRE);
        tagFieldToID3v1Field.put(FieldKey.COMMENT, ID3v1FieldKey.COMMENT);
    }
}

