/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.reference;

import org.jaudiotagger.tag.id3.reference.ID3Rating;

public class ITunesRating
extends ID3Rating {
    private static ID3Rating rating = null;

    private ITunesRating() {
    }

    @Override
    public int convertRatingFromFiveStarScale(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("convert Ratings from Five Star Scale accepts values from 0 to 5 not:" + n);
        }
        int n2 = 0;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n2 = 20;
                break;
            }
            case 2: {
                n2 = 40;
                break;
            }
            case 3: {
                n2 = 60;
                break;
            }
            case 4: {
                n2 = 80;
                break;
            }
            case 5: {
                n2 = 100;
            }
        }
        return n2;
    }

    @Override
    public int convertRatingToFiveStarScale(int n) {
        int n2 = 0;
        n2 = n <= 0 ? 0 : (n <= 20 ? 1 : (n <= 40 ? 2 : (n <= 60 ? 3 : (n <= 80 ? 4 : (n <= 100 ? 5 : 5)))));
        return n2;
    }

    public static ID3Rating getInstance() {
        if (rating == null) {
            rating = new ITunesRating();
        }
        return rating;
    }
}

