/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.images;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.reference.PictureTypes;

public class AndroidArtwork
implements Artwork {
    private byte[] binaryData;
    private String mimeType = "";
    private String description = "";
    private boolean isLinked = false;
    private String imageUrl = "";
    private int pictureType = -1;
    private int width;
    private int height;

    @Override
    public byte[] getBinaryData() {
        return this.binaryData;
    }

    @Override
    public void setBinaryData(byte[] byArray) {
        this.binaryData = byArray;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String string) {
        this.mimeType = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public boolean setImageFromData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getImage() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLinked() {
        return this.isLinked;
    }

    @Override
    public void setLinked(boolean bl) {
        this.isLinked = bl;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public void setImageUrl(String string) {
        this.imageUrl = string;
    }

    @Override
    public int getPictureType() {
        return this.pictureType;
    }

    @Override
    public void setPictureType(int n) {
        this.pictureType = n;
    }

    @Override
    public void setFromFile(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        randomAccessFile.read(byArray);
        randomAccessFile.close();
        this.setBinaryData(byArray);
        this.setMimeType(ImageFormats.getMimeTypeForBinarySignature(byArray));
        this.setDescription("");
        this.setPictureType(PictureTypes.DEFAULT_ID);
    }

    public static AndroidArtwork createArtworkFromFile(File file) throws IOException {
        AndroidArtwork androidArtwork = new AndroidArtwork();
        androidArtwork.setFromFile(file);
        return androidArtwork;
    }

    public static AndroidArtwork createLinkedArtworkFromURL(String string) throws IOException {
        AndroidArtwork androidArtwork = new AndroidArtwork();
        androidArtwork.setLinkedFromURL(string);
        return androidArtwork;
    }

    public void setLinkedFromURL(String string) throws IOException {
        this.setLinked(true);
        this.setImageUrl(string);
    }

    @Override
    public void setFromMetadataBlockDataPicture(MetadataBlockDataPicture metadataBlockDataPicture) {
        this.setMimeType(metadataBlockDataPicture.getMimeType());
        this.setDescription(metadataBlockDataPicture.getDescription());
        this.setPictureType(metadataBlockDataPicture.getPictureType());
        if (metadataBlockDataPicture.isImageUrl()) {
            this.setLinked(metadataBlockDataPicture.isImageUrl());
            this.setImageUrl(metadataBlockDataPicture.getImageUrl());
        } else {
            this.setBinaryData(metadataBlockDataPicture.getImageData());
        }
        this.setWidth(metadataBlockDataPicture.getWidth());
        this.setHeight(metadataBlockDataPicture.getHeight());
    }

    public static AndroidArtwork createArtworkFromMetadataBlockDataPicture(MetadataBlockDataPicture metadataBlockDataPicture) {
        AndroidArtwork androidArtwork = new AndroidArtwork();
        androidArtwork.setFromMetadataBlockDataPicture(metadataBlockDataPicture);
        return androidArtwork;
    }

    @Override
    public void setWidth(int n) {
        this.width = n;
    }

    @Override
    public void setHeight(int n) {
        this.height = n;
    }
}

