/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.images;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.reference.PictureTypes;

public class StandardArtwork
implements Artwork {
    private byte[] binaryData;
    private String mimeType = "";
    private String description = "";
    private boolean isLinked = false;
    private String imageUrl = "";
    private int pictureType = -1;
    private int width;
    private int height;

    @Override
    public byte[] getBinaryData() {
        return this.binaryData;
    }

    @Override
    public void setBinaryData(byte[] byArray) {
        this.binaryData = byArray;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String string) {
        this.mimeType = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public boolean setImageFromData() {
        try {
            BufferedImage bufferedImage = (BufferedImage)this.getImage();
            this.setWidth(bufferedImage.getWidth());
            this.setHeight(bufferedImage.getHeight());
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public Object getImage() throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(this.getBinaryData()));
        BufferedImage bufferedImage = ImageIO.read(imageInputStream);
        return bufferedImage;
    }

    @Override
    public boolean isLinked() {
        return this.isLinked;
    }

    @Override
    public void setLinked(boolean bl) {
        this.isLinked = bl;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public void setImageUrl(String string) {
        this.imageUrl = string;
    }

    @Override
    public int getPictureType() {
        return this.pictureType;
    }

    @Override
    public void setPictureType(int n) {
        this.pictureType = n;
    }

    @Override
    public void setFromFile(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        randomAccessFile.read(byArray);
        randomAccessFile.close();
        this.setBinaryData(byArray);
        this.setMimeType(ImageFormats.getMimeTypeForBinarySignature(byArray));
        this.setDescription("");
        this.setPictureType(PictureTypes.DEFAULT_ID);
    }

    public void setLinkedFromURL(String string) throws IOException {
        this.setLinked(true);
        this.setImageUrl(string);
    }

    public static StandardArtwork createArtworkFromFile(File file) throws IOException {
        StandardArtwork standardArtwork = new StandardArtwork();
        standardArtwork.setFromFile(file);
        return standardArtwork;
    }

    public static StandardArtwork createLinkedArtworkFromURL(String string) throws IOException {
        StandardArtwork standardArtwork = new StandardArtwork();
        standardArtwork.setLinkedFromURL(string);
        return standardArtwork;
    }

    @Override
    public void setFromMetadataBlockDataPicture(MetadataBlockDataPicture metadataBlockDataPicture) {
        this.setMimeType(metadataBlockDataPicture.getMimeType());
        this.setDescription(metadataBlockDataPicture.getDescription());
        this.setPictureType(metadataBlockDataPicture.getPictureType());
        if (metadataBlockDataPicture.isImageUrl()) {
            this.setLinked(metadataBlockDataPicture.isImageUrl());
            this.setImageUrl(metadataBlockDataPicture.getImageUrl());
        } else {
            this.setBinaryData(metadataBlockDataPicture.getImageData());
        }
        this.setWidth(metadataBlockDataPicture.getWidth());
        this.setHeight(metadataBlockDataPicture.getHeight());
    }

    public static StandardArtwork createArtworkFromMetadataBlockDataPicture(MetadataBlockDataPicture metadataBlockDataPicture) {
        StandardArtwork standardArtwork = new StandardArtwork();
        standardArtwork.setFromMetadataBlockDataPicture(metadataBlockDataPicture);
        return standardArtwork;
    }

    @Override
    public void setWidth(int n) {
        this.width = n;
    }

    @Override
    public void setHeight(int n) {
        this.height = n;
    }
}

