/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ListIterator;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public abstract class AbstractLyrics3v2FieldFrameBody
extends AbstractTagFrameBody {
    public AbstractLyrics3v2FieldFrameBody() {
    }

    public AbstractLyrics3v2FieldFrameBody(AbstractLyrics3v2FieldFrameBody abstractLyrics3v2FieldFrameBody) {
        super(abstractLyrics3v2FieldFrameBody);
    }

    protected int readHeader(RandomAccessFile randomAccessFile) throws InvalidTagException, IOException {
        byte[] byArray = new byte[5];
        randomAccessFile.read(byArray, 0, 5);
        int n = Integer.parseInt(new String(byArray, 0, 5));
        if (n == 0 && !TagOptionSingleton.getInstance().isLyrics3KeepEmptyFieldIfRead()) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }
        return n;
    }

    protected void writeHeader(RandomAccessFile randomAccessFile, int n) throws IOException {
        int n2;
        int n3 = 0;
        byte[] byArray = new byte[5];
        String string = Integer.toString(this.getSize());
        for (n2 = 0; n2 < 5 - string.length(); ++n2) {
            byArray[n2] = 48;
        }
        n3 += 5 - string.length();
        for (n2 = 0; n2 < string.length(); ++n2) {
            byArray[n2 + n3] = (byte)string.charAt(n2);
        }
        randomAccessFile.write(byArray);
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        int n = this.getSize();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        int n2 = 0;
        ListIterator listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            if (n2 > n - 1) {
                throw new InvalidTagException("Invalid size for Frame Body");
            }
            AbstractDataType abstractDataType = (AbstractDataType)listIterator.next();
            abstractDataType.readByteArray(byArray, n2);
            n2 += abstractDataType.getSize();
        }
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        ListIterator listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            AbstractDataType abstractDataType = (AbstractDataType)listIterator.next();
            byte[] byArray = abstractDataType.writeByteArray();
            randomAccessFile.write(byArray);
        }
    }
}

