/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.atom;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.AbstractMp4Box;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public class Mp4DataBox
extends AbstractMp4Box {
    public static final String IDENTIFIER = "data";
    public static final int VERSION_LENGTH = 1;
    public static final int TYPE_LENGTH = 3;
    public static final int NULL_LENGTH = 4;
    public static final int PRE_DATA_LENGTH = 8;
    public static final int DATA_HEADER_LENGTH = 16;
    public static final int TYPE_POS = 1;
    public static final int TYPE_POS_INCLUDING_HEADER = 9;
    private int type;
    private String content;
    public static final int NUMBER_LENGTH = 2;
    private List<Short> numbers;
    private byte[] bytedata;

    public Mp4DataBox(Mp4BoxHeader mp4BoxHeader, ByteBuffer byteBuffer) {
        this.header = mp4BoxHeader;
        if (!mp4BoxHeader.getId().equals(IDENTIFIER)) {
            throw new RuntimeException("Unable to process data box because identifier is:" + mp4BoxHeader.getId());
        }
        this.dataBuffer = byteBuffer.slice();
        this.type = Utils.getIntBE(this.dataBuffer, 1, 3);
        if (this.type == Mp4FieldType.TEXT.getFileClassId()) {
            this.content = Utils.getString(this.dataBuffer, 8, mp4BoxHeader.getDataLength() - 8, mp4BoxHeader.getEncoding());
        } else if (this.type == Mp4FieldType.IMPLICIT.getFileClassId()) {
            this.numbers = new ArrayList<Short>();
            for (int i = 0; i < (mp4BoxHeader.getDataLength() - 8) / 2; ++i) {
                short s = Utils.getShortBE(this.dataBuffer, 8 + i * 2, 8 + i * 2 + 1);
                this.numbers.add(s);
            }
            StringBuffer stringBuffer = new StringBuffer();
            ListIterator<Short> listIterator = this.numbers.listIterator();
            while (listIterator.hasNext()) {
                stringBuffer.append(listIterator.next());
                if (!listIterator.hasNext()) continue;
                stringBuffer.append("/");
            }
            this.content = stringBuffer.toString();
        } else if (this.type == Mp4FieldType.INTEGER.getFileClassId()) {
            this.content = Utils.getIntBE(this.dataBuffer, 8, mp4BoxHeader.getDataLength() - 1) + "";
            this.bytedata = new byte[mp4BoxHeader.getDataLength() - 8];
            int n = byteBuffer.position();
            byteBuffer.position(n + 8);
            byteBuffer.get(this.bytedata);
            byteBuffer.position(n);
            this.numbers = new ArrayList<Short>();
            for (int i = 0; i < (mp4BoxHeader.getDataLength() - 8) / 2; ++i) {
                short s = Utils.getShortBE(this.dataBuffer, 8 + i * 2, 8 + i * 2 + 1);
                this.numbers.add(s);
            }
        } else if (this.type == Mp4FieldType.COVERART_JPEG.getFileClassId()) {
            this.content = Utils.getString(this.dataBuffer, 8, mp4BoxHeader.getDataLength() - 8, mp4BoxHeader.getEncoding());
        }
    }

    public String getContent() {
        return this.content;
    }

    public int getType() {
        return this.type;
    }

    public List<Short> getNumbers() {
        return this.numbers;
    }

    public byte[] getByteData() {
        return this.bytedata;
    }
}

