/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextNumberField;

public class Mp4TrackField
extends Mp4TagTextNumberField {
    private static final int NONE_VALUE_INDEX = 0;
    private static final int TRACK_NO_INDEX = 1;
    private static final int TRACK_TOTAL_INDEX = 2;
    private static final int NONE_END_VALUE_INDEX = 3;

    public Mp4TrackField(String string) throws FieldDataInvalidException {
        super(Mp4FieldKey.TRACK.getFieldName(), string);
        this.numbers = new ArrayList();
        this.numbers.add(new Short("0"));
        String[] stringArray = string.split("/");
        switch (stringArray.length) {
            case 1: {
                try {
                    this.numbers.add(Short.parseShort(stringArray[0]));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FieldDataInvalidException("Value of:" + stringArray[0] + " is invalid for field:" + this.id);
                }
                this.numbers.add(new Short("0"));
                this.numbers.add(new Short("0"));
                break;
            }
            case 2: {
                try {
                    this.numbers.add(Short.parseShort(stringArray[0]));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FieldDataInvalidException("Value of:" + stringArray[0] + " is invalid for field:" + this.id);
                }
                try {
                    this.numbers.add(Short.parseShort(stringArray[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FieldDataInvalidException("Value of:" + stringArray[1] + " is invalid for field:" + this.id);
                }
                this.numbers.add(new Short("0"));
                break;
            }
            default: {
                throw new FieldDataInvalidException("Value is invalid for field:" + this.id);
            }
        }
    }

    public Mp4TrackField(int n) {
        super(Mp4FieldKey.TRACK.getFieldName(), String.valueOf(n));
        this.numbers = new ArrayList();
        this.numbers.add(new Short("0"));
        this.numbers.add((short)n);
        this.numbers.add(new Short("0"));
        this.numbers.add(new Short("0"));
    }

    public Mp4TrackField(int n, int n2) {
        super(Mp4FieldKey.TRACK.getFieldName(), String.valueOf(n));
        this.numbers = new ArrayList();
        this.numbers.add(new Short("0"));
        this.numbers.add((short)n);
        this.numbers.add((short)n2);
        this.numbers.add(new Short("0"));
    }

    public Mp4TrackField(String string, ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        super(string, byteBuffer);
    }

    @Override
    protected void build(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        Mp4BoxHeader mp4BoxHeader = new Mp4BoxHeader(byteBuffer);
        Mp4DataBox mp4DataBox = new Mp4DataBox(mp4BoxHeader, byteBuffer);
        this.dataSize = mp4BoxHeader.getDataLength();
        this.numbers = mp4DataBox.getNumbers();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.numbers != null) {
            if (this.numbers.size() > 1 && (Short)this.numbers.get(1) > 0) {
                stringBuffer.append(this.numbers.get(1));
            }
            if (this.numbers.size() > 2 && (Short)this.numbers.get(2) > 0) {
                stringBuffer.append("/").append(this.numbers.get(2));
            }
        }
        this.content = stringBuffer.toString();
    }

    public Short getTrackNo() {
        return (Short)this.numbers.get(1);
    }

    public Short getTrackTotal() {
        if (this.numbers.size() <= 2) {
            return (short)0;
        }
        return (Short)this.numbers.get(2);
    }

    public void setTrackNo(int n) {
        this.numbers.set(1, (short)n);
    }

    public void setTrackTotal(int n) {
        this.numbers.set(2, (short)n);
    }
}

