/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.vorbiscomment;

import java.io.IOException;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTagField;

public class VorbisCommentReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.vorbiscomment.VorbisCommentReader");
    public static final int FIELD_VENDOR_LENGTH_POS = 0;
    public static final int FIELD_VENDOR_STRING_POS = 4;
    public static final int FIELD_VENDOR_LENGTH_LENGTH = 4;
    public static final int FIELD_USER_COMMENT_LIST_LENGTH = 4;
    public static final int FIELD_COMMENT_LENGTH_LENGTH = 4;
    private static final int JAUDIOTAGGER_MAX_COMMENT_LENGTH = 10000000;

    public VorbisCommentTag read(byte[] byArray, boolean bl) throws IOException, CannotReadException {
        VorbisCommentTag vorbisCommentTag = new VorbisCommentTag();
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        int n = 4;
        int n2 = Utils.getIntLE(byArray2);
        byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        vorbisCommentTag.setVendor(new String(byArray2, "UTF-8"));
        logger.config("Vendor is:" + vorbisCommentTag.getVendor());
        byArray2 = new byte[4];
        System.arraycopy(byArray, n += n2, byArray2, 0, 4);
        n += 4;
        int n3 = Utils.getIntLE(byArray2);
        logger.config("Number of user comments:" + n3);
        for (int i = 0; i < n3; ++i) {
            byArray2 = new byte[4];
            System.arraycopy(byArray, n, byArray2, 0, 4);
            n += 4;
            int n4 = Utils.getIntLE(byArray2);
            logger.config("Next Comment Length:" + n4);
            if (n4 > 10000000) {
                logger.warning(ErrorMessage.VORBIS_COMMENT_LENGTH_TOO_LARGE.getMsg(n4));
                break;
            }
            if (n4 > byArray.length) {
                logger.warning(ErrorMessage.VORBIS_COMMENT_LENGTH_LARGE_THAN_HEADER.getMsg(n4, byArray.length));
                break;
            }
            byArray2 = new byte[n4];
            System.arraycopy(byArray, n, byArray2, 0, n4);
            n += n4;
            VorbisCommentTagField vorbisCommentTagField = new VorbisCommentTagField(byArray2);
            logger.config("Adding:" + vorbisCommentTagField.getId());
            vorbisCommentTag.addField(vorbisCommentTagField);
        }
        if (bl && (byArray[n] & 1) != 1) {
            throw new CannotReadException(ErrorMessage.OGG_VORBIS_NO_FRAMING_BIT.getMsg(byArray[n] & 1));
        }
        return vorbisCommentTag;
    }
}

