/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.test;

import java.io.File;
import java.io.FileFilter;
import java.text.DateFormat;
import java.util.Date;
import org.jaudiotagger.audio.AudioFileFilter;
import org.jaudiotagger.audio.AudioFileIO;

public class TestAudioTagger {
    private static int count = 0;
    private static int failed = 0;

    public static void main(String[] stringArray) {
        TestAudioTagger testAudioTagger = new TestAudioTagger();
        if (stringArray.length == 0) {
            System.err.println("usage TestAudioTagger Dirname");
            System.err.println("      You must enter the root directory");
            System.exit(1);
        } else if (stringArray.length > 1) {
            System.err.println("usage TestAudioTagger Dirname");
            System.err.println("      Only one parameter accepted");
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        if (!file.isDirectory()) {
            System.err.println("usage TestAudioTagger Dirname");
            System.err.println("      Directory " + stringArray[0] + " could not be found");
            System.exit(1);
        }
        Date date = new Date();
        System.out.println("Started to read from:" + file.getPath() + " at " + DateFormat.getTimeInstance().format(date));
        testAudioTagger.scanSingleDir(file);
        Date date2 = new Date();
        System.out.println("Started to read from:" + file.getPath() + " at " + DateFormat.getTimeInstance().format(date));
        System.out.println("Finished to read from:" + file.getPath() + DateFormat.getTimeInstance().format(date2));
        System.out.println("Attempted  to read:" + count);
        System.out.println("Successful to read:" + (count - failed));
        System.out.println("Failed     to read:" + failed);
    }

    private void scanSingleDir(File file) {
        File[] fileArray;
        File[] fileArray2 = file.listFiles(new AudioFileFilter(false));
        if (fileArray2.length > 0) {
            fileArray = fileArray2;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file2 = fileArray[i];
                ++count;
                try {
                    AudioFileIO.read(file2);
                    continue;
                }
                catch (Throwable throwable) {
                    System.err.println("Unable to read record:" + count + ":" + file2.getPath());
                    ++failed;
                    throwable.printStackTrace();
                }
            }
        }
        if ((fileArray = file.listFiles(new DirFilter())).length > 0) {
            for (File file3 : fileArray) {
                this.scanSingleDir(file3);
            }
        }
    }

    public final class DirFilter
    implements FileFilter {
        public static final String IDENT = "$Id: TestAudioTagger.java 832 2009-11-12 13:25:38Z paultaylor $";

        @Override
        public final boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

