/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.impl;

import com.aelitis.azureus.core.clientmessageservice.impl.ClientConnection;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientMessage;
import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZGenericMapPayload;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;

public class NonBlockingReadWriteService {
    private final VirtualChannelSelector read_selector;
    private final VirtualChannelSelector write_selector;
    private final ArrayList connections = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("connections");
    private final ServiceListener listener;
    private final String service_name;
    private volatile boolean destroyed;
    private long last_timeout_check_time = 0L;
    private static final int TIMEOUT_CHECK_INTERVAL_MS = 10000;
    private final int activity_timeout_period_ms;
    private final int close_delay_period_ms;

    public NonBlockingReadWriteService(String string, int n, ServiceListener serviceListener) {
        this(string, n, 0, serviceListener);
    }

    public NonBlockingReadWriteService(String string, int n, int n2, ServiceListener serviceListener) {
        this.service_name = string;
        this.listener = serviceListener;
        this.read_selector = new VirtualChannelSelector(this.service_name, 1, false);
        this.write_selector = new VirtualChannelSelector(this.service_name, 4, true);
        if (n < 10) {
            n = 10;
        }
        this.activity_timeout_period_ms = n * 1000;
        this.close_delay_period_ms = n2 * 1000;
        new AEThread2("[" + this.service_name + "] Service Select", true){

            @Override
            public void run() {
                while (true) {
                    boolean bl;
                    if (bl = NonBlockingReadWriteService.this.destroyed) {
                        NonBlockingReadWriteService.this.read_selector.destroy();
                        NonBlockingReadWriteService.this.write_selector.destroy();
                    }
                    try {
                        NonBlockingReadWriteService.this.read_selector.select(50L);
                        NonBlockingReadWriteService.this.write_selector.select(50L);
                    }
                    catch (Throwable throwable) {
                        Debug.out("[" + NonBlockingReadWriteService.this.service_name + "] SelectorLoop() EXCEPTION: ", throwable);
                    }
                    if (bl) break;
                    NonBlockingReadWriteService.this.doConnectionTimeoutChecks();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.connections_mon.enter();
            this.connections.clear();
            this.destroyed = true;
        }
        finally {
            this.connections_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientConnection(ClientConnection clientConnection) {
        try {
            this.connections_mon.enter();
            if (this.destroyed) {
                Debug.out("connection added after destroy");
            }
            this.connections.add(clientConnection);
        }
        finally {
            this.connections_mon.exit();
        }
        this.registerForSelection(clientConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientConnection(ClientConnection clientConnection) {
        this.read_selector.cancel(clientConnection.getSocketChannel());
        this.write_selector.cancel(clientConnection.getSocketChannel());
        try {
            this.connections_mon.enter();
            this.connections.remove(clientConnection);
        }
        finally {
            this.connections_mon.exit();
        }
    }

    private void registerForSelection(final ClientConnection clientConnection) {
        VirtualChannelSelector.VirtualSelectorListener virtualSelectorListener = new VirtualChannelSelector.VirtualSelectorListener(){

            @Override
            public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
                try {
                    Message[] messageArray = clientConnection.readMessages();
                    if (messageArray != null) {
                        for (int i = 0; i < messageArray.length; ++i) {
                            AZGenericMapPayload aZGenericMapPayload = (AZGenericMapPayload)messageArray[i];
                            ClientMessage clientMessage = new ClientMessage(aZGenericMapPayload.getID(), clientConnection, aZGenericMapPayload.getMapPayload(), null);
                            NonBlockingReadWriteService.this.listener.messageReceived(clientMessage);
                        }
                    }
                    return clientConnection.getLastReadMadeProgress();
                }
                catch (Throwable throwable) {
                    if (!clientConnection.isClosePending()) {
                        System.out.println("[" + new Date() + "] Connection read error [" + socketChannel.socket().getInetAddress() + "] [" + clientConnection.getDebugString() + "]: " + throwable.getMessage());
                    }
                    NonBlockingReadWriteService.this.listener.connectionError(clientConnection, throwable);
                    return false;
                }
            }

            @Override
            public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
                if (!NonBlockingReadWriteService.this.destroyed) {
                    throwable.printStackTrace();
                }
                NonBlockingReadWriteService.this.listener.connectionError(clientConnection, throwable);
            }
        };
        VirtualChannelSelector.VirtualSelectorListener virtualSelectorListener2 = new VirtualChannelSelector.VirtualSelectorListener(){

            @Override
            public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
                try {
                    boolean bl = clientConnection.writeMessages();
                    if (bl) {
                        NonBlockingReadWriteService.this.write_selector.resumeSelects(clientConnection.getSocketChannel());
                    }
                    return clientConnection.getLastWriteMadeProgress();
                }
                catch (Throwable throwable) {
                    System.out.println("[" + new Date() + "] Connection write error [" + socketChannel.socket().getInetAddress() + "] [" + clientConnection.getDebugString() + "]: " + throwable.getMessage());
                    NonBlockingReadWriteService.this.listener.connectionError(clientConnection, throwable);
                    return false;
                }
            }

            @Override
            public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
                if (!NonBlockingReadWriteService.this.destroyed) {
                    throwable.printStackTrace();
                }
                NonBlockingReadWriteService.this.listener.connectionError(clientConnection, throwable);
            }
        };
        this.write_selector.register(clientConnection.getSocketChannel(), virtualSelectorListener2, null);
        this.write_selector.pauseSelects(clientConnection.getSocketChannel());
        this.read_selector.register(clientConnection.getSocketChannel(), virtualSelectorListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnectionTimeoutChecks() {
        long l = System.currentTimeMillis();
        if (l < this.last_timeout_check_time || l - this.last_timeout_check_time > 10000L) {
            ArrayList<ClientConnection> arrayList = new ArrayList<ClientConnection>();
            try {
                this.connections_mon.enter();
                long l2 = System.currentTimeMillis();
                for (int i = 0; i < this.connections.size(); ++i) {
                    ClientConnection clientConnection = (ClientConnection)this.connections.get(i);
                    if (l2 < clientConnection.getLastActivityTime()) {
                        clientConnection.resetLastActivityTime();
                        continue;
                    }
                    if (l2 - clientConnection.getLastActivityTime() <= (long)this.activity_timeout_period_ms && (this.close_delay_period_ms <= 0 || l2 - clientConnection.getLastActivityTime() <= (long)this.close_delay_period_ms)) continue;
                    arrayList.add(clientConnection);
                }
            }
            finally {
                this.connections_mon.exit();
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                ClientConnection clientConnection = (ClientConnection)arrayList.get(i);
                this.listener.connectionError(clientConnection, new Exception("Timeout"));
            }
            this.last_timeout_check_time = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(ClientMessage clientMessage) {
        boolean bl;
        ClientConnection clientConnection = clientMessage.getClient();
        try {
            this.connections_mon.enter();
            bl = this.connections.contains(clientConnection);
        }
        finally {
            this.connections_mon.exit();
        }
        if (!bl) {
            System.out.println("[" + new Date() + "] Connection message send error [connection no longer connected]: " + clientConnection.getDebugString() + "]");
            clientMessage.reportFailed(new Exception("No longer connected"));
            return;
        }
        AZGenericMapPayload aZGenericMapPayload = new AZGenericMapPayload(clientMessage.getMessageID(), clientMessage.getPayload(), 1);
        clientConnection.sendMessage(clientMessage, aZGenericMapPayload);
        this.write_selector.resumeSelects(clientConnection.getSocketChannel());
    }

    public static interface ServiceListener {
        public void messageReceived(ClientMessage var1);

        public void connectionError(ClientConnection var1, Throwable var2);
    }
}

