/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.util;

import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class DHTTransportStatsImpl
implements DHTTransportStats {
    private byte protocol_version;
    private long[] pings = new long[4];
    private long[] find_nodes = new long[4];
    private long[] find_values = new long[4];
    private long[] stores = new long[4];
    private long[] stats = new long[4];
    private long[] data = new long[4];
    private long[] key_blocks = new long[4];
    private long[] store_queries = new long[4];
    private long[] aliens = new long[7];
    private long incoming_requests;
    private long outgoing_requests;
    private long incoming_version_requests;
    private long[] incoming_request_versions;
    private long outgoing_version_requests;
    private long[] outgoing_request_versions;
    private static final int SKEW_VALUE_MAX = 256;
    private final int[] skew_values = new int[256];
    private int skew_pos = 0;
    private long last_skew_average;
    private long last_skew_average_time;
    private BloomFilter skew_originator_bloom = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(1024), 2);

    protected DHTTransportStatsImpl(byte by) {
        this.protocol_version = by;
        this.incoming_request_versions = new long[this.protocol_version + 1];
        this.outgoing_request_versions = new long[this.protocol_version + 1];
        Arrays.fill(this.skew_values, Integer.MAX_VALUE);
    }

    protected byte getProtocolVersion() {
        return this.protocol_version;
    }

    public void add(DHTTransportStatsImpl dHTTransportStatsImpl) {
        this.add(this.pings, dHTTransportStatsImpl.pings);
        this.add(this.find_nodes, dHTTransportStatsImpl.find_nodes);
        this.add(this.find_values, dHTTransportStatsImpl.find_values);
        this.add(this.stores, dHTTransportStatsImpl.stores);
        this.add(this.stats, dHTTransportStatsImpl.stats);
        this.add(this.data, dHTTransportStatsImpl.data);
        this.add(this.key_blocks, dHTTransportStatsImpl.key_blocks);
        this.add(this.store_queries, dHTTransportStatsImpl.store_queries);
        this.add(this.aliens, dHTTransportStatsImpl.aliens);
        this.incoming_requests += dHTTransportStatsImpl.incoming_requests;
        this.outgoing_requests += dHTTransportStatsImpl.outgoing_requests;
    }

    protected void add(long[] lArray, long[] lArray2) {
        for (int i = 0; i < lArray.length; ++i) {
            int n = i;
            lArray[n] = lArray[n] + lArray2[i];
        }
    }

    protected void snapshotSupport(DHTTransportStatsImpl dHTTransportStatsImpl) {
        dHTTransportStatsImpl.pings = (long[])this.pings.clone();
        dHTTransportStatsImpl.find_nodes = (long[])this.find_nodes.clone();
        dHTTransportStatsImpl.find_values = (long[])this.find_values.clone();
        dHTTransportStatsImpl.stores = (long[])this.stores.clone();
        dHTTransportStatsImpl.data = (long[])this.data.clone();
        dHTTransportStatsImpl.key_blocks = (long[])this.key_blocks.clone();
        dHTTransportStatsImpl.store_queries = (long[])this.store_queries.clone();
        dHTTransportStatsImpl.aliens = (long[])this.aliens.clone();
        dHTTransportStatsImpl.incoming_requests = this.incoming_requests;
        dHTTransportStatsImpl.outgoing_requests = this.outgoing_requests;
    }

    public void pingSent(DHTUDPPacketRequest dHTUDPPacketRequest) {
        this.pings[0] = this.pings[0] + 1L;
        this.outgoingRequestSent(dHTUDPPacketRequest);
    }

    public void pingOK() {
        this.pings[1] = this.pings[1] + 1L;
    }

    public void pingFailed() {
        this.pings[2] = this.pings[2] + 1L;
    }

    public void pingReceived() {
        this.pings[3] = this.pings[3] + 1L;
    }

    @Override
    public long[] getPings() {
        return this.pings;
    }

    public void keyBlockSent(DHTUDPPacketRequest dHTUDPPacketRequest) {
        this.key_blocks[0] = this.key_blocks[0] + 1L;
        this.outgoingRequestSent(dHTUDPPacketRequest);
    }

    public void keyBlockOK() {
        this.key_blocks[1] = this.key_blocks[1] + 1L;
    }

    public void keyBlockFailed() {
        this.key_blocks[2] = this.key_blocks[2] + 1L;
    }

    public void keyBlockReceived() {
        this.key_blocks[3] = this.key_blocks[3] + 1L;
    }

    @Override
    public long[] getKeyBlocks() {
        return this.key_blocks;
    }

    public void queryStoreSent(DHTUDPPacketRequest dHTUDPPacketRequest) {
        this.store_queries[0] = this.store_queries[0] + 1L;
        this.outgoingRequestSent(dHTUDPPacketRequest);
    }

    public void queryStoreOK() {
        this.store_queries[1] = this.store_queries[1] + 1L;
    }

    public void queryStoreFailed() {
        this.store_queries[2] = this.store_queries[2] + 1L;
    }

    public void queryStoreReceived() {
        this.store_queries[3] = this.store_queries[3] + 1L;
    }

    @Override
    public long[] getQueryStores() {
        return this.store_queries;
    }

    public void findNodeSent(DHTUDPPacketRequest dHTUDPPacketRequest) {
        this.find_nodes[0] = this.find_nodes[0] + 1L;
        this.outgoingRequestSent(dHTUDPPacketRequest);
    }

    public void findNodeOK() {
        this.find_nodes[1] = this.find_nodes[1] + 1L;
    }

    public void findNodeFailed() {
        this.find_nodes[2] = this.find_nodes[2] + 1L;
    }

    public void findNodeReceived() {
        this.find_nodes[3] = this.find_nodes[3] + 1L;
    }

    @Override
    public long[] getFindNodes() {
        return this.find_nodes;
    }

    public void findValueSent(DHTUDPPacketRequest dHTUDPPacketRequest) {
        this.find_values[0] = this.find_values[0] + 1L;
        this.outgoingRequestSent(dHTUDPPacketRequest);
    }

    public void findValueOK() {
        this.find_values[1] = this.find_values[1] + 1L;
    }

    public void findValueFailed() {
        this.find_values[2] = this.find_values[2] + 1L;
    }

    public void findValueReceived() {
        this.find_values[3] = this.find_values[3] + 1L;
    }

    @Override
    public long[] getFindValues() {
        return this.find_values;
    }

    public void storeSent(DHTUDPPacketRequest dHTUDPPacketRequest) {
        this.stores[0] = this.stores[0] + 1L;
        this.outgoingRequestSent(dHTUDPPacketRequest);
    }

    public void storeOK() {
        this.stores[1] = this.stores[1] + 1L;
    }

    public void storeFailed() {
        this.stores[2] = this.stores[2] + 1L;
    }

    public void storeReceived() {
        this.stores[3] = this.stores[3] + 1L;
    }

    @Override
    public long[] getStores() {
        return this.stores;
    }

    public void statsSent(DHTUDPPacketRequest dHTUDPPacketRequest) {
        this.stats[0] = this.stats[0] + 1L;
        this.outgoingRequestSent(dHTUDPPacketRequest);
    }

    public void statsOK() {
        this.stats[1] = this.stats[1] + 1L;
    }

    public void statsFailed() {
        this.stats[2] = this.stats[2] + 1L;
    }

    public void statsReceived() {
        this.stats[3] = this.stats[3] + 1L;
    }

    public void dataSent(DHTUDPPacketRequest dHTUDPPacketRequest) {
        this.data[0] = this.data[0] + 1L;
        this.outgoingRequestSent(dHTUDPPacketRequest);
    }

    public void dataOK() {
        this.data[1] = this.data[1] + 1L;
    }

    public void dataFailed() {
        this.data[2] = this.data[2] + 1L;
    }

    public void dataReceived() {
        this.data[3] = this.data[3] + 1L;
    }

    @Override
    public long[] getData() {
        return this.data;
    }

    protected void outgoingRequestSent(DHTUDPPacketRequest dHTUDPPacketRequest) {
        ++this.outgoing_requests;
    }

    public void incomingRequestReceived(DHTUDPPacketRequest dHTUDPPacketRequest, boolean bl) {
        ++this.incoming_requests;
        if (bl) {
            int n = dHTUDPPacketRequest.getAction();
            if (n == 1028) {
                this.aliens[0] = this.aliens[0] + 1L;
            } else if (n == 1030) {
                this.aliens[1] = this.aliens[1] + 1L;
            } else if (n == 1024) {
                this.aliens[2] = this.aliens[2] + 1L;
            } else if (n == 1034) {
                this.aliens[3] = this.aliens[3] + 1L;
            } else if (n == 1026) {
                this.aliens[4] = this.aliens[4] + 1L;
            } else if (n == 1036) {
                this.aliens[5] = this.aliens[5] + 1L;
            } else if (n == 1038) {
                this.aliens[6] = this.aliens[6] + 1L;
            }
        }
    }

    @Override
    public long[] getAliens() {
        return this.aliens;
    }

    @Override
    public long getIncomingRequests() {
        return this.incoming_requests;
    }

    public void recordSkew(InetSocketAddress inetSocketAddress, long l) {
        byte[] byArray = inetSocketAddress.getAddress().getAddress();
        if (this.skew_originator_bloom.contains(byArray)) {
            return;
        }
        this.skew_originator_bloom.add(byArray);
        int n = l < Integer.MAX_VALUE ? (int)l : 0x7FFFFFFE;
        int n2 = this.skew_pos;
        this.skew_values[n2++] = n;
        if (n2 == 256) {
            n2 = 0;
        }
        this.skew_pos = n2;
    }

    @Override
    public long getSkewAverage() {
        long l = SystemTime.getCurrentTime();
        if (l < this.last_skew_average_time || l - this.last_skew_average_time > 30000L) {
            int n;
            int[] nArray = (int[])this.skew_values.clone();
            int n2 = nArray[n = this.skew_pos] == Integer.MAX_VALUE ? n : 256;
            Arrays.sort(nArray, 0, n2);
            int n3 = n2 / 3;
            int n4 = 2 * n2 / 3;
            int n5 = n4 - n3;
            if (n5 < 5) {
                this.last_skew_average = 0L;
            } else {
                long l2 = 0L;
                for (int i = n3; i < n4; ++i) {
                    l2 += (long)nArray[i];
                }
                this.last_skew_average = l2 / (long)n5;
            }
            this.last_skew_average_time = l;
        }
        return this.last_skew_average;
    }

    @Override
    public String getString() {
        return "ping:" + this.getString(this.pings) + "," + "store:" + this.getString(this.stores) + "," + "node:" + this.getString(this.find_nodes) + "," + "value:" + this.getString(this.find_values) + "," + "stats:" + this.getString(this.stats) + "," + "data:" + this.getString(this.data) + "," + "kb:" + this.getString(this.key_blocks) + "," + "incoming:" + this.incoming_requests + "," + "alien:" + this.getString(this.aliens);
    }

    protected String getString(long[] lArray) {
        String string = "";
        for (int i = 0; i < lArray.length; ++i) {
            string = string + (i == 0 ? "" : ",") + lArray[i];
        }
        return string;
    }
}

