/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class MemoryMappedFile {
    public static final int MODE_READ_ONLY = 0;
    public static final int MODE_READ_WRITE = 1;
    public static long cache_hits = 0L;
    public static long cache_misses = 0L;
    private static final int BLOCK_SIZE = 0xA00000;
    private final File file;
    private int access_mode = 0;
    private FileChannel channel;
    private Object[] mapKeys;
    private int[] counts = new int[10000];

    public MemoryMappedFile(File file) {
        this.file = file;
        this.mapKeys = new Object[new Long(file.length() / 0xA00000L).intValue() + 1];
        Arrays.fill(this.counts, 0);
    }

    public int getAccessMode() {
        return this.access_mode;
    }

    public void setAccessMode(int n) {
        if (n == 0 && this.access_mode == 1 && this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
            }
            this.channel = null;
        }
        this.access_mode = n;
    }

    public void write(DirectByteBuffer directByteBuffer, int n, long l, int n2) throws IOException {
        if (this.access_mode == 0) {
            throw new IOException("cannot write to a read-only file");
        }
        if (directByteBuffer.limit((byte)2) - n < n2) {
            throw new IOException("not enough buffer remaining to write given length");
        }
        this.file.createNewFile();
        int n3 = new Long(l / 0xA00000L).intValue();
        int n4 = new Long(l % 0xA00000L).intValue();
        int n5 = 0;
        while (n5 < n2) {
            MappedByteBuffer mappedByteBuffer = null;
            long l2 = l + (long)n5;
            int n6 = 0xA00000 - n4;
            if (n2 - n5 < n6) {
                n6 = n2 - n5;
            }
            if (this.mapKeys.length > n3) {
                Object object = this.mapKeys[n3];
                if (object != null && (mappedByteBuffer = MemoryMapPool.getBuffer(object)) != null && mappedByteBuffer.capacity() < n4 + n6) {
                    MemoryMapPool.clean(mappedByteBuffer);
                    mappedByteBuffer = null;
                }
            } else {
                this.mapKeys = new Object[n3 * 2];
            }
            if (mappedByteBuffer == null) {
                int n7 = 0xA00000;
                if (l2 + (long)n6 > this.file.length()) {
                    n7 = n4 + n6;
                }
                mappedByteBuffer = this.createMappedBuffer(l2 - (long)n4, n7);
                ++cache_misses;
            } else {
                ++cache_hits;
            }
            directByteBuffer.position((byte)2, n + n5);
            directByteBuffer.limit((byte)2, directByteBuffer.position((byte)2) + n6);
            mappedByteBuffer.position(n4);
            mappedByteBuffer.put(directByteBuffer.getBuffer((byte)2));
            n5 += n6;
            this.mapKeys[n3] = MemoryMapPool.addBuffer(mappedByteBuffer);
            ++n3;
            n4 = 0;
        }
    }

    private MappedByteBuffer createMappedBuffer(long l, int n) throws IOException {
        if (this.channel == null) {
            FileChannel fileChannel = new RandomAccessFile(this.file, "rw").getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, l, n);
            if (this.access_mode == 0) {
                fileChannel.close();
            } else {
                this.channel = fileChannel;
            }
            return mappedByteBuffer;
        }
        return this.channel.map(FileChannel.MapMode.READ_WRITE, l, n);
    }

    private static class MemoryMapPool {
        private static long MAX_SIZE = 0x6400000L;
        private static final MemoryMapPool instance = new MemoryMapPool();
        private long total_size = 0L;
        private final AEMonitor buffers_mon = new AEMonitor("MemoryMappedFile:buffers");
        private final Map buffers = new LinkedHashMap((int)(MAX_SIZE / 0xA00000L), 0.75f, true){

            public boolean removeEldestEntry(Map.Entry entry) {
                boolean bl;
                boolean bl2 = bl = MemoryMapPool.this.total_size > MAX_SIZE;
                if (bl) {
                    MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)entry.getValue();
                    MemoryMapPool.this.total_size -= mappedByteBuffer.capacity();
                    MemoryMapPool.clean(mappedByteBuffer);
                }
                return bl;
            }
        };

        private MemoryMapPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MappedByteBuffer getBuffer(Object object) {
            try {
                MemoryMapPool.instance.buffers_mon.enter();
                MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)MemoryMapPool.instance.buffers.remove(object);
                if (mappedByteBuffer != null) {
                    MemoryMapPool.instance.total_size -= (long)mappedByteBuffer.capacity();
                }
                MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
                return mappedByteBuffer2;
            }
            finally {
                MemoryMapPool.instance.buffers_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object addBuffer(MappedByteBuffer mappedByteBuffer) {
            Object object = new Object();
            try {
                MemoryMapPool.instance.buffers_mon.enter();
                MemoryMapPool.instance.total_size += (long)mappedByteBuffer.capacity();
                MemoryMapPool.instance.buffers.put(object, mappedByteBuffer);
            }
            finally {
                MemoryMapPool.instance.buffers_mon.exit();
            }
            return object;
        }

        private static void clean(MappedByteBuffer mappedByteBuffer) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return null;
                }
            });
        }
    }
}

