/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.access.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequest;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequestListener;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class DiskAccessRequestImpl
implements DiskAccessRequest {
    protected static final short OP_READ = 1;
    protected static final short OP_WRITE = 2;
    protected static final short OP_WRITE_AND_FREE = 3;
    private CacheFile file;
    private long offset;
    private DirectByteBuffer buffer;
    private DiskAccessRequestListener listener;
    private short op;
    private short cache_policy;
    private int size;
    private volatile boolean cancelled;

    protected DiskAccessRequestImpl(CacheFile cacheFile, long l, DirectByteBuffer directByteBuffer, DiskAccessRequestListener diskAccessRequestListener, short s, short s2) {
        this.file = cacheFile;
        this.offset = l;
        this.buffer = directByteBuffer;
        this.listener = diskAccessRequestListener;
        this.op = s;
        this.cache_policy = s2;
        this.size = this.buffer.remaining((byte)4);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    protected void runRequest() {
        if (this.cancelled) {
            this.listener.requestCancelled(this);
            return;
        }
        try {
            if (this.op == 1) {
                this.file.read(this.buffer, this.offset, this.cache_policy);
            } else if (this.op == 2) {
                this.file.write(this.buffer, this.offset);
            } else {
                this.file.writeAndHandoverBuffer(this.buffer, this.offset);
            }
            this.listener.requestExecuted(this.size);
            this.listener.requestComplete(this);
        }
        catch (Throwable throwable) {
            this.listener.requestFailed(this, throwable);
        }
    }

    protected boolean canBeAggregatedWith(DiskAccessRequestImpl diskAccessRequestImpl) {
        return this.op == diskAccessRequestImpl.getOperation() && this.cache_policy == diskAccessRequestImpl.getCachePolicy();
    }

    protected static void runAggregated(DiskAccessRequestImpl diskAccessRequestImpl, DiskAccessRequestImpl[] diskAccessRequestImplArray) {
        int n;
        DiskAccessRequestImpl diskAccessRequestImpl2;
        int n2;
        int n3 = diskAccessRequestImpl.getOperation();
        CacheFile cacheFile = diskAccessRequestImpl.getFile();
        long l = diskAccessRequestImpl.getOffset();
        short s = diskAccessRequestImpl.getCachePolicy();
        DirectByteBuffer[] directByteBufferArray = new DirectByteBuffer[diskAccessRequestImplArray.length];
        long l2 = l;
        long l3 = 0L;
        for (n2 = 0; n2 < directByteBufferArray.length; ++n2) {
            diskAccessRequestImpl2 = diskAccessRequestImplArray[n2];
            if (l2 != diskAccessRequestImpl2.getOffset()) {
                Debug.out("assert failed: requests not contiguous");
            }
            n = diskAccessRequestImpl2.getSize();
            l2 += (long)n;
            l3 += (long)n;
            directByteBufferArray[n2] = diskAccessRequestImpl2.getBuffer();
        }
        try {
            if (n3 == 1) {
                cacheFile.read(directByteBufferArray, l, s);
            } else if (n3 == 2) {
                cacheFile.write(directByteBufferArray, l);
            } else {
                cacheFile.writeAndHandoverBuffers(directByteBufferArray, l);
            }
            diskAccessRequestImpl.getListener().requestExecuted(l3);
            for (n2 = 0; n2 < diskAccessRequestImplArray.length; ++n2) {
                diskAccessRequestImpl2 = diskAccessRequestImplArray[n2];
                diskAccessRequestImpl2.getListener().requestComplete(diskAccessRequestImpl2);
                if (diskAccessRequestImpl2 == diskAccessRequestImpl) continue;
                diskAccessRequestImpl2.getListener().requestExecuted(0L);
            }
        }
        catch (CacheFileManagerException cacheFileManagerException) {
            DiskAccessRequestImpl diskAccessRequestImpl3;
            int n4 = cacheFileManagerException.getFailIndex();
            for (n = 0; n < n4; ++n) {
                diskAccessRequestImpl3 = diskAccessRequestImplArray[n];
                diskAccessRequestImpl3.getListener().requestComplete(diskAccessRequestImpl3);
            }
            for (n = n4; n < diskAccessRequestImplArray.length; ++n) {
                diskAccessRequestImpl3 = diskAccessRequestImplArray[n];
                diskAccessRequestImpl3.getListener().requestFailed(diskAccessRequestImpl3, cacheFileManagerException);
            }
        }
        catch (Throwable throwable) {
            for (int i = 0; i < diskAccessRequestImplArray.length; ++i) {
                DiskAccessRequestImpl diskAccessRequestImpl4 = diskAccessRequestImplArray[i];
                diskAccessRequestImpl4.getListener().requestFailed(diskAccessRequestImpl4, throwable);
            }
        }
    }

    @Override
    public CacheFile getFile() {
        return this.file;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public DirectByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public short getCachePolicy() {
        return this.cache_policy;
    }

    protected int getOperation() {
        return this.op;
    }

    @Override
    public int getPriority() {
        return this.listener.getPriority();
    }

    protected DiskAccessRequestListener getListener() {
        return this.listener;
    }
}

