/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.ExternalStimulusListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerChannelImpl;

public class DownloadManagerEnhancer {
    public static final int TICK_PERIOD = 1000;
    private static DownloadManagerEnhancer singleton;
    private AzureusCore core;
    private Map<DownloadManager, EnhancedDownloadManager> download_map = new HashMap<DownloadManager, EnhancedDownloadManager>();
    private boolean progressive_enabled;

    public static synchronized DownloadManagerEnhancer initialise(AzureusCore azureusCore) {
        if (singleton == null) {
            singleton = new DownloadManagerEnhancer(azureusCore);
        }
        return singleton;
    }

    public static synchronized DownloadManagerEnhancer getSingleton() {
        return singleton;
    }

    protected DownloadManagerEnhancer(AzureusCore azureusCore) {
        this.core = azureusCore;
        this.core.getGlobalManager().addListener(new GlobalManagerListener(){

            @Override
            public void downloadManagerAdded(DownloadManager downloadManager) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void downloadManagerRemoved(DownloadManager downloadManager) {
                EnhancedDownloadManager enhancedDownloadManager;
                Map map = DownloadManagerEnhancer.this.download_map;
                synchronized (map) {
                    enhancedDownloadManager = (EnhancedDownloadManager)DownloadManagerEnhancer.this.download_map.remove(downloadManager);
                }
                if (enhancedDownloadManager != null) {
                    enhancedDownloadManager.destroy();
                }
            }

            @Override
            public void destroyInitiated() {
                DownloadManagerEnhancer.this.core.getGlobalManager().resumeDownloads();
            }

            @Override
            public void destroyed() {
            }

            @Override
            public void seedingStatusChanged(boolean bl, boolean bl2) {
            }
        });
        ExternalStimulusHandler.addListener(new ExternalStimulusListener(){

            @Override
            public boolean receive(String string, Map map) {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int query(String string, Map map) {
                if (string.equals("az3.downloadmanager.stream.eta")) {
                    Object object;
                    Object v = map.get("hash");
                    byte[] byArray = null;
                    if (v instanceof String) {
                        object = (String)v;
                        byArray = ((String)object).length() == 32 ? Base32.decode((String)object) : ByteFormatter.decodeString((String)object);
                    }
                    if (byArray != null) {
                        DownloadManagerEnhancer.this.getEnhancedDownload(byArray);
                    }
                    object = DownloadManagerEnhancer.this.download_map;
                    synchronized (object) {
                        for (EnhancedDownloadManager enhancedDownloadManager : DownloadManagerEnhancer.this.download_map.values()) {
                            if (byArray != null) {
                                long l;
                                byte[] byArray2 = enhancedDownloadManager.getHash();
                                if (byArray2 == null || !Arrays.equals(byArray, byArray2)) continue;
                                if (enhancedDownloadManager.getDownloadManager().isDownloadComplete(false)) {
                                    return 0;
                                }
                                if (!enhancedDownloadManager.supportsProgressiveMode()) {
                                    return Integer.MIN_VALUE;
                                }
                                if (!enhancedDownloadManager.getProgressiveMode()) {
                                    enhancedDownloadManager.setProgressiveMode(true);
                                }
                                if ((l = enhancedDownloadManager.getProgressivePlayETA()) > Integer.MAX_VALUE) {
                                    return Integer.MAX_VALUE;
                                }
                                return (int)l;
                            }
                            if (!enhancedDownloadManager.getProgressiveMode()) continue;
                            long l = enhancedDownloadManager.getProgressivePlayETA();
                            if (l > Integer.MAX_VALUE) {
                                return Integer.MAX_VALUE;
                            }
                            return (int)l;
                        }
                    }
                }
                return Integer.MIN_VALUE;
            }
        });
        SimpleTimer.addPeriodicEvent("DownloadManagerEnhancer:speedChecker", 1000L, new TimerEventPerformer(){
            private int tick_count;

            @Override
            public void perform(TimerEvent timerEvent2) {
                ++this.tick_count;
                List list = DownloadManagerEnhancer.this.core.getGlobalManager().getDownloadManagers();
                for (int i = 0; i < list.size(); ++i) {
                    DownloadManager downloadManager = (DownloadManager)list.get(i);
                    int n = downloadManager.getState();
                    if (n != 50 && n != 60) continue;
                    EnhancedDownloadManager enhancedDownloadManager = DownloadManagerEnhancer.this.getEnhancedDownload(downloadManager);
                    if (enhancedDownloadManager == null) {
                        return;
                    }
                    enhancedDownloadManager.updateStats(this.tick_count);
                }
            }
        });
        DiskManagerChannelImpl.addListener(new DiskManagerChannelImpl.channelCreateListener(){

            @Override
            public void channelCreated(DiskManagerChannel diskManagerChannel) {
                try {
                    EnhancedDownloadManager enhancedDownloadManager = DownloadManagerEnhancer.this.getEnhancedDownload(PluginCoreUtils.unwrap(diskManagerChannel.getFile().getDownload()));
                    if (enhancedDownloadManager == null) {
                        return;
                    }
                    if (enhancedDownloadManager.getDownloadManager().isDownloadComplete(true)) {
                        return;
                    }
                    if (!enhancedDownloadManager.getProgressiveMode() && enhancedDownloadManager.supportsProgressiveMode()) {
                        Debug.out("Enabling progressive mode for '" + enhancedDownloadManager.getName() + "' due to external stream");
                        enhancedDownloadManager.setProgressiveMode(true);
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        });
    }

    protected AzureusCore getCore() {
        return this.core;
    }

    public EnhancedDownloadManager getEnhancedDownload(byte[] byArray) {
        DownloadManager downloadManager = this.core.getGlobalManager().getDownloadManager(new HashWrapper(byArray));
        if (downloadManager == null) {
            return null;
        }
        return this.getEnhancedDownload(downloadManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnhancedDownloadManager getEnhancedDownload(DownloadManager downloadManager) {
        TOTorrent tOTorrent = downloadManager.getTorrent();
        if (tOTorrent == null) {
            return null;
        }
        DownloadManager downloadManager2 = downloadManager.getGlobalManager().getDownloadManager(tOTorrent);
        if (downloadManager2 != downloadManager) {
            return null;
        }
        Map<DownloadManager, EnhancedDownloadManager> map = this.download_map;
        synchronized (map) {
            EnhancedDownloadManager enhancedDownloadManager = this.download_map.get(downloadManager);
            if (enhancedDownloadManager == null) {
                enhancedDownloadManager = new EnhancedDownloadManager(this, downloadManager);
                this.download_map.put(downloadManager, enhancedDownloadManager);
            }
            return enhancedDownloadManager;
        }
    }

    public boolean isProgressiveAvailable() {
        if (this.progressive_enabled) {
            return true;
        }
        PluginInterface pluginInterface = this.core.getPluginManager().getPluginInterfaceByID("azupnpav", true);
        if (pluginInterface != null) {
            this.progressive_enabled = true;
        }
        return this.progressive_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadManager findDownloadManager(String string) {
        Map<DownloadManager, EnhancedDownloadManager> map = this.download_map;
        synchronized (map) {
            for (DownloadManager downloadManager : this.download_map.keySet()) {
                String string2;
                TOTorrent tOTorrent = downloadManager.getTorrent();
                if (!PlatformTorrentUtils.isContent(tOTorrent, true) || !string.equals(string2 = PlatformTorrentUtils.getContentHash(tOTorrent))) continue;
                return downloadManager;
            }
        }
        return null;
    }
}

