/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeAnalysisListener;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProviderAnalysis;
import com.aelitis.azureus.core.devices.TranscodeQueue;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.download.StreamManagerDownload;
import com.aelitis.azureus.core.download.StreamManagerDownloadListener;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class StreamManager {
    private static final int BUFFER_SECS = 30;
    private static StreamManager singleton = new StreamManager();
    private TorrentAttribute mi_ta;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();

    public static StreamManager getSingleton() {
        return singleton;
    }

    private StreamManager() {
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        this.mi_ta = pluginInterface.getTorrentManager().getPluginAttribute("sm_metainfo");
    }

    public StreamManagerDownload stream(DownloadManager downloadManager, int n, URL uRL, boolean bl, StreamManagerDownloadListener streamManagerDownloadListener) {
        SMDImpl sMDImpl = new SMDImpl(downloadManager, n, uRL, bl, streamManagerDownloadListener);
        return sMDImpl;
    }

    private class SMDImpl
    extends AERunnable
    implements StreamManagerDownload {
        private DownloadManager dm;
        private int file_index;
        private URL url;
        private StreamManagerDownloadListener listener;
        private boolean preview_mode;
        private AESemaphore active_sem;
        private TranscodeJob active_job;
        private volatile boolean cancelled;

        private SMDImpl(DownloadManager downloadManager, int n, URL uRL, boolean bl, StreamManagerDownloadListener streamManagerDownloadListener) {
            this.dm = downloadManager;
            this.file_index = n;
            this.url = uRL;
            this.preview_mode = bl;
            this.listener = streamManagerDownloadListener;
            StreamManager.this.dispatcher.dispatch(this);
        }

        @Override
        public DownloadManager getDownload() {
            return this.dm;
        }

        @Override
        public int getFileIndex() {
            return this.file_index;
        }

        @Override
        public URL getURL() {
            return this.url;
        }

        @Override
        public boolean getPreviewMode() {
            return this.preview_mode;
        }

        @Override
        public void setPreviewMode(boolean bl) {
            this.preview_mode = bl;
            this.listener.updateActivity("Preview mode changed to " + this.preview_mode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runSupport() {
            boolean bl = false;
            boolean bl2 = false;
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                DiskManagerFileInfo diskManagerFileInfo;
                block33: {
                    Map map;
                    Download download = PluginCoreUtils.wrap(this.dm);
                    diskManagerFileInfo = download.getDiskManagerFileInfo(this.file_index);
                    HashMap<String, HashMap<String, Long>> hashMap = download.getMapAttribute(StreamManager.this.mi_ta);
                    Long l = null;
                    Long l2 = null;
                    if (hashMap != null && (map = (Map)hashMap.get(String.valueOf(this.file_index))) != null) {
                        l = (Long)map.get("duration");
                        l2 = (Long)map.get("video_width");
                    }
                    if (l == null) {
                        this.checkPlugin("vuzexcode", "media analyser");
                        try {
                            object5 = DeviceManagerFactory.getSingleton();
                            object4 = object5.getTranscodeManager();
                            DeviceMediaRenderer deviceMediaRenderer = (DeviceMediaRenderer)object5.addVirtualDevice(3, "18a0b53a-a466-6795-1d0f-cf38c830ca0e", "generic", "Media Analyser");
                            deviceMediaRenderer.setHidden(true);
                            TranscodeQueue transcodeQueue = object4.getQueue();
                            object3 = transcodeQueue.getJobs();
                            for (TranscodeJob transcodeJob : object3) {
                                if (transcodeJob.getTarget() != deviceMediaRenderer) continue;
                                transcodeJob.removeForce();
                            }
                            Object[] objectArray = deviceMediaRenderer.getTranscodeProfiles();
                            Object throwableArray = null;
                            for (Object throwableArray2 : objectArray) {
                                if (!throwableArray2.getName().equals("Generic MP4")) continue;
                                throwableArray = throwableArray2;
                                break;
                            }
                            if (throwableArray == null) {
                                throw new Exception("Analyser transcode profile not found");
                            }
                            this.listener.updateActivity("analysing media");
                            TranscodeJob transcodeJob = transcodeQueue.add(deviceMediaRenderer, (TranscodeProfile)throwableArray, diskManagerFileInfo, true);
                            try {
                                AESemaphore aESemaphore = new AESemaphore("analyserWait");
                                Object object6 = StreamManager.this;
                                synchronized (object6) {
                                    if (this.cancelled) {
                                        throw new Exception("Cancelled");
                                    }
                                    this.active_sem = aESemaphore;
                                    this.active_job = transcodeJob;
                                }
                                object6 = new long[3];
                                Throwable[] throwableArray2 = new Throwable[]{null};
                                transcodeJob.analyseNow(new TranscodeAnalysisListener((long[])object6, transcodeJob, aESemaphore, throwableArray2){
                                    final /* synthetic */ long[] val$properties;
                                    final /* synthetic */ TranscodeJob val$tj;
                                    final /* synthetic */ AESemaphore val$sem;
                                    final /* synthetic */ Throwable[] val$error;
                                    {
                                        this.val$properties = lArray;
                                        this.val$tj = transcodeJob;
                                        this.val$sem = aESemaphore;
                                        this.val$error = throwableArray;
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void analysisComplete(TranscodeJob transcodeJob, TranscodeProviderAnalysis transcodeProviderAnalysis) {
                                        try {
                                            this.val$properties[0] = transcodeProviderAnalysis.getLongProperty(2);
                                            this.val$properties[1] = transcodeProviderAnalysis.getLongProperty(3);
                                            this.val$properties[2] = transcodeProviderAnalysis.getLongProperty(4);
                                            this.val$tj.removeForce();
                                        }
                                        finally {
                                            this.val$sem.release();
                                        }
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void analysisFailed(TranscodeJob transcodeJob, TranscodeException transcodeException) {
                                        try {
                                            this.val$error[0] = transcodeException;
                                            this.val$tj.removeForce();
                                        }
                                        finally {
                                            this.val$sem.release();
                                        }
                                    }
                                });
                                aESemaphore.reserve();
                                Map<String, Long> map2 = StreamManager.this;
                                synchronized (map2) {
                                    if (this.cancelled) {
                                        throw new Exception("Cancelled");
                                    }
                                    this.active_job = null;
                                    this.active_sem = null;
                                }
                                if (throwableArray2[0] != null) {
                                    throw throwableArray2[0];
                                }
                                map2 = (Map)(hashMap = hashMap == null ? new HashMap<String, HashMap<String, Long>>() : new HashMap(hashMap)).get(String.valueOf(this.file_index));
                                if (map2 == null) {
                                    map2 = new HashMap<String, Long>();
                                    hashMap.put(String.valueOf(this.file_index), (HashMap<String, Long>)map2);
                                }
                                map2.put("duration", (long)object6[0]);
                                map2.put("video_width", (long)object6[1]);
                                map2.put("video_height", (long)object6[2]);
                                download.setMapAttribute(StreamManager.this.mi_ta, hashMap);
                                object2 = object6[0];
                                object = object6[1];
                                break block33;
                            }
                            catch (Throwable throwable) {
                                transcodeJob.removeForce();
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            throw new Exception("Media analysis failed", throwable);
                        }
                    }
                    object2 = l;
                    Object object6 = object = l2 == null ? 0L : l2;
                }
                if (object == 0L) {
                    throw new Exception("Media analysis failed - video stream not found");
                }
                if (object2 == 0L) {
                    throw new Exception("Media analysis failed - duration unknown");
                }
                object5 = this.checkPlugin("azemp", "media player");
                object4 = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(this.dm);
                long l = diskManagerFileInfo.getLength() / (object2 / 1000L);
                this.listener.updateActivity("media duraton=" + object2 / 1000L + " sec, average rate=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(l));
                ((EnhancedDownloadManager)object4).setExplicitProgressive(30, l, this.file_index);
                if (!((EnhancedDownloadManager)object4).setProgressiveMode(true)) {
                    throw new Exception("Failed to set download as progressive");
                }
                while (true) {
                    if (this.cancelled) {
                        throw new Exception("Cancelled");
                    }
                    object3 = this.updateETA((EnhancedDownloadManager)object4);
                    if (object3[0] <= 0L || this.preview_mode && object3[1] >= 5L) break;
                    int n = this.dm.getState();
                    if (n == 100 || n == 70) {
                        throw new Exception("Streaming abandoned, download isn't running");
                    }
                    Thread.sleep(1000L);
                }
                object3 = object5.getPlugin().getClass().getClassLoader().loadClass("com.azureus.plugins.azemp.ui.swt.emp.EmbeddedPlayerWindowSWT");
                Method method = ((Class)object3).getMethod("openWindow", URL.class, String.class);
                method.invoke(null, this.url, diskManagerFileInfo.getFile(true).getName());
                new AEThread2("streamMon", (EnhancedDownloadManager)object4){
                    final /* synthetic */ EnhancedDownloadManager val$edm;
                    {
                        this.val$edm = enhancedDownloadManager;
                        super(string);
                    }

                    @Override
                    public void run() {
                        try {
                            while (this.val$edm.getProgressiveMode() && !SMDImpl.this.cancelled) {
                                SMDImpl.this.updateETA(this.val$edm);
                                Thread.sleep(1000L);
                            }
                        }
                        catch (Throwable throwable) {
                            Debug.out(throwable);
                        }
                    }
                }.start();
                bl = true;
            }
            catch (Throwable throwable) {
                bl2 = true;
                this.listener.failed(throwable);
            }
            finally {
                if (bl) {
                    this.listener.ready();
                } else if (!bl2) {
                    this.listener.failed(new Exception("Streaming setup failed, reason unknown"));
                }
            }
        }

        private long[] updateETA(EnhancedDownloadManager enhancedDownloadManager) {
            long l = enhancedDownloadManager.getProgressivePlayETA();
            int n = l >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            EnhancedDownloadManager.progressiveStats progressiveStats2 = enhancedDownloadManager.getProgressiveStats();
            long l2 = progressiveStats2.getCurrentProviderPosition(false);
            long l3 = enhancedDownloadManager.getContiguousAvailableBytes(enhancedDownloadManager.getPrimaryFile().getIndex(), l2, 0L);
            long l4 = progressiveStats2.getStreamBytesPerSecondMin();
            long l5 = progressiveStats2.getSecondsToDownload();
            long l6 = progressiveStats2.getSecondsToWatch();
            int n2 = l4 <= 0L ? Integer.MAX_VALUE : (int)(l3 / l4);
            System.out.println("eta=" + n + ", view=" + l2 + ", buffer=" + l3 + "/" + n2 + ", dl=" + l5 + ", view=" + l6);
            this.listener.updateStats(n, n2, l3, 30);
            return new long[]{n, n2};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            TranscodeJob transcodeJob;
            StreamManager streamManager = StreamManager.this;
            synchronized (streamManager) {
                this.cancelled = true;
                transcodeJob = this.active_job;
                if (this.active_sem != null) {
                    this.active_sem.release();
                }
            }
            if (transcodeJob != null) {
                transcodeJob.removeForce();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PluginInterface checkPlugin(String string, String string2) throws Throwable {
            PluginManager pluginManager = AzureusCoreFactory.getSingleton().getPluginManager();
            PluginInterface pluginInterface = pluginManager.getPluginInterfaceByID(string, false);
            if (pluginInterface == null) {
                this.listener.updateActivity("Installing " + string2);
                AESemaphore aESemaphore = new AESemaphore("analyserWait");
                Throwable[] throwableArray = StreamManager.this;
                synchronized (StreamManager.this) {
                    if (this.cancelled) {
                        throw new Exception("Cancelled");
                    }
                    this.active_sem = aESemaphore;
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    throwableArray = new Throwable[]{null};
                    aESemaphore.reserve();
                    StreamManager streamManager = StreamManager.this;
                    synchronized (streamManager) {
                        if (this.cancelled) {
                            throw new Exception("Cancelled");
                        }
                        this.active_sem = null;
                    }
                    if (throwableArray[0] != null) {
                        throw throwableArray[0];
                    }
                    long l = SystemTime.getMonotonousTime();
                    this.listener.updateActivity("Waiting for plugin initialisation");
                    while (true) {
                        if (this.cancelled) {
                            throw new Exception("Cancelled");
                        }
                        if (SystemTime.getMonotonousTime() - l >= 30000L) {
                            throw new Exception("Timeout waiting for " + string2 + " to initialise");
                        }
                        pluginInterface = pluginManager.getPluginInterfaceByID(string, false);
                        if (pluginInterface != null && pluginInterface.getPluginState().isOperational()) {
                            return pluginInterface;
                        }
                        Thread.sleep(250L);
                    }
                }
            }
            if (!pluginInterface.getPluginState().isOperational()) {
                throw new Exception(string2 + " not operational");
            }
            return pluginInterface;
        }
    }
}

