/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.drivedetector.impl;

import com.aelitis.azureus.core.drivedetector.DriveDetectedInfo;
import com.aelitis.azureus.core.drivedetector.DriveDetectedListener;
import com.aelitis.azureus.core.drivedetector.DriveDetector;
import com.aelitis.azureus.core.drivedetector.impl.DriveDetectedInfoImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class DriveDetectorImpl
implements DriveDetector,
AEDiagnosticsEvidenceGenerator {
    private AEMonitor2 mon_driveDetector = new AEMonitor2("driveDetector");
    private CopyOnWriteList<DriveDetectedListener> listListeners = new CopyOnWriteList(1);
    private Map<File, Map> mapDrives = new HashMap<File, Map>(1);

    public DriveDetectorImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DriveDetectedInfo[] getDetectedDriveInfo() {
        this.mon_driveDetector.enter();
        try {
            int n = 0;
            DriveDetectedInfo[] driveDetectedInfoArray = new DriveDetectedInfo[this.mapDrives.size()];
            for (File file : this.mapDrives.keySet()) {
                driveDetectedInfoArray[n++] = new DriveDetectedInfoImpl(file, this.mapDrives.get(file));
            }
            DriveDetectedInfo[] driveDetectedInfoArray2 = driveDetectedInfoArray;
            return driveDetectedInfoArray2;
        }
        finally {
            this.mon_driveDetector.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DriveDetectedListener driveDetectedListener) {
        this.mon_driveDetector.enter();
        try {
            if (this.listListeners.contains(driveDetectedListener)) {
                return;
            }
            this.listListeners.add(driveDetectedListener);
            for (File file : this.mapDrives.keySet()) {
                try {
                    driveDetectedListener.driveDetected(new DriveDetectedInfoImpl(file, this.mapDrives.get(file)));
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
        }
        finally {
            this.mon_driveDetector.exit();
        }
    }

    @Override
    public void removeListener(DriveDetectedListener driveDetectedListener) {
        this.listListeners.remove(driveDetectedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void driveDetected(File file, Map map) {
        block7: {
            file = this.normaliseFile(file);
            this.mon_driveDetector.enter();
            try {
                if (!this.mapDrives.containsKey(file)) {
                    map.put("File", file);
                    this.mapDrives.put(file, map);
                    break block7;
                }
                return;
            }
            finally {
                this.mon_driveDetector.exit();
            }
        }
        for (DriveDetectedListener driveDetectedListener : this.listListeners) {
            try {
                driveDetectedListener.driveDetected(new DriveDetectedInfoImpl(file, map));
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void driveRemoved(File file) {
        Map map;
        file = this.normaliseFile(file);
        this.mon_driveDetector.enter();
        try {
            map = this.mapDrives.remove(file);
            if (map == null) {
                return;
            }
        }
        finally {
            this.mon_driveDetector.exit();
        }
        for (DriveDetectedListener driveDetectedListener : this.listListeners) {
            try {
                driveDetectedListener.driveRemoved(new DriveDetectedInfoImpl(file, map));
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    protected File normaliseFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        Map<File, Map> map = this.mapDrives;
        synchronized (map) {
            indentWriter.println("DriveDetector: " + this.mapDrives.size() + " drives");
            for (File file : this.mapDrives.keySet()) {
                try {
                    indentWriter.indent();
                    indentWriter.println(file.getPath());
                    try {
                        indentWriter.indent();
                        Map map2 = this.mapDrives.get(file);
                        for (Object k : map2.keySet()) {
                            Object v = map2.get(k);
                            indentWriter.println(k + ": " + v);
                        }
                    }
                    finally {
                        indentWriter.exdent();
                    }
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
                finally {
                    indentWriter.exdent();
                }
            }
        }
    }
}

