/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.instancemanager.impl;

import com.aelitis.azureus.core.instancemanager.AZInstanceManagerAdapter;
import com.aelitis.azureus.core.instancemanager.impl.AZInstanceImpl;
import com.aelitis.azureus.core.instancemanager.impl.AZInstanceManagerImpl;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginListener;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;

public class AZMyInstanceImpl
extends AZInstanceImpl {
    public static final long FORCE_READ_EXT_MIN = 28800000L;
    public static final long UPNP_READ_MIN = 300000L;
    private AZInstanceManagerAdapter adapter;
    private AZInstanceManagerImpl manager;
    private String id;
    private InetAddress internal_address;
    private int tcp_port;
    private int udp_port;
    private int udp_non_data_port;
    private long last_upnp_read;
    private InetAddress dht_address;
    private long dht_address_time;
    private long last_force_read_ext;
    private InetAddress last_external_address;

    protected AZMyInstanceImpl(AZInstanceManagerAdapter aZInstanceManagerAdapter, AZInstanceManagerImpl aZInstanceManagerImpl) {
        this.adapter = aZInstanceManagerAdapter;
        this.manager = aZInstanceManagerImpl;
        this.id = this.adapter.getID();
        if (this.id.length() == 0) {
            this.id = "" + SystemTime.getCurrentTime();
        }
        this.id = ByteFormatter.encodeString(new SHA1Simple().calculateHash(this.id.getBytes()));
        COConfigurationManager.addListener(new COConfigurationListener(){

            @Override
            public void configurationSaved() {
                AZMyInstanceImpl.this.readConfig(false);
            }
        });
        this.readConfig(true);
        this.adapter.addListener(new AZInstanceManagerAdapter.StateListener(){

            @Override
            public void started() {
                DHTPlugin dHTPlugin = AZMyInstanceImpl.this.adapter.getDHTPlugin();
                if (dHTPlugin != null) {
                    dHTPlugin.addListener(new DHTPluginListener(){

                        @Override
                        public void localAddressChanged(DHTPluginContact dHTPluginContact) {
                            InetAddress inetAddress = dHTPluginContact.getAddress().getAddress();
                            if (AZMyInstanceImpl.this.sameFamily(AZMyInstanceImpl.this.internal_address, inetAddress)) {
                                AZMyInstanceImpl.this.dht_address = inetAddress;
                                AZMyInstanceImpl.this.dht_address_time = SystemTime.getCurrentTime();
                                AZMyInstanceImpl.this.manager.informChanged(AZMyInstanceImpl.this);
                            }
                        }
                    });
                }
            }

            @Override
            public void stopped() {
            }
        });
    }

    protected void readConfig(boolean bl) {
        InetAddress inetAddress = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
        if (inetAddress == null) {
            try {
                inetAddress = InetAddress.getByName("0.0.0.0");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int[] nArray = this.adapter.getPorts();
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        boolean bl2 = true;
        if (!bl) {
            bl2 = this.internal_address.equals(inetAddress) && this.tcp_port == n && this.udp_port == n2 && this.udp_non_data_port == n3;
        }
        this.internal_address = inetAddress;
        this.tcp_port = n;
        this.udp_port = n2;
        this.udp_non_data_port = n3;
        if (!bl2) {
            this.manager.informChanged(this);
        }
    }

    protected InetAddress readExternalAddress() {
        boolean bl;
        long l;
        Object object;
        block26: {
            long l2;
            Object object2;
            object = null;
            if (this.manager.isClosing()) {
                object = this.last_external_address;
                if (object == null) {
                    try {
                        object = InetAddress.getByName("127.0.0.1");
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                return object;
            }
            DHTPlugin dHTPlugin = this.adapter.getDHTPlugin();
            if (this.dht_address != null && this.dht_address_time <= SystemTime.getCurrentTime() && (object2 = this.adapter.getVCPublicAddress()) != null && (l2 = object2.getCacheTime()) <= this.dht_address_time) {
                object = this.dht_address;
            }
            if (object == null && (dHTPlugin == null || dHTPlugin.getStatus() != 3) && (object2 = this.adapter.getVCPublicAddress()) != null) {
                try {
                    object = InetAddress.getByName(object2.getAddress());
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            if (object == null && dHTPlugin != null) {
                try {
                    object2 = dHTPlugin.getLocalAddress().getAddress().getAddress();
                    if (this.sameFamily(this.internal_address, (InetAddress)object2)) {
                        object = object2;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.last_force_read_ext > (l = SystemTime.getCurrentTime())) {
                this.last_force_read_ext = l;
            }
            boolean bl2 = bl = l - this.last_force_read_ext > 28800000L;
            if (object == null && this.last_external_address != null) {
                if (this.last_upnp_read > l) {
                    this.last_upnp_read = l;
                }
                if (l - this.last_upnp_read > 300000L || bl) {
                    this.last_upnp_read = l;
                    try {
                        UPnPPlugin uPnPPlugin = this.adapter.getUPnPPlugin();
                        if (uPnPPlugin == null) break block26;
                        String[] stringArray = uPnPPlugin.getExternalIPAddresses();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!stringArray[i].equals(this.last_external_address.getHostAddress())) continue;
                            object = this.last_external_address;
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        if (object == null && bl) {
            this.last_force_read_ext = l;
            object = this.adapter.getPublicAddress();
        }
        if (object == null) {
            if (this.last_external_address != null) {
                object = this.last_external_address;
            } else {
                try {
                    object = InetAddress.getByName("127.0.0.1");
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        } else {
            this.last_external_address = object;
        }
        return object;
    }

    protected boolean sameFamily(InetAddress inetAddress, InetAddress inetAddress2) {
        return inetAddress instanceof Inet4Address == inetAddress2 instanceof Inet4Address;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getApplicationID() {
        return SystemProperties.getApplicationIdentifier() + "_" + SystemProperties.getApplicationVersion();
    }

    @Override
    public InetAddress getInternalAddress() {
        return this.internal_address;
    }

    @Override
    public List getInternalAddresses() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        if (this.internal_address != null) {
            arrayList.add(this.internal_address);
        }
        return arrayList;
    }

    @Override
    public InetAddress getExternalAddress() {
        return this.readExternalAddress();
    }

    @Override
    public int getTCPListenPort() {
        return this.tcp_port;
    }

    @Override
    public int getUDPListenPort() {
        return this.udp_port;
    }

    @Override
    public int getUDPNonDataListenPort() {
        return this.udp_non_data_port;
    }

    @Override
    public Map<String, Object> getProperties() {
        return COConfigurationManager.getMapParameter("instance.manager.props", null);
    }
}

