/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.lws.LightWeightSeed;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadCompletionListener;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadAnnounceResultImpl;

public class LWSDownload
implements Download {
    private LightWeightSeed lws;
    private TRTrackerAnnouncer announcer;
    private DownloadAnnounceResultImpl announce_result;
    private Map user_data = new HashMap();
    private Map torrent_attributes = new HashMap();
    private DownloadScrapeResult scrape_result = new DownloadScrapeResult(){

        @Override
        public Download getDownload() {
            return LWSDownload.this;
        }

        @Override
        public int getResponseType() {
            return LWSDownload.this.announce_result.getResponseType() == 1 ? 1 : 2;
        }

        @Override
        public int getSeedCount() {
            return LWSDownload.this.announce_result.getSeedCount();
        }

        @Override
        public int getNonSeedCount() {
            int n = this.getSeedCount();
            int n2 = LWSDownload.this.announce_result.getReportedPeerCount();
            int n3 = n2 - n;
            int n4 = LWSDownload.this.announce_result.getNonSeedCount();
            if (n4 < n3) {
                n4 = n3;
            }
            return n4;
        }

        @Override
        public long getScrapeStartTime() {
            return 0L;
        }

        @Override
        public void setNextScrapeStartTime(long l) {
        }

        @Override
        public long getNextScrapeStartTime() {
            return 0L;
        }

        @Override
        public String getStatus() {
            if (this.getResponseType() == 1) {
                return "OK";
            }
            return LWSDownload.this.announce_result.getError();
        }

        @Override
        public URL getURL() {
            return LWSDownload.this.announce_result.getURL();
        }
    };

    protected LWSDownload(LightWeightSeed lightWeightSeed, TRTrackerAnnouncer tRTrackerAnnouncer) {
        this.lws = lightWeightSeed;
        this.announcer = tRTrackerAnnouncer;
        this.announce_result = new DownloadAnnounceResultImpl(this, this.announcer.getLastResponse());
    }

    @Override
    public int getState() {
        return 5;
    }

    @Override
    public int getSubState() {
        return 5;
    }

    @Override
    public String getErrorStateDetails() {
        return "";
    }

    @Override
    public void setFlag(long l, boolean bl) {
        this.notSupported();
    }

    @Override
    public boolean getFlag(long l) {
        return false;
    }

    @Override
    public long getFlags() {
        return 0L;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public File[] calculateDefaultPaths(boolean bl) {
        return new File[2];
    }

    @Override
    public SaveLocationChange calculateDefaultDownloadLocation() {
        return null;
    }

    @Override
    public boolean isInDefaultSaveDir() {
        return false;
    }

    @Override
    public Torrent getTorrent() {
        return this.lws.getTorrent();
    }

    @Override
    public void initialize() throws DownloadException {
    }

    @Override
    public void start() throws DownloadException {
    }

    @Override
    public void startDownload(boolean bl) {
    }

    @Override
    public void stopDownload() {
    }

    @Override
    public void stop() throws DownloadException {
    }

    @Override
    public void stopAndQueue() throws DownloadException {
    }

    @Override
    public void restart() throws DownloadException {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void recheckData() throws DownloadException {
    }

    @Override
    public boolean isStartStopLocked() {
        return false;
    }

    @Override
    public boolean isForceStart() {
        return true;
    }

    @Override
    public void setForceStart(boolean bl) {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void setPriority(int n) {
    }

    @Override
    public boolean isPriorityLocked() {
        return false;
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public String getName() {
        return this.lws.getName();
    }

    @Override
    public String getTorrentFileName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(TorrentAttribute torrentAttribute) {
        Map map = this.torrent_attributes;
        synchronized (map) {
            return (String)this.torrent_attributes.get(torrentAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(TorrentAttribute torrentAttribute, String string) {
        Map map = this.torrent_attributes;
        synchronized (map) {
            this.torrent_attributes.put(torrentAttribute, string);
        }
    }

    @Override
    public String[] getListAttribute(TorrentAttribute torrentAttribute) {
        TorrentManager torrentManager = PluginInitializer.getDefaultInterface().getTorrentManager();
        if (torrentAttribute == torrentManager.getAttribute("Networks")) {
            return new String[]{"Public"};
        }
        if (torrentAttribute == torrentManager.getAttribute("PeerSources")) {
            return new String[]{"DHT"};
        }
        return null;
    }

    @Override
    public void setListAttribute(TorrentAttribute torrentAttribute, String[] stringArray) {
        this.notSupported();
    }

    @Override
    public void setMapAttribute(TorrentAttribute torrentAttribute, Map map) {
        this.notSupported();
    }

    @Override
    public Map getMapAttribute(TorrentAttribute torrentAttribute) {
        return null;
    }

    @Override
    public void setIntAttribute(TorrentAttribute torrentAttribute, int n) {
        this.notSupported();
    }

    @Override
    public int getIntAttribute(TorrentAttribute torrentAttribute) {
        return 0;
    }

    @Override
    public void setLongAttribute(TorrentAttribute torrentAttribute, long l) {
        this.notSupported();
    }

    @Override
    public long getLongAttribute(TorrentAttribute torrentAttribute) {
        return 0L;
    }

    @Override
    public void setBooleanAttribute(TorrentAttribute torrentAttribute, boolean bl) {
        this.notSupported();
    }

    @Override
    public boolean getBooleanAttribute(TorrentAttribute torrentAttribute) {
        return false;
    }

    @Override
    public boolean hasAttribute(TorrentAttribute torrentAttribute) {
        return false;
    }

    @Override
    public void addAttributeListener(DownloadAttributeListener downloadAttributeListener, TorrentAttribute torrentAttribute, int n) {
    }

    @Override
    public void removeAttributeListener(DownloadAttributeListener downloadAttributeListener, TorrentAttribute torrentAttribute, int n) {
    }

    @Override
    public String getCategoryName() {
        return null;
    }

    @Override
    public void setCategory(String string) {
        this.notSupported();
    }

    @Override
    public void remove() throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    @Override
    public void remove(boolean bl, boolean bl2) throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public int getPosition() {
        return 0;
    }

    @Override
    public long getCreationTime() {
        return 0L;
    }

    @Override
    public void setPosition(int n) {
        this.notSupported();
    }

    @Override
    public void moveUp() {
        this.notSupported();
    }

    @Override
    public void moveDown() {
        this.notSupported();
    }

    @Override
    public void moveTo(int n) {
        this.notSupported();
    }

    @Override
    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult downloadAnnounceResult) {
        this.announcer.setAnnounceResult(downloadAnnounceResult);
    }

    @Override
    public void setScrapeResult(DownloadScrapeResult downloadScrapeResult) {
    }

    @Override
    public DownloadAnnounceResult getLastAnnounceResult() {
        this.announce_result.setContent(this.announcer.getLastResponse());
        return this.announce_result;
    }

    @Override
    public DownloadScrapeResult getLastScrapeResult() {
        this.announce_result.setContent(this.announcer.getLastResponse());
        return this.scrape_result;
    }

    @Override
    public DownloadActivationEvent getActivationState() {
        return null;
    }

    @Override
    public DownloadStats getStats() {
        return null;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public void setMaximumDownloadKBPerSecond(int n) {
        this.notSupported();
    }

    @Override
    public int getMaximumDownloadKBPerSecond() {
        return 0;
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return 0;
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int n) {
        this.notSupported();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return 0;
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int n) {
        this.notSupported();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isComplete(boolean bl) {
        return true;
    }

    @Override
    public boolean isChecking() {
        return false;
    }

    @Override
    public String getSavePath() {
        return "";
    }

    @Override
    public void moveDataFiles(File file) throws DownloadException {
        this.notSupported();
    }

    @Override
    public boolean canMoveDataFiles() {
        return false;
    }

    @Override
    public void moveTorrentFile(File file) throws DownloadException {
        this.notSupported();
    }

    @Override
    public void renameDownload(String string) throws DownloadException {
        this.notSupported();
    }

    @Override
    public PeerManager getPeerManager() {
        return null;
    }

    @Override
    public DiskManager getDiskManager() {
        return null;
    }

    @Override
    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        return null;
    }

    @Override
    public DiskManagerFileInfo getDiskManagerFileInfo(int n) {
        return null;
    }

    @Override
    public void requestTrackerAnnounce() {
    }

    @Override
    public void requestTrackerAnnounce(boolean bl) {
    }

    @Override
    public void requestTrackerScrape(boolean bl) {
    }

    @Override
    public void addListener(DownloadListener downloadListener2) {
    }

    @Override
    public void removeListener(DownloadListener downloadListener2) {
    }

    @Override
    public void addCompletionListener(DownloadCompletionListener downloadCompletionListener) {
        this.notSupported();
    }

    @Override
    public void removeCompletionListener(DownloadCompletionListener downloadCompletionListener) {
        this.notSupported();
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener downloadTrackerListener) {
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener downloadTrackerListener, boolean bl) {
    }

    @Override
    public void removeTrackerListener(DownloadTrackerListener downloadTrackerListener) {
    }

    @Override
    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener downloadWillBeRemovedListener) {
        this.notSupported();
    }

    @Override
    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener downloadWillBeRemovedListener) {
        this.notSupported();
    }

    @Override
    public void addActivationListener(DownloadActivationListener downloadActivationListener) {
        this.notSupported();
    }

    @Override
    public void removeActivationListener(DownloadActivationListener downloadActivationListener) {
        this.notSupported();
    }

    @Override
    public void addPeerListener(DownloadPeerListener downloadPeerListener) {
        this.notSupported();
    }

    @Override
    public void removePeerListener(DownloadPeerListener downloadPeerListener) {
        this.notSupported();
    }

    @Override
    public int getSeedingRank() {
        return 0;
    }

    @Override
    public void setSeedingRank(int n) {
        this.notSupported();
    }

    @Override
    public void addPropertyListener(DownloadPropertyListener downloadPropertyListener) {
        this.notSupported();
    }

    @Override
    public void removePropertyListener(DownloadPropertyListener downloadPropertyListener) {
        this.notSupported();
    }

    @Override
    public byte[] getDownloadPeerId() {
        return null;
    }

    @Override
    public boolean isMessagingEnabled() {
        return true;
    }

    @Override
    public void setMessagingEnabled(boolean bl) {
    }

    @Override
    public void moveDataFiles(File file, String string) throws DownloadException {
        this.notSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object object) {
        Map map = this.user_data;
        synchronized (map) {
            return this.user_data.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object object, Object object2) {
        Map map = this.user_data;
        synchronized (map) {
            this.user_data.put(object, object2);
        }
    }

    @Override
    public void changeLocation(SaveLocationChange saveLocationChange) throws DownloadException {
        this.notSupported();
    }

    protected void notSupported() {
        Debug.out("Not Supported");
    }
}

