/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.browser.BrowserMessageDispatcher;
import com.aelitis.azureus.core.messenger.browser.listeners.BrowserMessageListener;
import com.aelitis.azureus.util.ConstantsVuze;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;

public abstract class ClientMessageContextImpl
implements ClientMessageContext {
    private String id;
    private BrowserMessageDispatcher dispatcher;

    public ClientMessageContextImpl(String string, BrowserMessageDispatcher browserMessageDispatcher) {
        this.id = string;
        this.dispatcher = browserMessageDispatcher;
    }

    @Override
    public void addMessageListener(BrowserMessageListener browserMessageListener) {
        if (this.dispatcher != null) {
            this.dispatcher.addListener(browserMessageListener);
        } else {
            this.debug("No dispatcher when trying to add MessageListener " + browserMessageListener.getId() + ";" + Debug.getCompressedStackTrace());
        }
    }

    @Override
    public void debug(String string) {
        AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("v3.CMsgr");
        aEDiagnosticsLogger.log("[" + this.id + "] " + string);
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println("[" + this.id + "] " + string);
        }
    }

    @Override
    public void debug(String string, Throwable throwable) {
        AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("v3.CMsgr");
        aEDiagnosticsLogger.log("[" + this.id + "] " + string);
        aEDiagnosticsLogger.log(throwable);
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.err.println("[" + this.id + "] " + string);
            throwable.printStackTrace();
        }
    }

    @Override
    public void removeMessageListener(String string) {
        if (this.dispatcher != null) {
            this.dispatcher.removeListener(string);
        } else {
            this.debug("No dispatcher when trying to remove MessageListener " + string + ";" + Debug.getCompressedStackTrace());
        }
    }

    @Override
    public void removeMessageListener(BrowserMessageListener browserMessageListener) {
        if (this.dispatcher != null) {
            this.dispatcher.removeListener(browserMessageListener);
        } else {
            this.debug("No dispatcher when trying to remove MessageListener " + browserMessageListener.getId() + ";" + Debug.getCompressedStackTrace());
        }
    }

    @Override
    public BrowserMessageDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public String getID() {
        return this.id;
    }

    @Override
    public void setMessageDispatcher(BrowserMessageDispatcher browserMessageDispatcher) {
        this.dispatcher = browserMessageDispatcher;
    }
}

