/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.utils;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;

public class MomentsAgoDateFormatter {
    private static final Integer ID_YEAR = new Integer(1);
    private static final Integer ID_MONTH = new Integer(2);
    private static final Integer ID_WEEK_OF_YEAR = new Integer(3);
    private static final Integer ID_DAY = new Integer(5);
    private static final Integer ID_HOUR_OF_DAY = new Integer(11);
    private static final Integer ID_MINUTE = new Integer(12);
    private static final Integer ID_SECOND = new Integer(13);
    private static final Long MS_IN_YEAR = new Long(31536000000L);
    private static final Long MS_IN_MONTH = new Long(2678400000L);
    private static final Long MS_IN_WEEK = new Long(604800000L);
    private static final Long MS_IN_DAY = new Long(86400000L);
    private static final Long MS_IN_HOUR = new Long(3600000L);
    private static final Long MS_IN_MINUTE = new Long(60000L);
    private static final Long MS_IN_SECOND = new Long(1000L);
    private static final String AGO = " ago";
    private static final String PLURAL = "s";
    private static final Map CONVERSION_MAP = new HashMap();
    private static final Map UNIT_MAP;

    public static String getMomentsAgoString(Date date, DateFormat dateFormat) {
        String string = MomentsAgoDateFormatter.getMomentsAgoString(date);
        dateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        if (string.length() > 0) {
            string = string.concat(" on ");
        }
        return string.concat(dateFormat.format(date));
    }

    public static String getMomentsAgoString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        String string = null;
        string = MomentsAgoDateFormatter.handleUnit(calendar, calendar2, ID_YEAR);
        if (string == null && (string = MomentsAgoDateFormatter.handleUnit(calendar, calendar2, ID_MONTH)) == null && (string = MomentsAgoDateFormatter.handleUnit(calendar, calendar2, ID_WEEK_OF_YEAR)) == null && (string = MomentsAgoDateFormatter.handleUnit(calendar, calendar2, ID_DAY)) == null && (string = MomentsAgoDateFormatter.handleUnit(calendar, calendar2, ID_HOUR_OF_DAY)) == null) {
            return "< 1 h";
        }
        return string;
    }

    private static String handleUnit(Calendar calendar, Calendar calendar2, Integer n) {
        long l;
        String string = null;
        long l2 = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
        if (l2 > (l = ((Long)CONVERSION_MAP.get(n)).longValue())) {
            long l3 = l2 / l;
            string = String.valueOf(l3).concat((String)UNIT_MAP.get(n));
        }
        return string;
    }

    static {
        CONVERSION_MAP.put(ID_YEAR, MS_IN_YEAR);
        CONVERSION_MAP.put(ID_MONTH, MS_IN_MONTH);
        CONVERSION_MAP.put(ID_WEEK_OF_YEAR, MS_IN_WEEK);
        CONVERSION_MAP.put(ID_DAY, MS_IN_DAY);
        CONVERSION_MAP.put(ID_HOUR_OF_DAY, MS_IN_HOUR);
        UNIT_MAP = new HashMap();
        UNIT_MAP.put(ID_YEAR, " yr");
        UNIT_MAP.put(ID_MONTH, " mo");
        UNIT_MAP.put(ID_WEEK_OF_YEAR, " wk");
        UNIT_MAP.put(ID_DAY, " day");
        UNIT_MAP.put(ID_HOUR_OF_DAY, " hr");
    }
}

