/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTest;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTestListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduler;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTesterResult;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTestScheduledTestImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTesterBTImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class NetworkAdminSpeedTestSchedulerImpl
implements NetworkAdminSpeedTestScheduler {
    private static NetworkAdminSpeedTestSchedulerImpl instance = null;
    private NetworkAdminSpeedTestScheduledTestImpl currentTest = null;

    public static synchronized NetworkAdminSpeedTestScheduler getInstance() {
        if (instance == null) {
            instance = new NetworkAdminSpeedTestSchedulerImpl();
        }
        return instance;
    }

    private NetworkAdminSpeedTestSchedulerImpl() {
    }

    @Override
    public void initialise() {
        NetworkAdminSpeedTesterBTImpl.startUp();
    }

    @Override
    public synchronized NetworkAdminSpeedTestScheduledTest getCurrentTest() {
        return this.currentTest;
    }

    @Override
    public synchronized NetworkAdminSpeedTestScheduledTest scheduleTest(int n) throws NetworkAdminException {
        if (this.currentTest != null) {
            throw new NetworkAdminException("Test already scheduled");
        }
        if (n != 1) {
            throw new NetworkAdminException("Unknown test type");
        }
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        this.currentTest = new NetworkAdminSpeedTestScheduledTestImpl(pluginInterface, new NetworkAdminSpeedTesterBTImpl(pluginInterface));
        this.currentTest.getTester().setMode(n);
        this.currentTest.addListener(new NetworkAdminSpeedTestScheduledTestListener(){

            @Override
            public void stage(NetworkAdminSpeedTestScheduledTest networkAdminSpeedTestScheduledTest, String string) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(NetworkAdminSpeedTestScheduledTest networkAdminSpeedTestScheduledTest) {
                NetworkAdminSpeedTestSchedulerImpl networkAdminSpeedTestSchedulerImpl = NetworkAdminSpeedTestSchedulerImpl.this;
                synchronized (networkAdminSpeedTestSchedulerImpl) {
                    NetworkAdminSpeedTestSchedulerImpl.this.currentTest = null;
                }
            }
        });
        return this.currentTest;
    }

    @Override
    public NetworkAdminSpeedTesterResult getLastResult(int n) {
        if (n == 1) {
            return NetworkAdminSpeedTesterBTImpl.getLastResult();
        }
        Debug.out("Unknown test type");
        return null;
    }
}

