/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.MultiPeerDownloader2;
import com.aelitis.azureus.core.networkmanager.impl.MultiPeerUploader;
import com.aelitis.azureus.core.networkmanager.impl.SinglePeerDownloader;
import com.aelitis.azureus.core.networkmanager.impl.SinglePeerUploader;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class EntityHandler {
    private final HashMap upgraded_connections = new HashMap();
    private final AEMonitor lock = new AEMonitor("EntityHandler");
    private final MultiPeerUploader global_uploader;
    private final MultiPeerDownloader2 global_downloader;
    private boolean global_registered = false;
    private final int handler_type;

    public EntityHandler(int n, RateHandler rateHandler) {
        this.handler_type = n;
        if (this.handler_type == 0) {
            this.global_uploader = new MultiPeerUploader(rateHandler);
            this.global_downloader = null;
        } else {
            this.global_downloader = new MultiPeerDownloader2(rateHandler);
            this.global_uploader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPeerConnection(NetworkConnectionBase networkConnectionBase) {
        try {
            this.lock.enter();
            if (!this.global_registered) {
                if (this.handler_type == 0) {
                    NetworkManager.getSingleton().addWriteEntity(this.global_uploader, -1);
                } else {
                    NetworkManager.getSingleton().addReadEntity(this.global_downloader, -1);
                }
                this.global_registered = true;
            }
        }
        finally {
            this.lock.exit();
        }
        if (this.handler_type == 0) {
            this.global_uploader.addPeerConnection(networkConnectionBase);
        } else {
            this.global_downloader.addPeerConnection(networkConnectionBase);
        }
    }

    public void cancelPeerConnection(NetworkConnectionBase networkConnectionBase) {
        SinglePeerDownloader singlePeerDownloader;
        if (this.handler_type == 0) {
            SinglePeerUploader singlePeerUploader;
            if (!this.global_uploader.removePeerConnection(networkConnectionBase) && (singlePeerUploader = (SinglePeerUploader)this.upgraded_connections.remove(networkConnectionBase)) != null) {
                NetworkManager.getSingleton().removeWriteEntity(singlePeerUploader);
            }
        } else if (!this.global_downloader.removePeerConnection(networkConnectionBase) && (singlePeerDownloader = (SinglePeerDownloader)this.upgraded_connections.remove(networkConnectionBase)) != null) {
            NetworkManager.getSingleton().removeReadEntity(singlePeerDownloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradePeerConnection(NetworkConnectionBase networkConnectionBase, RateHandler rateHandler, int n) {
        try {
            this.lock.enter();
            if (this.handler_type == 0) {
                SinglePeerUploader singlePeerUploader = new SinglePeerUploader(networkConnectionBase, rateHandler);
                if (!this.global_uploader.removePeerConnection(networkConnectionBase)) {
                    Debug.out("upgradePeerConnection:: upload entity not found/removed !");
                }
                NetworkManager.getSingleton().addWriteEntity(singlePeerUploader, n);
                this.upgraded_connections.put(networkConnectionBase, singlePeerUploader);
            } else {
                SinglePeerDownloader singlePeerDownloader = new SinglePeerDownloader(networkConnectionBase, rateHandler);
                if (!this.global_downloader.removePeerConnection(networkConnectionBase)) {
                    Debug.out("upgradePeerConnection:: download entity not found/removed !");
                }
                NetworkManager.getSingleton().addReadEntity(singlePeerDownloader, n);
                this.upgraded_connections.put(networkConnectionBase, singlePeerDownloader);
            }
        }
        finally {
            this.lock.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downgradePeerConnection(NetworkConnectionBase networkConnectionBase) {
        try {
            this.lock.enter();
            if (this.handler_type == 0) {
                SinglePeerUploader singlePeerUploader = (SinglePeerUploader)this.upgraded_connections.remove(networkConnectionBase);
                if (singlePeerUploader != null) {
                    NetworkManager.getSingleton().removeWriteEntity(singlePeerUploader);
                } else {
                    Debug.out("upload_entity == null");
                }
                this.global_uploader.addPeerConnection(networkConnectionBase);
            } else {
                SinglePeerDownloader singlePeerDownloader = (SinglePeerDownloader)this.upgraded_connections.remove(networkConnectionBase);
                if (singlePeerDownloader != null) {
                    NetworkManager.getSingleton().removeReadEntity(singlePeerDownloader);
                } else {
                    Debug.out("download_entity == null");
                }
                this.global_downloader.addPeerConnection(networkConnectionBase);
            }
        }
        finally {
            this.lock.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateHandler getRateHandler(NetworkConnectionBase networkConnectionBase) {
        try {
            this.lock.enter();
            if (this.handler_type == 0) {
                SinglePeerUploader singlePeerUploader = (SinglePeerUploader)this.upgraded_connections.get(networkConnectionBase);
                if (singlePeerUploader != null) {
                    RateHandler rateHandler = singlePeerUploader.getRateHandler();
                    return rateHandler;
                }
                RateHandler rateHandler = this.global_uploader.getRateHandler();
                return rateHandler;
            }
            SinglePeerDownloader singlePeerDownloader = (SinglePeerDownloader)this.upgraded_connections.get(networkConnectionBase);
            if (singlePeerDownloader != null) {
                RateHandler rateHandler = singlePeerDownloader.getRateHandler();
                return rateHandler;
            }
            RateHandler rateHandler = this.global_downloader.getRateHandler();
            return rateHandler;
        }
        finally {
            this.lock.exit();
        }
    }
}

