/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class IncomingConnectionManager {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static IncomingConnectionManager singleton = new IncomingConnectionManager();
    private volatile Map match_buffers_cow = new HashMap();
    private final AEMonitor match_buffers_mon = new AEMonitor("IncomingConnectionManager:match");
    private int max_match_buffer_size = 0;
    private int max_min_match_buffer_size = 0;
    private final ArrayList connections = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("IncomingConnectionManager:conns");

    public static IncomingConnectionManager getSingleton() {
        return singleton;
    }

    protected IncomingConnectionManager() {
        SimpleTimer.addPeriodicEvent("IncomingConnectionManager:timeouts", 5000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent timerEvent2) {
                IncomingConnectionManager.this.doTimeoutChecks();
            }
        });
    }

    public boolean isEmpty() {
        return this.match_buffers_cow.isEmpty();
    }

    public Object[] checkForMatch(TransportHelper transportHelper, int n, ByteBuffer byteBuffer, boolean bl) {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        byteBuffer.position(0);
        MatchListener matchListener = null;
        Object object = null;
        for (Map.Entry entry : this.match_buffers_cow.entrySet()) {
            NetworkManager.ByteMatcher byteMatcher = (NetworkManager.ByteMatcher)entry.getKey();
            MatchListener matchListener2 = (MatchListener)entry.getValue();
            int n4 = byteMatcher.getSpecificPort();
            if (n4 != -1 && n4 != n) continue;
            if (bl) {
                if (n2 < byteMatcher.minSize() || (object = byteMatcher.minMatches(transportHelper, byteBuffer, n)) == null) continue;
                matchListener = matchListener2;
                break;
            }
            if (n2 < byteMatcher.matchThisSizeOrBigger() || (object = byteMatcher.matches(transportHelper, byteBuffer, n)) == null) continue;
            matchListener = matchListener2;
            break;
        }
        byteBuffer.position(n2);
        byteBuffer.limit(n3);
        if (matchListener == null) {
            return null;
        }
        return new Object[]{matchListener, object};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMatchBytes(NetworkManager.ByteMatcher byteMatcher, MatchListener matchListener) {
        try {
            this.match_buffers_mon.enter();
            if (byteMatcher.maxSize() > this.max_match_buffer_size) {
                this.max_match_buffer_size = byteMatcher.maxSize();
            }
            if (byteMatcher.minSize() > this.max_min_match_buffer_size) {
                this.max_min_match_buffer_size = byteMatcher.minSize();
            }
            HashMap<NetworkManager.ByteMatcher, MatchListener> hashMap = new HashMap<NetworkManager.ByteMatcher, MatchListener>(this.match_buffers_cow);
            hashMap.put(byteMatcher, matchListener);
            this.match_buffers_cow = hashMap;
            this.addSharedSecrets(byteMatcher.getSharedSecrets());
        }
        finally {
            this.match_buffers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterMatchBytes(NetworkManager.ByteMatcher byteMatcher) {
        try {
            this.match_buffers_mon.enter();
            HashMap hashMap = new HashMap(this.match_buffers_cow);
            hashMap.remove(byteMatcher);
            if (byteMatcher.maxSize() == this.max_match_buffer_size) {
                this.max_match_buffer_size = 0;
                for (NetworkManager.ByteMatcher byteMatcher2 : hashMap.keySet()) {
                    if (byteMatcher2.maxSize() <= this.max_match_buffer_size) continue;
                    this.max_match_buffer_size = byteMatcher2.maxSize();
                }
            }
            this.match_buffers_cow = hashMap;
            this.removeSharedSecrets(byteMatcher.getSharedSecrets());
        }
        finally {
            this.match_buffers_mon.exit();
        }
    }

    public void addSharedSecrets(byte[][] byArray) {
        if (byArray != null) {
            ProtocolDecoder.addSecrets(byArray);
        }
    }

    public void removeSharedSecrets(byte[][] byArray) {
        if (byArray != null) {
            ProtocolDecoder.removeSecrets(byArray);
        }
    }

    public int getMaxMatchBufferSize() {
        return this.max_match_buffer_size;
    }

    public int getMaxMinMatchBufferSize() {
        return this.max_min_match_buffer_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(int n, TransportHelperFilter transportHelperFilter, Transport transport) {
        TransportHelper transportHelper = transportHelperFilter.getHelper();
        if (this.isEmpty()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Incoming connection from [" + transportHelper.getAddress() + "] dropped because zero routing handlers registered"));
            }
            transportHelper.close("No routing handler");
            return;
        }
        IncomingConnection incomingConnection = new IncomingConnection(transportHelperFilter, this.getMaxMatchBufferSize());
        SelectorListener selectorListener = new SelectorListener(n, transport);
        try {
            this.connections_mon.enter();
            this.connections.add(incomingConnection);
            transportHelper.registerForReadSelects(selectorListener, incomingConnection);
        }
        finally {
            this.connections_mon.exit();
        }
        selectorListener.selectSuccess(transportHelper, incomingConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(IncomingConnection incomingConnection, boolean bl) {
        try {
            this.connections_mon.enter();
            incomingConnection.filter.getHelper().cancelReadSelects();
            this.connections.remove(incomingConnection);
        }
        finally {
            this.connections_mon.exit();
        }
        if (bl) {
            incomingConnection.filter.getHelper().close("Tidy close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTimeoutChecks() {
        try {
            IncomingConnection incomingConnection;
            int n;
            this.connections_mon.enter();
            ArrayList<IncomingConnection> arrayList = null;
            long l = SystemTime.getCurrentTime();
            for (n = 0; n < this.connections.size(); ++n) {
                incomingConnection = (IncomingConnection)this.connections.get(n);
                TransportHelper transportHelper = incomingConnection.filter.getHelper();
                if (incomingConnection.last_read_time > 0L) {
                    if (l < incomingConnection.last_read_time) {
                        incomingConnection.last_read_time = l;
                        continue;
                    }
                    if (l - incomingConnection.last_read_time <= (long)transportHelper.getReadTimeout()) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Incoming connection [" + transportHelper.getAddress() + "] forcibly timed out due to socket read inactivity [" + incomingConnection.buffer.position() + " bytes read: " + new String(incomingConnection.buffer.array()) + "]"));
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<IncomingConnection>();
                    }
                    arrayList.add(incomingConnection);
                    continue;
                }
                if (l < incomingConnection.initial_connect_time) {
                    incomingConnection.initial_connect_time = l;
                    continue;
                }
                if (l - incomingConnection.initial_connect_time <= (long)transportHelper.getConnectTimeout()) continue;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Incoming connection [" + transportHelper.getAddress() + "] forcibly timed out after " + "60sec due to socket inactivity"));
                }
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(incomingConnection);
            }
            if (arrayList != null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    incomingConnection = (IncomingConnection)arrayList.get(n);
                    this.removeConnection(incomingConnection, true);
                }
            }
        }
        finally {
            this.connections_mon.exit();
        }
    }

    public static interface MatchListener {
        public boolean autoCryptoFallback();

        public void connectionMatched(Transport var1, Object var2);
    }

    protected class SelectorListener
    implements TransportHelper.selectListener {
        private int local_port;
        private Transport transport;

        protected SelectorListener(int n, Transport transport) {
            this.local_port = n;
            this.transport = transport;
        }

        @Override
        public boolean selectSuccess(TransportHelper transportHelper, Object object) {
            IncomingConnection incomingConnection = (IncomingConnection)object;
            try {
                long l = incomingConnection.filter.read(new ByteBuffer[]{incomingConnection.buffer}, 0, 1);
                if (l < 0L) {
                    throw new IOException("end of stream on socket read");
                }
                if (l == 0L) {
                    return false;
                }
                incomingConnection.last_read_time = SystemTime.getCurrentTime();
                Object[] objectArray = IncomingConnectionManager.this.checkForMatch(transportHelper, this.local_port, incomingConnection.buffer, false);
                if (objectArray == null) {
                    if (incomingConnection.buffer.position() >= IncomingConnectionManager.this.getMaxMatchBufferSize()) {
                        incomingConnection.buffer.flip();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "Incoming stream from [" + transportHelper.getAddress() + "] does not match " + "any known byte pattern: " + ByteFormatter.nicePrint(incomingConnection.buffer.array(), 128)));
                        }
                        IncomingConnectionManager.this.removeConnection(incomingConnection, true);
                    }
                } else {
                    incomingConnection.buffer.flip();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Incoming stream from [" + transportHelper.getAddress() + "] recognized as " + "known byte pattern: " + ByteFormatter.nicePrint(incomingConnection.buffer.array(), 64)));
                    }
                    IncomingConnectionManager.this.removeConnection(incomingConnection, false);
                    this.transport.setAlreadyRead(incomingConnection.buffer);
                    this.transport.connectedInbound();
                    MatchListener matchListener = (MatchListener)objectArray[0];
                    matchListener.connectionMatched(this.transport, objectArray[1]);
                }
                return true;
            }
            catch (Throwable throwable) {
                try {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Incoming connection [" + transportHelper.getAddress() + "] socket read exception: " + throwable.getMessage()));
                    }
                }
                catch (Throwable throwable2) {
                    Debug.out("Caught exception on incoming exception log:");
                    throwable2.printStackTrace();
                    System.out.println("CAUSED BY:");
                    throwable.printStackTrace();
                }
                IncomingConnectionManager.this.removeConnection(incomingConnection, true);
                return false;
            }
        }

        @Override
        public void selectFailure(TransportHelper transportHelper, Object object, Throwable throwable) {
            IncomingConnection incomingConnection = (IncomingConnection)object;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Incoming connection [" + transportHelper.getAddress() + "] socket select op failure: " + throwable.getMessage()));
            }
            IncomingConnectionManager.this.removeConnection(incomingConnection, true);
        }
    }

    protected static class IncomingConnection {
        protected final TransportHelperFilter filter;
        protected final ByteBuffer buffer;
        protected long initial_connect_time;
        protected long last_read_time = -1L;

        protected IncomingConnection(TransportHelperFilter transportHelperFilter, int n) {
            this.filter = transportHelperFilter;
            this.buffer = ByteBuffer.allocate(n);
            this.initial_connect_time = SystemTime.getCurrentTime();
        }
    }
}

