/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;

public class WriteController
implements AzureusCoreStatsProvider {
    private static int IDLE_SLEEP_TIME = 50;
    private static boolean AGGRESIVE_WRITE = false;
    private static int BOOSTER_GIFT = 5120;
    private volatile ArrayList<RateControlledEntity> normal_priority_entities = new ArrayList();
    private volatile ArrayList<RateControlledEntity> boosted_priority_entities = new ArrayList();
    private volatile ArrayList<RateControlledEntity> high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("WriteController:EM");
    private int next_normal_position = 0;
    private int next_boost_position = 0;
    private int next_high_position = 0;
    private long booster_process_time;
    private int booster_normal_written;
    private int booster_stat_index;
    private int[] booster_normal_writes = new int[5];
    private int[] booster_gifts = new int[5];
    private int aggressive_np_normal_priority_count;
    private int aggressive_np_high_priority_count;
    private long process_loop_time;
    private long wait_count;
    private long progress_count;
    private long non_progress_count;
    private EventWaiter write_waiter = new EventWaiter();
    private NetworkManager net_man;
    private int entity_count = 0;

    public WriteController() {
        AEThread aEThread = new AEThread("WriteController:WriteProcessor"){

            @Override
            public void runSupport() {
                WriteController.this.writeProcessorLoop();
            }
        };
        aEThread.setDaemon(true);
        aEThread.setPriority(9);
        aEThread.start();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("net.write.control.wait.count");
        hashSet.add("net.write.control.np.count");
        hashSet.add("net.write.control.p.count");
        hashSet.add("net.write.control.entity.count");
        hashSet.add("net.write.control.con.count");
        hashSet.add("net.write.control.ready.con.count");
        hashSet.add("net.write.control.ready.byte.count");
        AzureusCoreStats.registerProvider(hashSet, this);
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generate(IndentWriter indentWriter) {
                indentWriter.println("Write Controller");
                try {
                    RateControlledEntity rateControlledEntity;
                    int n;
                    indentWriter.indent();
                    ArrayList arrayList = WriteController.this.normal_priority_entities;
                    indentWriter.println("normal - " + arrayList.size());
                    for (n = 0; n < arrayList.size(); ++n) {
                        rateControlledEntity = (RateControlledEntity)arrayList.get(n);
                        indentWriter.println(rateControlledEntity.getString());
                    }
                    arrayList = WriteController.this.boosted_priority_entities;
                    indentWriter.println("boosted - " + arrayList.size());
                    for (n = 0; n < arrayList.size(); ++n) {
                        rateControlledEntity = (RateControlledEntity)arrayList.get(n);
                        indentWriter.println(rateControlledEntity.getString());
                    }
                    arrayList = WriteController.this.high_priority_entities;
                    indentWriter.println("priority - " + arrayList.size());
                    for (n = 0; n < arrayList.size(); ++n) {
                        rateControlledEntity = (RateControlledEntity)arrayList.get(n);
                        indentWriter.println(rateControlledEntity.getString());
                    }
                }
                finally {
                    indentWriter.exdent();
                }
            }
        });
    }

    public void updateStats(Set set, Map map) {
        if (set.contains("net.write.control.wait.count")) {
            map.put("net.write.control.wait.count", new Long(this.wait_count));
        }
        if (set.contains("net.write.control.np.count")) {
            map.put("net.write.control.np.count", new Long(this.non_progress_count));
        }
        if (set.contains("net.write.control.p.count")) {
            map.put("net.write.control.p.count", new Long(this.progress_count));
        }
        if (set.contains("net.write.control.entity.count")) {
            map.put("net.write.control.entity.count", new Long(this.high_priority_entities.size() + this.boosted_priority_entities.size() + this.normal_priority_entities.size()));
        }
        if (set.contains("net.write.control.con.count") || set.contains("net.write.control.ready.con.count") || set.contains("net.write.control.ready.byte.count")) {
            long l = 0L;
            int n = 0;
            int n2 = 0;
            ArrayList[] arrayListArray = new ArrayList[]{this.normal_priority_entities, this.boosted_priority_entities, this.high_priority_entities};
            for (int i = 0; i < arrayListArray.length; ++i) {
                ArrayList arrayList = arrayListArray[i];
                for (int j = 0; j < arrayList.size(); ++j) {
                    RateControlledEntity rateControlledEntity = (RateControlledEntity)arrayList.get(j);
                    n2 += rateControlledEntity.getConnectionCount();
                    n += rateControlledEntity.getReadyConnectionCount(this.write_waiter);
                    l += rateControlledEntity.getBytesReadyToWrite();
                }
            }
            map.put("net.write.control.con.count", new Long(n2));
            map.put("net.write.control.ready.con.count", new Long(n));
            map.put("net.write.control.ready.byte.count", new Long(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProcessorLoop() {
        boolean bl = true;
        long l = SystemTime.getMonotonousTime();
        this.net_man = NetworkManager.getSingleton();
        while (true) {
            this.process_loop_time = SystemTime.getMonotonousTime();
            try {
                if (bl) {
                    bl = false;
                    if (!this.doHighPriorityWrite() && !this.doNormalPriorityWrite() && this.write_waiter.waitForEvent(IDLE_SLEEP_TIME)) {
                        ++this.wait_count;
                    }
                } else {
                    bl = true;
                    if (!this.doNormalPriorityWrite() && !this.doHighPriorityWrite() && this.write_waiter.waitForEvent(IDLE_SLEEP_TIME)) {
                        ++this.wait_count;
                    }
                }
            }
            catch (Throwable throwable) {
                Debug.out("writeProcessorLoop() EXCEPTION: ", throwable);
            }
            if (this.process_loop_time - l <= 5000L) continue;
            l = this.process_loop_time;
            boolean bl2 = false;
            ArrayList<RateControlledEntity> arrayList = this.normal_priority_entities;
            for (RateControlledEntity rateControlledEntity : arrayList) {
                if (!rateControlledEntity.getPriorityBoost()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                arrayList = this.boosted_priority_entities;
                for (RateControlledEntity rateControlledEntity : arrayList) {
                    if (rateControlledEntity.getPriorityBoost()) continue;
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) continue;
            try {
                this.entities_mon.enter();
                ArrayList arrayList2 = new ArrayList();
                ArrayList<RateControlledEntity> arrayList3 = new ArrayList<RateControlledEntity>();
                for (RateControlledEntity rateControlledEntity : this.normal_priority_entities) {
                    if (rateControlledEntity.getPriorityBoost()) {
                        arrayList3.add(rateControlledEntity);
                        continue;
                    }
                    arrayList2.add(rateControlledEntity);
                }
                for (RateControlledEntity rateControlledEntity : this.boosted_priority_entities) {
                    if (rateControlledEntity.getPriorityBoost()) {
                        arrayList3.add(rateControlledEntity);
                        continue;
                    }
                    arrayList2.add(rateControlledEntity);
                }
                this.normal_priority_entities = arrayList2;
                this.boosted_priority_entities = arrayList3;
                continue;
            }
            finally {
                this.entities_mon.exit();
                continue;
            }
            break;
        }
    }

    private boolean doNormalPriorityWrite() {
        int n = this.processNextReadyNormalPriorityEntity();
        if (n > 0) {
            ++this.progress_count;
            return true;
        }
        if (n == 0) {
            ++this.non_progress_count;
            if (AGGRESIVE_WRITE) {
                ++this.aggressive_np_normal_priority_count;
                if (this.aggressive_np_normal_priority_count < this.normal_priority_entities.size() + this.boosted_priority_entities.size()) {
                    return true;
                }
                this.aggressive_np_normal_priority_count = 0;
            }
        }
        return false;
    }

    private boolean doHighPriorityWrite() {
        RateControlledEntity rateControlledEntity = this.getNextReadyHighPriorityEntity();
        if (rateControlledEntity != null) {
            if (rateControlledEntity.doProcessing(this.write_waiter, 0) > 0) {
                ++this.progress_count;
                return true;
            }
            ++this.non_progress_count;
            if (AGGRESIVE_WRITE) {
                ++this.aggressive_np_high_priority_count;
                if (this.aggressive_np_high_priority_count < this.high_priority_entities.size()) {
                    return true;
                }
                this.aggressive_np_high_priority_count = 0;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processNextReadyNormalPriorityEntity() {
        ArrayList<RateControlledEntity> arrayList = this.boosted_priority_entities;
        int n = arrayList.size();
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            if (n > 0) {
                if (this.process_loop_time - this.booster_process_time >= 1000L) {
                    this.booster_process_time = this.process_loop_time;
                    this.booster_gifts[this.booster_stat_index] = BOOSTER_GIFT;
                    this.booster_normal_writes[this.booster_stat_index] = this.booster_normal_written;
                    ++this.booster_stat_index;
                    if (this.booster_stat_index >= this.booster_gifts.length) {
                        this.booster_stat_index = 0;
                    }
                    this.booster_normal_written = 0;
                }
                int n6 = 0;
                n5 = 0;
                for (n4 = 0; n4 < this.booster_gifts.length; ++n4) {
                    n6 += this.booster_gifts[n4];
                    n5 += this.booster_normal_writes[n4];
                }
                n4 = n6 - n5;
                if (n4 > 0) {
                    ArrayList<RateControlledEntity> arrayList2 = this.normal_priority_entities;
                    n3 = arrayList2.size();
                    int n7 = this.next_normal_position;
                    ArrayList<RateControlledEntity> arrayList3 = new ArrayList<RateControlledEntity>();
                    for (n2 = 0; n2 < n3; ++n2) {
                        n7 = n7 >= n3 ? 0 : n7;
                        RateControlledEntity rateControlledEntity = arrayList2.get(n7);
                        ++n7;
                        if (!rateControlledEntity.canProcess(this.write_waiter)) continue;
                        this.next_normal_position = n7;
                        arrayList3.add(rateControlledEntity);
                    }
                    int n8 = arrayList3.size();
                    if (n8 > 0) {
                        int n9;
                        int n10 = 0;
                        for (RateControlledEntity rateControlledEntity : arrayList3) {
                            int n11;
                            n9 = n4 / n8;
                            if (n9 <= 0) {
                                n9 = 1;
                            }
                            if (rateControlledEntity.canProcess(this.write_waiter) && (n11 = rateControlledEntity.doProcessing(this.write_waiter, n9)) > 0) {
                                this.booster_normal_written += n11;
                                n10 += n11;
                            }
                            --n8;
                        }
                        for (int i = this.booster_stat_index; n10 > 0 && i < this.booster_stat_index + this.booster_gifts.length; ++i) {
                            int n12 = this.booster_gifts[i % this.booster_gifts.length];
                            if (n12 <= 0) continue;
                            n9 = Math.min(n12, n10);
                            n10 -= n9;
                            this.booster_gifts[i % this.booster_gifts.length] = n12 -= n9;
                        }
                    }
                }
                for (int i = 0; i < n; ++i) {
                    this.next_boost_position = this.next_boost_position >= n ? 0 : this.next_boost_position;
                    RateControlledEntity rateControlledEntity = arrayList.get(this.next_boost_position);
                    ++this.next_boost_position;
                    if (!rateControlledEntity.canProcess(this.write_waiter)) continue;
                    n2 = rateControlledEntity.doProcessing(this.write_waiter, 0);
                    return n2;
                }
                this.net_man.getUploadProcessor().setRateLimiterFreezeState(true);
            } else {
                this.booster_normal_written = 0;
            }
            ArrayList<RateControlledEntity> arrayList4 = this.normal_priority_entities;
            n5 = arrayList4.size();
            for (n4 = 0; n4 < n5; ++n4) {
                this.next_normal_position = this.next_normal_position >= n5 ? 0 : this.next_normal_position;
                RateControlledEntity rateControlledEntity = arrayList4.get(this.next_normal_position);
                ++this.next_normal_position;
                if (!rateControlledEntity.canProcess(this.write_waiter)) continue;
                n3 = rateControlledEntity.doProcessing(this.write_waiter, 0);
                if (n3 > 0) {
                    this.booster_normal_written += n3;
                }
                n2 = n3;
                return n2;
            }
            int n13 = -1;
            return n13;
        }
        finally {
            if (n > 0) {
                this.net_man.getUploadProcessor().setRateLimiterFreezeState(false);
            }
        }
    }

    private RateControlledEntity getNextReadyHighPriorityEntity() {
        ArrayList<RateControlledEntity> arrayList = this.high_priority_entities;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.next_high_position = this.next_high_position >= n ? 0 : this.next_high_position;
            RateControlledEntity rateControlledEntity = arrayList.get(this.next_high_position);
            ++this.next_high_position;
            if (!rateControlledEntity.canProcess(this.write_waiter)) continue;
            return rateControlledEntity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriteEntity(RateControlledEntity rateControlledEntity) {
        try {
            this.entities_mon.enter();
            if (rateControlledEntity.getPriority() == 1) {
                ArrayList<RateControlledEntity> arrayList = new ArrayList<RateControlledEntity>(this.high_priority_entities.size() + 1);
                arrayList.addAll(this.high_priority_entities);
                arrayList.add(rateControlledEntity);
                this.high_priority_entities = arrayList;
            } else if (rateControlledEntity.getPriorityBoost()) {
                ArrayList<RateControlledEntity> arrayList = new ArrayList<RateControlledEntity>(this.boosted_priority_entities.size() + 1);
                arrayList.addAll(this.boosted_priority_entities);
                arrayList.add(rateControlledEntity);
                this.boosted_priority_entities = arrayList;
            } else {
                ArrayList<RateControlledEntity> arrayList = new ArrayList<RateControlledEntity>(this.normal_priority_entities.size() + 1);
                arrayList.addAll(this.normal_priority_entities);
                arrayList.add(rateControlledEntity);
                this.normal_priority_entities = arrayList;
            }
            this.entity_count = this.normal_priority_entities.size() + this.boosted_priority_entities.size() + this.high_priority_entities.size();
        }
        finally {
            this.entities_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriteEntity(RateControlledEntity rateControlledEntity) {
        try {
            this.entities_mon.enter();
            if (rateControlledEntity.getPriority() == 1) {
                ArrayList<RateControlledEntity> arrayList = new ArrayList<RateControlledEntity>(this.high_priority_entities);
                arrayList.remove(rateControlledEntity);
                this.high_priority_entities = arrayList;
            } else if (this.boosted_priority_entities.contains(rateControlledEntity)) {
                ArrayList<RateControlledEntity> arrayList = new ArrayList<RateControlledEntity>(this.boosted_priority_entities);
                arrayList.remove(rateControlledEntity);
                this.boosted_priority_entities = arrayList;
            } else {
                ArrayList<RateControlledEntity> arrayList = new ArrayList<RateControlledEntity>(this.normal_priority_entities);
                arrayList.remove(rateControlledEntity);
                this.normal_priority_entities = arrayList;
            }
            this.entity_count = this.normal_priority_entities.size() + this.boosted_priority_entities.size() + this.high_priority_entities.size();
        }
        finally {
            this.entities_mon.exit();
        }
    }

    public int getEntityCount() {
        return this.entity_count;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.control.write.idle.time", "network.control.write.aggressive", "Bias Upload Slack KBs"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                IDLE_SLEEP_TIME = COConfigurationManager.getIntParameter("network.control.write.idle.time");
                AGGRESIVE_WRITE = COConfigurationManager.getBooleanParameter("network.control.write.aggressive");
                BOOSTER_GIFT = COConfigurationManager.getIntParameter("Bias Upload Slack KBs") * 1024;
            }
        });
    }
}

