/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageDecoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageEncoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnectionFile;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnectionWebSeed;
import com.aelitis.azureus.core.networkmanager.impl.tcp.IncomingSocketChannelManager;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRoutingListener;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.BEncoder;

public class HTTPNetworkManager {
    private static final String NL = "\r\n";
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final HTTPNetworkManager instance = new HTTPNetworkManager();
    private final IncomingSocketChannelManager http_incoming_manager;
    private long total_requests;
    private long total_webseed_requests;
    private long total_getright_requests;
    private long total_invalid_requests;
    private long total_ok_requests;
    private CopyOnWriteList<URLHandler> url_handlers = new CopyOnWriteList();

    public static HTTPNetworkManager getSingleton() {
        return instance;
    }

    private HTTPNetworkManager() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("net.http.inbound.request.count");
        hashSet.add("net.http.inbound.request.ok.count");
        hashSet.add("net.http.inbound.request.invalid.count");
        hashSet.add("net.http.inbound.request.webseed.count");
        hashSet.add("net.http.inbound.request.getright.count");
        AzureusCoreStats.registerProvider(hashSet, new AzureusCoreStatsProvider(){

            public void updateStats(Set set, Map map) {
                if (set.contains("net.http.inbound.request.count")) {
                    map.put("net.http.inbound.request.count", new Long(HTTPNetworkManager.this.total_requests));
                }
                if (set.contains("net.http.inbound.request.ok.count")) {
                    map.put("net.http.inbound.request.ok.count", new Long(HTTPNetworkManager.this.total_ok_requests));
                }
                if (set.contains("net.http.inbound.request.invalid.count")) {
                    map.put("net.http.inbound.request.invalid.count", new Long(HTTPNetworkManager.this.total_invalid_requests));
                }
                if (set.contains("net.http.inbound.request.webseed.count")) {
                    map.put("net.http.inbound.request.webseed.count", new Long(HTTPNetworkManager.this.total_webseed_requests));
                }
                if (set.contains("net.http.inbound.request.getright.count")) {
                    map.put("net.http.inbound.request.getright.count", new Long(HTTPNetworkManager.this.total_getright_requests));
                }
            }
        });
        this.http_incoming_manager = new IncomingSocketChannelManager("HTTP.Data.Listen.Port", "HTTP.Data.Listen.Port.Enable");
        NetworkManager.ByteMatcher byteMatcher = new NetworkManager.ByteMatcher(){

            @Override
            public int matchThisSizeOrBigger() {
                return 16;
            }

            @Override
            public int maxSize() {
                return 256;
            }

            @Override
            public int minSize() {
                return 3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object matches(TransportHelper transportHelper, ByteBuffer byteBuffer, int n) {
                HTTPNetworkManager.this.total_requests++;
                InetSocketAddress inetSocketAddress = transportHelper.getAddress();
                int n2 = byteBuffer.limit();
                int n3 = byteBuffer.position();
                boolean bl = false;
                try {
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n4;
                    int n5;
                    String string;
                    block39: {
                        byte[] byArray = new byte[3];
                        byteBuffer.get(byArray);
                        if (byArray[0] != 71 || byArray[1] != 69 || byArray[2] != 84) {
                            Object var9_9 = null;
                            return var9_9;
                        }
                        byte[] byArray2 = new byte[byteBuffer.remaining()];
                        byteBuffer.get(byArray2);
                        try {
                            string = new String(byArray2, "ISO-8859-1");
                            int n6 = string.indexOf(32);
                            if (n6 == -1) {
                                Object var12_15 = null;
                                return var12_15;
                            }
                            if ((string = string.substring(n6 + 1).trim()).indexOf("/index.html") == -1) break block39;
                            bl = true;
                        }
                        catch (Throwable throwable) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "HTTP decode from " + inetSocketAddress + " failed, " + throwable.getMessage()));
                            }
                            Object var11_14 = null;
                            return var11_14;
                        }
                        Object[] objectArray3 = new Object[]{transportHelper, HTTPNetworkManager.this.getIndexPage()};
                        return objectArray3;
                    }
                    if (string.indexOf("/ping.html") != -1) {
                        bl = true;
                        Object[] objectArray4 = new Object[]{transportHelper, HTTPNetworkManager.this.getPingPage(string)};
                        return objectArray4;
                    }
                    if (string.indexOf("/test503.html") != -1) {
                        bl = true;
                        Object[] objectArray5 = new Object[]{transportHelper, HTTPNetworkManager.this.getTest503()};
                        return objectArray5;
                    }
                    String string2 = null;
                    int n7 = string.indexOf("?info_hash=");
                    if (n7 != -1) {
                        n5 = n7 + 11;
                        n4 = string.indexOf(38, n7);
                        if (n4 == -1) {
                            Object var16_27 = null;
                            return var16_27;
                        }
                        string2 = string.substring(n5, n4);
                    } else {
                        n7 = string.indexOf("/files/");
                        if (n7 != -1) {
                            n5 = n7 + 7;
                            n4 = string.indexOf(47, n5);
                            if (n4 == -1) {
                                Object var16_28 = null;
                                return var16_28;
                            }
                            string2 = string.substring(n5, n4);
                        }
                    }
                    if (string2 != null) {
                        byte[] byArray = URLDecoder.decode(string2, "ISO-8859-1").getBytes("ISO-8859-1");
                        PeerManagerRegistration peerManagerRegistration = PeerManager.getSingleton().manualMatchHash(inetSocketAddress, byArray);
                        if (peerManagerRegistration != null) {
                            int n8 = string.indexOf(32);
                            String string3 = n8 == -1 ? string : string.substring(0, n8);
                            bl = true;
                            Object[] objectArray6 = new Object[]{string3, peerManagerRegistration};
                            return objectArray6;
                        }
                    } else {
                        n5 = string.indexOf("/links/");
                        if (n5 != -1) {
                            n4 = string.indexOf(32, n5);
                            if (n4 == -1) {
                                Object var16_30 = null;
                                return var16_30;
                            }
                            objectArray2 = string.substring(0, n4).substring(n5 + 7);
                            objectArray2 = URLDecoder.decode((String)objectArray2, "UTF-8");
                            Object object = PeerManager.getSingleton().manualMatchLink(inetSocketAddress, (String)objectArray2);
                            if (object != null && (objectArray = object.getLink((String)objectArray2)) != null) {
                                StringBuffer stringBuffer = new StringBuffer(512);
                                stringBuffer.append("/files/");
                                stringBuffer.append(URLEncoder.encode(new String(objectArray.getTorrent().getHash(), "ISO-8859-1"), "ISO-8859-1"));
                                byte[][] byArray = objectArray.getPathComponents();
                                for (int i = 0; i < byArray.length; ++i) {
                                    stringBuffer.append("/");
                                    stringBuffer.append(URLEncoder.encode(new String(byArray[i], "ISO-8859-1"), "ISO-8859-1"));
                                }
                                bl = true;
                                Object[] objectArray7 = new Object[]{stringBuffer.toString(), object};
                                return objectArray7;
                            }
                        }
                    }
                    String string4 = string;
                    int n9 = string4.indexOf(32);
                    if (n9 != -1) {
                        string4 = string4.substring(0, n9);
                    }
                    for (Object object : HTTPNetworkManager.this.url_handlers) {
                        if (!object.matches(string4)) continue;
                        bl = true;
                        objectArray = new Object[]{object, transportHelper, "GET " + string};
                        return objectArray;
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "HTTP decode from " + inetSocketAddress + " failed: no match for " + string));
                    }
                    objectArray2 = new Object[]{transportHelper, HTTPNetworkManager.this.getNotFound()};
                    return objectArray2;
                }
                finally {
                    if (bl) {
                        HTTPNetworkManager.this.total_ok_requests++;
                    } else {
                        HTTPNetworkManager.this.total_invalid_requests++;
                    }
                    byteBuffer.limit(n2);
                    byteBuffer.position(n3);
                }
            }

            @Override
            public Object minMatches(TransportHelper transportHelper, ByteBuffer byteBuffer, int n) {
                byte[] byArray = new byte[3];
                byteBuffer.get(byArray);
                if (byArray[0] != 71 || byArray[1] != 69 || byArray[2] != 84) {
                    return null;
                }
                return "";
            }

            @Override
            public byte[][] getSharedSecrets() {
                return null;
            }

            @Override
            public int getSpecificPort() {
                return HTTPNetworkManager.this.http_incoming_manager.getTCPListeningPortNumber();
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting(byteMatcher, new NetworkManager.RoutingListener(){

            @Override
            public void connectionRouted(final NetworkConnection networkConnection, Object object) {
                Object[] objectArray = (Object[])object;
                Object object2 = objectArray[0];
                if (object2 instanceof TransportHelper) {
                    HTTPNetworkManager.this.writeReply(networkConnection, (TransportHelper)objectArray[0], (String)objectArray[1]);
                    return;
                }
                if (object2 instanceof URLHandler) {
                    ((URLHandler)object2).handle((TransportHelper)objectArray[1], (String)objectArray[2]);
                    return;
                }
                final String string = (String)object2;
                PeerManagerRegistration peerManagerRegistration = (PeerManagerRegistration)objectArray[1];
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " routed successfully on '" + string + "'"));
                }
                PeerManager.getSingleton().manualRoute(peerManagerRegistration, networkConnection, new PeerManagerRoutingListener(){

                    @Override
                    public boolean routed(PEPeerTransport pEPeerTransport) {
                        if (string.indexOf("/webseed") != -1) {
                            HTTPNetworkManager.this.total_webseed_requests++;
                            new HTTPNetworkConnectionWebSeed(HTTPNetworkManager.this, networkConnection, pEPeerTransport);
                            return true;
                        }
                        if (string.indexOf("/files/") != -1) {
                            HTTPNetworkManager.this.total_getright_requests++;
                            new HTTPNetworkConnectionFile(HTTPNetworkManager.this, networkConnection, pEPeerTransport);
                            return true;
                        }
                        return false;
                    }
                });
            }

            @Override
            public boolean autoCryptoFallback() {
                return false;
            }
        }, new MessageStreamFactory(){

            @Override
            public MessageStreamEncoder createEncoder() {
                return new HTTPMessageEncoder();
            }

            @Override
            public MessageStreamDecoder createDecoder() {
                return new HTTPMessageDecoder();
            }
        });
    }

    protected void reRoute(HTTPNetworkConnection hTTPNetworkConnection, byte[] byArray, byte[] byArray2, final String string) {
        NetworkConnection networkConnection = hTTPNetworkConnection.getConnection();
        PeerManagerRegistration peerManagerRegistration = PeerManager.getSingleton().manualMatchHash(networkConnection.getEndpoint().getNotionalAddress(), byArray2);
        if (peerManagerRegistration == null) {
            hTTPNetworkConnection.close("Re-routing failed - registration not found");
            return;
        }
        Transport transport = networkConnection.detachTransport();
        hTTPNetworkConnection.close("Switching torrents");
        final NetworkConnection networkConnection2 = NetworkManager.getSingleton().bindTransport(transport, new HTTPMessageEncoder(), new HTTPMessageDecoder(string));
        PeerManager.getSingleton().manualRoute(peerManagerRegistration, networkConnection2, new PeerManagerRoutingListener(){

            @Override
            public boolean routed(PEPeerTransport pEPeerTransport) {
                HTTPNetworkConnection hTTPNetworkConnection;
                if (string.indexOf("/webseed") != -1) {
                    hTTPNetworkConnection = new HTTPNetworkConnectionWebSeed(HTTPNetworkManager.this, networkConnection2, pEPeerTransport);
                } else if (string.indexOf("/files/") != -1) {
                    hTTPNetworkConnection = new HTTPNetworkConnectionFile(HTTPNetworkManager.this, networkConnection2, pEPeerTransport);
                } else {
                    return false;
                }
                hTTPNetworkConnection.readWakeup();
                return true;
            }
        });
    }

    public boolean isHTTPListenerEnabled() {
        return this.http_incoming_manager.isEnabled();
    }

    public int getHTTPListeningPortNumber() {
        return this.http_incoming_manager.getTCPListeningPortNumber();
    }

    public void setExplicitBindAddress(InetAddress inetAddress) {
        this.http_incoming_manager.setExplicitBindAddress(inetAddress);
    }

    public void clearExplicitBindAddress() {
        this.http_incoming_manager.clearExplicitBindAddress();
    }

    public boolean isEffectiveBindAddress(InetAddress inetAddress) {
        return this.http_incoming_manager.isEffectiveBindAddress(inetAddress);
    }

    protected String getIndexPage() {
        return "HTTP/1.1 200 OK\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected String getPingPage(String string) {
        Object object;
        Object object2;
        int n = string.indexOf(32);
        if (n != -1) {
            string = string.substring(0, n);
        }
        n = string.indexOf(63);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        if (n != -1) {
            object2 = new StringTokenizer(string.substring(n + 1), "&");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                n = ((String)object).indexOf(61);
                if (n == -1) continue;
                String string2 = ((String)object).substring(0, n);
                String string3 = ((String)object).substring(n + 1);
                if (!string2.equals("check")) continue;
                hashMap.put("check", string3);
                bl = true;
            }
        }
        if (bl) {
            try {
                object2 = BEncoder.encode(hashMap);
                object = new byte[4];
                ByteBuffer.wrap((byte[])object).putInt(((Object)object2).length);
                return "HTTP/1.1 200 OK\r\nConnection: Close\r\nContent-Length: " + (((Object)object2).length + 4) + NL + NL + new String((byte[])object, "ISO-8859-1") + new String((byte[])object2, "ISO-8859-1");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.getNotFound();
    }

    protected String getTest503() {
        return "HTTP/1.1 503 Service Unavailable\r\nConnection: Close\r\nContent-Length: 4\r\n\r\n1234";
    }

    protected String getNotFound() {
        return "HTTP/1.1 404 Not Found\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected String getRangeNotSatisfiable() {
        return "HTTP/1.1 416 Not Satisfiable\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected void writeReply(final NetworkConnection networkConnection, TransportHelper transportHelper, final String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        final ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        try {
            transportHelper.write(byteBuffer, false);
            if (byteBuffer.remaining() > 0) {
                transportHelper.registerForWriteSelects(new TransportHelper.selectListener(){

                    @Override
                    public boolean selectSuccess(TransportHelper transportHelper, Object object) {
                        try {
                            int n = transportHelper.write(byteBuffer, false);
                            if (byteBuffer.remaining() > 0) {
                                transportHelper.registerForWriteSelects(this, null);
                            } else {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " closed"));
                                }
                                networkConnection.close();
                            }
                            return n > 0;
                        }
                        catch (Throwable throwable) {
                            transportHelper.cancelWriteSelects();
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " failed to write error '" + string + "'"));
                            }
                            networkConnection.close();
                            return false;
                        }
                    }

                    @Override
                    public void selectFailure(TransportHelper transportHelper, Object object, Throwable throwable) {
                        transportHelper.cancelWriteSelects();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " failed to write error '" + string + "'"));
                        }
                        networkConnection.close();
                    }
                }, null);
            } else {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " closed"));
                }
                networkConnection.close();
            }
        }
        catch (Throwable throwable) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " failed to write error '" + string + "'"));
            }
            networkConnection.close();
        }
    }

    public void addURLHandler(URLHandler uRLHandler) {
        this.url_handlers.add(uRLHandler);
    }

    public void removeURLHandler(URLHandler uRLHandler) {
        this.url_handlers.remove(uRLHandler);
    }

    public static interface URLHandler {
        public boolean matches(String var1);

        public void handle(TransportHelper var1, String var2);
    }
}

