/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.tcp.LightweightTCPTransport;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class ProtocolEndpointTCP
implements ProtocolEndpoint {
    private ConnectionEndpoint ce;
    private InetSocketAddress address;

    public ProtocolEndpointTCP(ConnectionEndpoint connectionEndpoint, InetSocketAddress inetSocketAddress) {
        this.ce = connectionEndpoint;
        this.address = inetSocketAddress;
        this.ce.addProtocol(this);
    }

    public ProtocolEndpointTCP(InetSocketAddress inetSocketAddress) {
        this.ce = new ConnectionEndpoint(inetSocketAddress);
        this.address = inetSocketAddress;
        this.ce.addProtocol(this);
    }

    @Override
    public void setConnectionEndpoint(ConnectionEndpoint connectionEndpoint) {
        this.ce = connectionEndpoint;
        this.ce.addProtocol(this);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public ConnectionEndpoint getConnectionEndpoint() {
        return this.ce;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public Transport connectOutbound(boolean bl, boolean bl2, byte[][] byArray, ByteBuffer byteBuffer, int n, Transport.ConnectListener connectListener) {
        TCPTransportImpl tCPTransportImpl = new TCPTransportImpl(this, bl, bl2, byArray);
        tCPTransportImpl.connectOutbound(byteBuffer, connectListener, n);
        return tCPTransportImpl;
    }

    public Transport connectLightWeight(SocketChannel socketChannel) {
        return new LightweightTCPTransport(this, TCPTransportHelperFilterFactory.createTransparentFilter(socketChannel));
    }

    @Override
    public String getDescription() {
        return this.address.toString();
    }
}

