/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.VirtualAcceptSelector;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class VirtualNonBlockingServerChannelSelector
implements VirtualServerChannelSelector {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private List server_channels = new ArrayList();
    private final InetAddress bind_address;
    private int start_port;
    private int num_ports;
    private final int receive_buffer_size;
    private final VirtualServerChannelSelector.SelectListener listener;
    protected AEMonitor this_mon = new AEMonitor("VirtualNonBlockingServerChannelSelector");
    private long last_accept_time;

    public VirtualNonBlockingServerChannelSelector(InetSocketAddress inetSocketAddress, int n, VirtualServerChannelSelector.SelectListener selectListener2) {
        this(inetSocketAddress.getAddress(), inetSocketAddress.getPort(), 1, n, selectListener2);
    }

    public VirtualNonBlockingServerChannelSelector(InetAddress inetAddress, int n, int n2, int n3, VirtualServerChannelSelector.SelectListener selectListener2) {
        this.bind_address = inetAddress;
        this.start_port = n;
        this.num_ports = n2;
        this.receive_buffer_size = n3;
        this.listener = selectListener2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            this.this_mon.enter();
            if (!this.isRunning()) {
                for (int i = this.start_port; i < this.start_port + this.num_ports; ++i) {
                    try {
                        final ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                        this.server_channels.add(serverSocketChannel);
                        serverSocketChannel.socket().setReuseAddress(true);
                        if (this.receive_buffer_size > 0) {
                            serverSocketChannel.socket().setReceiveBufferSize(this.receive_buffer_size);
                        }
                        serverSocketChannel.socket().bind(new InetSocketAddress(this.bind_address, i), 1024);
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "TCP incoming server socket " + this.bind_address));
                        }
                        serverSocketChannel.configureBlocking(false);
                        VirtualAcceptSelector.getSingleton().register(serverSocketChannel, new VirtualAcceptSelector.AcceptListener(){

                            @Override
                            public void newConnectionAccepted(SocketChannel socketChannel) {
                                VirtualNonBlockingServerChannelSelector.this.last_accept_time = SystemTime.getCurrentTime();
                                VirtualNonBlockingServerChannelSelector.this.listener.newConnectionAccepted(serverSocketChannel, socketChannel);
                            }
                        });
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                        Logger.log(new LogAlert(false, "ERROR, unable to bind TCP incoming server socket to " + i, throwable));
                    }
                }
                this.last_accept_time = SystemTime.getCurrentTime();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.server_channels.size(); ++i) {
                try {
                    ServerSocketChannel serverSocketChannel = (ServerSocketChannel)this.server_channels.get(i);
                    VirtualAcceptSelector.getSingleton().cancel(serverSocketChannel);
                    serverSocketChannel.close();
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
            this.server_channels.clear();
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean isRunning() {
        if (this.server_channels.size() == 0) {
            return false;
        }
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)this.server_channels.get(0);
        return serverSocketChannel != null && serverSocketChannel.isOpen();
    }

    @Override
    public InetAddress getBoundToAddress() {
        if (this.server_channels.size() == 0) {
            return null;
        }
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)this.server_channels.get(0);
        return serverSocketChannel.socket().getInetAddress();
    }

    @Override
    public long getTimeOfLastAccept() {
        return this.last_accept_time;
    }
}

