/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.pairing.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.pairing.PairedNode;
import com.aelitis.azureus.core.pairing.PairedService;
import com.aelitis.azureus.core.pairing.PairingConnectionData;
import com.aelitis.azureus.core.pairing.PairingException;
import com.aelitis.azureus.core.pairing.PairingManager;
import com.aelitis.azureus.core.pairing.PairingManagerListener;
import com.aelitis.azureus.core.pairing.PairingTest;
import com.aelitis.azureus.core.pairing.PairingTestListener;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.net.upnp.UPnPRootDevice;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.config.InfoParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class PairingManagerImpl
implements PairingManager {
    private static final boolean DEBUG = false;
    private static final String SERVICE_URL;
    private static final PairingManagerImpl singleton;
    private static final int GLOBAL_UPDATE_PERIOD = 60000;
    private static final int CD_REFRESH_PERIOD = 82800000;
    private static final int CD_REFRESH_TICKS = 1380;
    private static final int CONNECT_TEST_PERIOD_MILLIS = 1800000;
    private AzureusCore azureus_core;
    private BooleanParameter param_enable;
    private InfoParameter param_ac_info;
    private InfoParameter param_status_info;
    private InfoParameter param_last_error;
    private HyperlinkParameter param_view;
    private BooleanParameter param_e_enable;
    private StringParameter param_public_ipv4;
    private StringParameter param_public_ipv6;
    private StringParameter param_host;
    private StringParameter param_local_ipv4;
    private StringParameter param_local_ipv6;
    private Map<String, PairedServiceImpl> services = new HashMap<String, PairedServiceImpl>();
    private AESemaphore init_sem = new AESemaphore("PM:init");
    private TimerEventPeriodic global_update_event;
    private InetAddress current_v4;
    private InetAddress current_v6;
    private String local_v4 = "";
    private String local_v6 = "";
    private boolean update_outstanding;
    private boolean updates_enabled;
    private static final int MIN_UPDATE_PERIOD_DEFAULT = 10000;
    private static final int MAX_UPDATE_PERIOD_DEFAULT = 3600000;
    private int min_update_period = 10000;
    private int max_update_period = 3600000;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private boolean must_update_once;
    private boolean update_in_progress;
    private TimerEvent deferred_update_event;
    private long last_update_time = -1L;
    private int consec_update_fails;
    private String last_message;
    private Map<String, Object[]> local_address_checks = new HashMap<String, Object[]>();
    private CopyOnWriteList<PairingManagerListener> listeners = new CopyOnWriteList();

    public static PairingManager getSingleton() {
        return singleton;
    }

    protected PairingManagerImpl() {
        this.must_update_once = COConfigurationManager.getBooleanParameter("pairing.updateoutstanding");
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        final UIManager uIManager = pluginInterface.getUIManager();
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("server", "Pairing");
        basicPluginConfigModel.addHyperlinkParameter2("ConfigView.label.please.visit.here", MessageText.getString("ConfigView.section.connection.pairing.url"));
        this.param_enable = basicPluginConfigModel.addBooleanParameter2("pairing.enable", "pairing.enable", false);
        String string = this.readAccessCode();
        this.param_ac_info = basicPluginConfigModel.addInfoParameter2("pairing.accesscode", string);
        this.param_status_info = basicPluginConfigModel.addInfoParameter2("pairing.status.info", "");
        this.param_last_error = basicPluginConfigModel.addInfoParameter2("pairing.last.error", "");
        this.param_view = basicPluginConfigModel.addHyperlinkParameter2("pairing.view.registered", SERVICE_URL + "/web/view?ac=" + string);
        if (string.length() == 0) {
            this.param_view.setEnabled(false);
        }
        final ActionParameter actionParameter = basicPluginConfigModel.addActionParameter2("pairing.ac.getnew", "pairing.ac.getnew.create");
        actionParameter.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter parameter) {
                try {
                    actionParameter.setEnabled(false);
                    PairingManagerImpl.this.allocateAccessCode(false);
                    SimpleTimer.addEvent("PM:enabler", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent timerEvent2) {
                            actionParameter.setEnabled(true);
                        }
                    });
                }
                catch (Throwable throwable) {
                    actionParameter.setEnabled(true);
                    String string = MessageText.getString("pairing.alloc.fail", new String[]{Debug.getNestedExceptionMessage(throwable)});
                    uIManager.showMessageBox("pairing.op.fail", "!" + string + "!", 1L);
                }
            }
        });
        LabelParameter labelParameter = basicPluginConfigModel.addLabelParameter2("pairing.explicit.info");
        this.param_e_enable = basicPluginConfigModel.addBooleanParameter2("pairing.explicit.enable", "pairing.explicit.enable", false);
        this.param_public_ipv4 = basicPluginConfigModel.addStringParameter2("pairing.ipv4", "pairing.ipv4", "");
        this.param_public_ipv6 = basicPluginConfigModel.addStringParameter2("pairing.ipv6", "pairing.ipv6", "");
        this.param_host = basicPluginConfigModel.addStringParameter2("pairing.host", "pairing.host", "");
        LabelParameter labelParameter2 = basicPluginConfigModel.addLabelParameter2("blank.resource");
        this.param_local_ipv4 = basicPluginConfigModel.addStringParameter2("pairing.local.ipv4", "pairing.local.ipv4", "");
        this.param_local_ipv6 = basicPluginConfigModel.addStringParameter2("pairing.local.ipv6", "pairing.local.ipv6", "");
        this.param_public_ipv4.setGenerateIntermediateEvents(false);
        this.param_public_ipv6.setGenerateIntermediateEvents(false);
        this.param_host.setGenerateIntermediateEvents(false);
        ParameterListener parameterListener = new ParameterListener(){

            @Override
            public void parameterChanged(Parameter parameter) {
                PairingManagerImpl.this.updateNeeded();
                if (parameter == PairingManagerImpl.this.param_enable) {
                    PairingManagerImpl.this.fireChanged();
                }
            }
        };
        this.param_enable.addListener(parameterListener);
        this.param_e_enable.addListener(parameterListener);
        this.param_public_ipv4.addListener(parameterListener);
        this.param_public_ipv6.addListener(parameterListener);
        this.param_local_ipv4.addListener(parameterListener);
        this.param_local_ipv6.addListener(parameterListener);
        this.param_host.addListener(parameterListener);
        this.param_e_enable.addEnabledOnSelection(this.param_public_ipv4);
        this.param_e_enable.addEnabledOnSelection(this.param_public_ipv6);
        this.param_e_enable.addEnabledOnSelection(this.param_local_ipv4);
        this.param_e_enable.addEnabledOnSelection(this.param_local_ipv6);
        this.param_e_enable.addEnabledOnSelection(this.param_host);
        basicPluginConfigModel.createGroup("pairing.group.explicit", new Parameter[]{labelParameter, this.param_e_enable, this.param_public_ipv4, this.param_public_ipv6, this.param_host, labelParameter2, this.param_local_ipv4, this.param_local_ipv6});
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore azureusCore) {
                PairingManagerImpl.this.initialise(azureusCore);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(AzureusCore azureusCore) {
        Object object = this;
        synchronized (object) {
            this.azureus_core = azureusCore;
        }
        try {
            object = PluginInitializer.getDefaultInterface();
            DelayedTask delayedTask = object.getUtilities().createDelayedTask(new Runnable(){

                @Override
                public void run() {
                    new DelayedEvent("PM:delayinit", 10000L, new AERunnable(){

                        @Override
                        public void runSupport() {
                            PairingManagerImpl.this.enableUpdates();
                        }
                    });
                }
            });
            delayedTask.queue();
        }
        finally {
            this.init_sem.releaseForever();
        }
    }

    protected void waitForInitialisation() throws PairingException {
        if (!this.init_sem.reserve(30000L)) {
            throw new PairingException("Timeout waiting for initialisation");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.param_enable.getValue();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.param_enable.setValue(bl);
    }

    @Override
    public void setGroup(String string) {
        COConfigurationManager.setParameter("pairing.groupcode", string);
        this.updateNeeded();
    }

    @Override
    public String getGroup() {
        return COConfigurationManager.getStringParameter("pairing.groupcode", null);
    }

    @Override
    public List<PairedNode> listGroup() throws PairingException {
        try {
            URL uRL = new URL(SERVICE_URL + "/remote/listGroup?gc=" + this.getGroup());
            InputStream inputStream = new ResourceDownloaderFactoryImpl().create(uRL).download();
            Map map = JSONUtils.decodeJSON(new String(FileUtil.readInputStreamAsByteArray(inputStream), "UTF-8"));
            List list = (List)map.get("result");
            ArrayList<PairedNode> arrayList = new ArrayList<PairedNode>();
            String string = this.peekAccessCode();
            if (list != null) {
                for (Map map2 : list) {
                    PairedNodeImpl pairedNodeImpl = new PairedNodeImpl(map2);
                    if (string != null && string.equals(pairedNodeImpl.getAccessCode())) continue;
                    arrayList.add(pairedNodeImpl);
                }
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            throw new PairingException("Failed to list group", throwable);
        }
    }

    protected void setStatus(String string) {
        String string2 = this.param_status_info.getValue();
        if (!string2.equals(string)) {
            this.param_status_info.setValue(string);
            this.fireChanged();
        }
    }

    @Override
    public String getStatus() {
        return this.param_status_info.getValue();
    }

    protected void setLastServerError(String string) {
        String string2 = this.param_last_error.getValue();
        if (string == null) {
            string = "";
        }
        if (!string2.equals(string)) {
            this.param_last_error.setValue(string);
            this.fireChanged();
        }
    }

    @Override
    public String getLastServerError() {
        String string = this.param_last_error.getValue();
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasActionOutstanding() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (!this.isEnabled()) {
                return false;
            }
            return !this.updates_enabled || this.update_outstanding || this.deferred_update_event != null || this.update_in_progress;
        }
    }

    protected String readAccessCode() {
        return COConfigurationManager.getStringParameter("pairing.accesscode", "");
    }

    protected void writeAccessCode(String string) {
        COConfigurationManager.setParameter("pairing.accesscode", string);
        COConfigurationManager.save();
        this.param_ac_info.setValue(string);
        this.param_view.setHyperlink(SERVICE_URL + "/web/view?ac=" + string);
        this.param_view.setEnabled(string.length() > 0);
    }

    protected String allocateAccessCode(boolean bl) throws PairingException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = this.readAccessCode();
        hashMap.put("ac", string);
        Map<String, Object> map = this.sendRequest("allocate", hashMap);
        try {
            String string2 = this.getString(map, "ac");
            this.writeAccessCode(string2);
            if (!bl) {
                this.updateNeeded();
            }
            this.fireChanged();
            return string2;
        }
        catch (Throwable throwable) {
            throw new PairingException("allocation failed", throwable);
        }
    }

    @Override
    public String peekAccessCode() {
        return this.readAccessCode();
    }

    @Override
    public String getAccessCode() throws PairingException {
        this.waitForInitialisation();
        String string = this.readAccessCode();
        if (string == null || string.length() == 0) {
            string = this.allocateAccessCode(false);
        }
        return string;
    }

    public void getAccessCode(final PairingManagerListener pairingManagerListener) throws PairingException {
        new AEThread2("PM:gac", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PairingManagerImpl.this.getAccessCode();
                }
                catch (Throwable throwable) {
                }
                finally {
                    pairingManagerListener.somethingChanged(PairingManagerImpl.this);
                }
            }
        }.start();
    }

    @Override
    public String getReplacementAccessCode() throws PairingException {
        this.waitForInitialisation();
        String string = this.allocateAccessCode(false);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedService addService(String string) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedServiceImpl pairedServiceImpl = this.services.get(string);
            if (pairedServiceImpl == null) {
                pairedServiceImpl = new PairedServiceImpl(string);
                this.services.put(string, pairedServiceImpl);
            }
            return pairedServiceImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedService getService(String string) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedService pairedService = this.services.get(string);
            return pairedService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(PairedServiceImpl pairedServiceImpl) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            String string = pairedServiceImpl.getSID();
            if (this.services.remove(string) != null) {
                // empty if block
            }
        }
        this.updateNeeded();
    }

    protected void sync(PairedServiceImpl pairedServiceImpl) {
        this.updateNeeded();
    }

    protected InetAddress updateAddress(InetAddress inetAddress, InetAddress inetAddress2, boolean bl) {
        if (bl ? inetAddress2 instanceof Inet4Address : inetAddress2 instanceof Inet6Address) {
            return inetAddress;
        }
        if (inetAddress == inetAddress2) {
            return inetAddress;
        }
        if (inetAddress == null || inetAddress2 == null) {
            return inetAddress2;
        }
        if (!inetAddress.equals(inetAddress2)) {
            return inetAddress2;
        }
        return inetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void updateGlobals(boolean bl) {
        final long l = SystemTime.getMonotonousTime();
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            void runnable;
            NetworkAdmin networkAdmin = NetworkAdmin.getSingleton();
            InetAddress inetAddress = this.azureus_core.getInstanceManager().getMyInstance().getExternalAddress();
            InetAddress inetAddress2 = this.updateAddress(this.current_v4, inetAddress, false);
            InetAddress inetAddress3 = networkAdmin.getDefaultPublicAddressV6();
            InetAddress inetAddress4 = this.updateAddress(this.current_v6, inetAddress3, true);
            final TreeSet<String> treeSet = new TreeSet<String>();
            final TreeSet<String> treeSet2 = new TreeSet<String>();
            NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray = networkAdmin.getInterfaces();
            ArrayList<6> arrayList = new ArrayList<6>();
            HashSet<String> hashSet = new HashSet<String>(this.local_address_checks.keySet());
            Object object = networkAdminNetworkInterfaceArray;
            int i = ((NetworkAdminNetworkInterface[])object).length;
            boolean bl2 = false;
            while (runnable < i) {
                NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray;
                NetworkAdminNetworkInterface networkAdminNetworkInterface = object[runnable];
                for (NetworkAdminNetworkInterfaceAddress networkAdminNetworkInterfaceAddress : networkAdminNetworkInterfaceAddressArray = networkAdminNetworkInterface.getAddresses()) {
                    boolean map;
                    Object[] objectArray;
                    final InetAddress inetAddress5 = networkAdminNetworkInterfaceAddress.getAddress();
                    if (inetAddress5.isLoopbackAddress() || !inetAddress5.isLinkLocalAddress() && !inetAddress5.isSiteLocalAddress()) continue;
                    final String string = inetAddress5.getHostAddress();
                    hashSet.remove(string);
                    Map<String, Object[]> map2 = this.local_address_checks;
                    synchronized (map2) {
                        objectArray = this.local_address_checks.get(string);
                    }
                    boolean bl3 = map = objectArray == null || l - (Long)objectArray[0] > 1800000L;
                    if (map) {
                        arrayList.add(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Socket socket = new Socket();
                                String string2 = string;
                                try {
                                    socket.bind(new InetSocketAddress(inetAddress5, 0));
                                    socket.connect(new InetSocketAddress("www.google.com", 80), 10000);
                                    string2 = string2 + "*";
                                }
                                catch (Throwable throwable) {
                                }
                                finally {
                                    try {
                                        socket.close();
                                    }
                                    catch (Throwable throwable) {}
                                }
                                Map map = PairingManagerImpl.this.local_address_checks;
                                synchronized (map) {
                                    PairingManagerImpl.this.local_address_checks.put(string, new Object[]{new Long(l), string2});
                                    if (inetAddress5 instanceof Inet4Address) {
                                        treeSet.add(string2);
                                    } else {
                                        treeSet2.add(string2);
                                    }
                                }
                            }
                        });
                        continue;
                    }
                    Map<String, Object[]> map3 = this.local_address_checks;
                    synchronized (map3) {
                        if (inetAddress5 instanceof Inet4Address) {
                            treeSet.add((String)objectArray[1]);
                        } else {
                            treeSet2.add((String)objectArray[1]);
                        }
                    }
                }
                ++runnable;
            }
            if (arrayList.size() > 0) {
                object = new AESemaphore("PM:check");
                for (final Runnable runnable2 : arrayList) {
                    new AEThread2("PM:check:", true, (AESemaphore)object){
                        final /* synthetic */ AESemaphore val$sem;
                        {
                            this.val$sem = aESemaphore;
                            super(string, bl);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                runnable2.run();
                            }
                            finally {
                                this.val$sem.release();
                            }
                        }
                    }.start();
                }
                for (i = 0; i < arrayList.size(); ++i) {
                    ((AESemaphore)object).reserve();
                }
            }
            for (String string : hashSet) {
                this.local_address_checks.remove(string);
            }
            object = this.getString(treeSet);
            String string = this.getString(treeSet2);
            if (inetAddress2 != this.current_v4 || inetAddress4 != this.current_v6 || !((String)object).equals(this.local_v4) || !string.equals(this.local_v6)) {
                this.current_v4 = inetAddress2;
                this.current_v6 = inetAddress4;
                this.local_v4 = object;
                this.local_v6 = string;
                if (!bl) {
                    this.updateNeeded();
                }
            }
        }
    }

    protected String getString(Set<String> set) {
        String string = "";
        for (String string2 : set) {
            string = string + (string.length() == 0 ? "" : ",") + string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableUpdates() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            this.updates_enabled = true;
            if (this.update_outstanding) {
                this.update_outstanding = false;
                this.updateNeeded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNeeded() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (this.updates_enabled) {
                this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        PairingManagerImpl.this.doUpdate();
                    }
                });
            } else {
                this.setStatus(MessageText.getString("pairing.status.initialising"));
                this.update_outstanding = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpdate() {
        long l = SystemTime.getMonotonousTime();
        Object object = this;
        synchronized (object) {
            if (this.deferred_update_event != null) {
                return;
            }
            long l2 = l - this.last_update_time;
            if (this.last_update_time > 0L && l2 < (long)this.min_update_period) {
                this.deferUpdate((long)this.min_update_period - l2);
                return;
            }
            this.update_in_progress = true;
        }
        try {
            Object object2;
            object = new HashMap();
            boolean bl = this.param_enable.getValue();
            Object object3 = this;
            synchronized (object3) {
                object2 = new ArrayList<Map<String, String>>();
                object.put("s", object2);
                if (this.services.size() > 0 && bl) {
                    if (this.global_update_event == null) {
                        this.global_update_event = SimpleTimer.addPeriodicEvent("PM:updater", 60000L, new TimerEventPerformer(){
                            private int tick_count;

                            @Override
                            public void perform(TimerEvent timerEvent2) {
                                ++this.tick_count;
                                PairingManagerImpl.this.updateGlobals(false);
                                if (this.tick_count % 1380 == 0) {
                                    PairingManagerImpl.this.updateNeeded();
                                }
                            }
                        });
                        this.updateGlobals(true);
                    }
                    for (PairedServiceImpl pairedServiceImpl : this.services.values()) {
                        object2.add(pairedServiceImpl.toMap());
                    }
                } else if (this.global_update_event == null) {
                    if (this.consec_update_fails == 0 && !this.must_update_once) {
                        this.update_in_progress = false;
                        this.setStatus(MessageText.getString(bl ? "pairing.status.noservices" : "pairing.status.disabled"));
                        return;
                    }
                } else {
                    this.global_update_event.cancel();
                    this.global_update_event = null;
                }
                this.last_update_time = l;
            }
            object3 = this.readAccessCode();
            if (((String)object3).length() == 0) {
                object3 = this.allocateAccessCode(true);
            }
            object.put("ac", object3);
            object2 = this.getGroup();
            if (object2 != null && ((String)object2).length() > 0) {
                object.put("gc", object2);
            }
            Object object4 = this;
            synchronized (object4) {
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                if (this.current_v4 != null) {
                    object.put("c_v4", this.current_v4.getHostAddress());
                }
                if (this.current_v6 != null) {
                    object.put("c_v6", this.current_v6.getHostAddress());
                }
                if (this.local_v4.length() > 0) {
                    object.put("l_v4", this.local_v4);
                }
                if (this.local_v6.length() > 0) {
                    object.put("l_v6", this.local_v6);
                }
                if (this.param_e_enable.getValue()) {
                    String string = this.param_host.getValue().trim();
                    if (string.length() > 0) {
                        object.put("e_h", string);
                    }
                    if (((String)(object8 = this.param_public_ipv4.getValue().trim())).length() > 0) {
                        object.put("e_v4", object8);
                    }
                    if (((String)(object7 = this.param_public_ipv6.getValue().trim())).length() > 0) {
                        object.put("e_v6", object7);
                    }
                    if (((String)(object6 = this.param_local_ipv4.getValue().trim())).length() > 0) {
                        object.put("e_l_v4", object6);
                    }
                    if (((String)(object5 = this.param_local_ipv6.getValue().trim())).length() > 0) {
                        object.put("e_l_v6", object5);
                    }
                }
                try {
                    PluginInterface pluginInterface = this.azureus_core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                    if (pluginInterface != null && ((UPnPPlugin)(object8 = (UPnPPlugin)pluginInterface.getPlugin())).isEnabled()) {
                        object7 = new ArrayList();
                        object.put("upnp", object7);
                        object6 = ((UPnPPlugin)object8).getServices();
                        object5 = new HashSet();
                        for (Object object9 : object6) {
                            UPnPRootDevice uPnPRootDevice = ((UPnPPluginService)object9).getService().getGenericService().getDevice().getRootDevice();
                            if (object5.contains(uPnPRootDevice)) continue;
                            object5.add(uPnPRootDevice);
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            object7.add(hashMap);
                            hashMap.put("i", uPnPRootDevice.getInfo());
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    NetworkAdmin networkAdmin = NetworkAdmin.getSingleton();
                    object8 = networkAdmin.getHTTPProxy();
                    if (object8 != null) {
                        object.put("hp", object8.getName());
                    }
                    if (((NetworkAdminSocksProxy[])(object7 = networkAdmin.getSocksProxies())).length > 0) {
                        object.put("sp", object7[0].getName());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                object.put("_enabled", bl ? 1L : 0L);
            }
            this.sendRequest("update", (Map<String, Object>)object);
            object4 = this;
            synchronized (object4) {
                this.consec_update_fails = 0;
                this.must_update_once = false;
                if (this.deferred_update_event == null) {
                    COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                }
                this.update_in_progress = false;
                if (this.global_update_event == null) {
                    this.setStatus(MessageText.getString(bl ? "pairing.status.noservices" : "pairing.status.disabled"));
                } else {
                    this.setStatus(MessageText.getString("pairing.status.registered", new String[]{new SimpleDateFormat().format(new Date(SystemTime.getCurrentTime()))}));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            PairingManagerImpl pairingManagerImpl = this;
            synchronized (pairingManagerImpl) {
                try {
                    ++this.consec_update_fails;
                    long l3 = this.min_update_period;
                    for (int i = 0; i < this.consec_update_fails; ++i) {
                        if ((l3 *= 2L) <= (long)this.max_update_period) continue;
                        l3 = this.max_update_period;
                        break;
                    }
                    this.deferUpdate(l3);
                }
                finally {
                    this.update_in_progress = false;
                }
                return;
            }
        }
        finally {
            PairingManagerImpl pairingManagerImpl = this;
            synchronized (pairingManagerImpl) {
                if (this.update_in_progress) {
                    Debug.out("Something didn't clear update_in_progress!!!!");
                    this.update_in_progress = false;
                }
            }
        }
    }

    protected void deferUpdate(long l) {
        long l2 = SystemTime.getOffsetTime(l += 5000L);
        this.deferred_update_event = SimpleTimer.addEvent("PM:defer", l2, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent timerEvent2) {
                PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                synchronized (pairingManagerImpl) {
                    PairingManagerImpl.this.deferred_update_event = null;
                }
                COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                PairingManagerImpl.this.updateNeeded();
            }
        });
        this.setStatus(MessageText.getString("pairing.status.pending", new String[]{new SimpleDateFormat().format(new Date(l2))}));
        COConfigurationManager.setParameter("pairing.updateoutstanding", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> sendRequest(String string, Map<String, Object> map) throws PairingException {
        try {
            Object object;
            String string2;
            HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
            CryptoManager cryptoManager = CryptoManagerFactory.getSingleton();
            String string3 = Base32.encode(cryptoManager.getSecureID());
            map.put("_azid", string3);
            try {
                string2 = Base32.encode(cryptoManager.getECCHandler().getPublicKey("pairing"));
                map.put("_pk", string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hashMap.put("req", map);
            string2 = Base32.encode(BEncoder.encode(hashMap));
            String string4 = null;
            try {
                string4 = Base32.encode(cryptoManager.getECCHandler().sign(string2.getBytes("UTF-8"), "pairing"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String string5 = "&ver=" + UrlUtils.encode("4.5.0.4") + "&app=" + UrlUtils.encode(SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode(MessageText.getCurrentLocale().toString());
            if (string4 != null) {
                string5 = string5 + "&sig=" + string4;
            }
            URL uRL = new URL(SERVICE_URL + "/client/" + string + "?request=" + string2 + string5);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(30000);
            InputStream inputStream = httpURLConnection.getInputStream();
            Map map2 = BDecoder.decode(new BufferedInputStream(inputStream));
            Object object2 = this;
            synchronized (object2) {
                Long l;
                object = (Long)map2.get("min_secs");
                if (object != null) {
                    this.min_update_period = ((Long)object).intValue() * 1000;
                }
                if ((l = (Long)map2.get("max_secs")) != null) {
                    this.max_update_period = l.intValue() * 1000;
                }
            }
            object2 = this.getString(map2, "message");
            if (!(object2 == null || this.last_message != null && this.last_message.equals(object2))) {
                this.last_message = object2;
                try {
                    object = (byte[])map2.get("message_sig");
                    AEVerifier.verifyData((String)object2, (byte[])object);
                    new AEThread2("PairMsg", true, (String)object2){
                        final /* synthetic */ String val$message;
                        {
                            this.val$message = string2;
                            super(string, bl);
                        }

                        @Override
                        public void run() {
                            UIManager uIManager = StaticUtilities.getUIManager(120000L);
                            if (uIManager != null) {
                                uIManager.showMessageBox("pairing.server.warning.title", "!" + this.val$message + "!", 1L);
                            }
                        }
                    }.start();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((object = this.getString(map2, "error")) != null) {
                throw new PairingException((String)object);
            }
            this.setLastServerError(null);
            return (Map)map2.get("rep");
        }
        catch (Throwable throwable) {
            this.setLastServerError(Debug.getNestedExceptionMessage(throwable));
            if (throwable instanceof PairingException) {
                throw (PairingException)throwable;
            }
            throw new PairingException("invocation failed", throwable);
        }
    }

    @Override
    public PairingTest testService(String string, PairingTestListener pairingTestListener) throws PairingException {
        return new TestServiceImpl(string, pairingTestListener);
    }

    protected void fireChanged() {
        for (PairingManagerListener pairingManagerListener : this.listeners) {
            try {
                pairingManagerListener.somethingChanged(this);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    @Override
    public void addListener(PairingManagerListener pairingManagerListener) {
        this.listeners.add(pairingManagerListener);
    }

    @Override
    public void removeListener(PairingManagerListener pairingManagerListener) {
        this.listeners.remove(pairingManagerListener);
    }

    protected String getString(Map<String, Object> map, String string) throws IOException {
        byte[] byArray = (byte[])map.get(string);
        if (byArray == null) {
            return null;
        }
        return new String(byArray, "UTF-8");
    }

    static {
        String string = System.getProperty("az.pairing.url", "");
        SERVICE_URL = string.length() == 0 ? "http://pair.vuze.com/pairing" : string;
        singleton = new PairingManagerImpl();
    }

    private class PairingConnectionData2
    implements PairingConnectionData {
        private Map map;

        protected PairingConnectionData2(Map map) {
            this.map = map;
        }

        @Override
        public void setAttribute(String string, String string2) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public String getAttribute(String string) {
            return (String)this.map.get(string);
        }

        @Override
        public void sync() {
            throw new RuntimeException("Not supported");
        }
    }

    private class PairedService2Impl
    implements PairedService {
        private String sid;
        private Map map;

        protected PairedService2Impl(String string, Map map) {
            this.sid = string;
            this.map = map;
        }

        @Override
        public String getSID() {
            return this.sid;
        }

        @Override
        public PairingConnectionData getConnectionData() {
            return new PairingConnectionData2(this.map);
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not supported");
        }
    }

    private class PairedNodeImpl
    implements PairedNode {
        private Map map;

        protected PairedNodeImpl(Map map) {
            this.map = map;
        }

        @Override
        public String getAccessCode() {
            return (String)this.map.get("ac");
        }

        @Override
        public List<InetAddress> getAddresses() {
            HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
            this.addAddress(hashSet, "c_v4");
            this.addAddress(hashSet, "c_v6");
            this.addAddress(hashSet, "l_v4");
            this.addAddress(hashSet, "l_v6");
            this.addAddress(hashSet, "e_v4");
            this.addAddress(hashSet, "e_v6");
            this.addAddress(hashSet, "e_l_v4");
            this.addAddress(hashSet, "e_l_v6");
            this.addAddress(hashSet, "e_h");
            return new ArrayList<InetAddress>(hashSet);
        }

        private void addAddress(Set<InetAddress> set, String string) {
            String string2 = (String)this.map.get(string);
            if (string2 != null) {
                String[] stringArray;
                for (String string3 : stringArray = string2.split(",")) {
                    if ((string3 = string3.trim()).length() == 0) continue;
                    if (string3.endsWith("*")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    try {
                        set.add(InetAddress.getByName(string3));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public List<PairedService> getServices() {
            Map map = (Map)this.map.get("services");
            ArrayList<PairedService> arrayList = new ArrayList<PairedService>();
            for (Map.Entry entry : map.entrySet()) {
                arrayList.add(new PairedService2Impl((String)entry.getKey(), (Map)entry.getValue()));
            }
            return arrayList;
        }
    }

    protected class PairedServiceImpl
    implements PairedService,
    PairingConnectionData {
        private String sid;
        private Map<String, String> attributes = new HashMap<String, String>();

        protected PairedServiceImpl(String string) {
            this.sid = string;
        }

        @Override
        public String getSID() {
            return this.sid;
        }

        @Override
        public PairingConnectionData getConnectionData() {
            return this;
        }

        @Override
        public void remove() {
            PairingManagerImpl.this.remove(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(String string, String string2) {
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                if (string2 == null) {
                    this.attributes.remove(string);
                } else {
                    this.attributes.put(string, string2);
                }
            }
        }

        @Override
        public String getAttribute(String string) {
            return this.attributes.get(string);
        }

        @Override
        public void sync() {
            PairingManagerImpl.this.sync(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<String, String> toMap() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sid", this.sid);
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                hashMap.putAll(this.attributes);
            }
            return hashMap;
        }
    }

    protected class TestServiceImpl
    implements PairingTest {
        private final String sid;
        private final PairingTestListener listener;
        private volatile int outcome = 0;
        private volatile String error_message;
        private volatile boolean cancelled;

        protected TestServiceImpl(String string, PairingTestListener pairingTestListener) {
            this.sid = string;
            this.listener = pairingTestListener;
            new AEThread2("PM:test"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block21: {
                        try {
                            String string;
                            block20: {
                                string = null;
                                long l = -1L;
                                do {
                                    if (!PairingManagerImpl.this.isEnabled()) {
                                        throw new Exception("Pairing is disabled");
                                    }
                                    string = PairingManagerImpl.this.peekAccessCode();
                                    if (string != null && !PairingManagerImpl.this.hasActionOutstanding()) {
                                        if (PairingManagerImpl.this.getService(TestServiceImpl.this.sid) != null) break block20;
                                        long l2 = SystemTime.getMonotonousTime();
                                        if (l == -1L) {
                                            l = l2;
                                        } else if (l2 - l > 5000L) break block20;
                                    }
                                    Thread.sleep(500L);
                                } while (!TestServiceImpl.this.cancelled);
                                TestServiceImpl.this.outcome = 6;
                                return;
                            }
                            PairedService pairedService = PairingManagerImpl.this.getService(TestServiceImpl.this.sid);
                            if (pairedService == null) {
                                throw new Exception("Service not found");
                            }
                            TestServiceImpl.this.listener.testStarted(TestServiceImpl.this);
                            String string2 = "&ver=" + UrlUtils.encode("4.5.0.4") + "&app=" + UrlUtils.encode(SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode(MessageText.getCurrentLocale().toString());
                            URL uRL = new URL(SERVICE_URL + "/web/test?sid=" + TestServiceImpl.this.sid + "&ac=" + string + "&format=bencode" + string2);
                            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                            httpURLConnection.setConnectTimeout(10000);
                            try {
                                InputStream inputStream = httpURLConnection.getInputStream();
                                Map map = BDecoder.decode(new BufferedInputStream(inputStream));
                                map = BDecoder.decodeStrings(map);
                                Long l = (Long)map.get("code");
                                if (l == null) {
                                    throw new Exception("Code missing from reply");
                                }
                                TestServiceImpl.this.error_message = (String)map.get("msg");
                                if (l == 1L) {
                                    TestServiceImpl.this.outcome = 1;
                                    break block21;
                                }
                                if (l == 2L) {
                                    TestServiceImpl.this.outcome = 4;
                                    break block21;
                                }
                                if (l == 3L) {
                                    TestServiceImpl.this.outcome = 5;
                                    break block21;
                                }
                                if (l == 4L) {
                                    TestServiceImpl.this.outcome = 2;
                                    TestServiceImpl.this.error_message = "Connect timeout";
                                    break block21;
                                }
                                if (l == 5L) {
                                    TestServiceImpl.this.outcome = 2;
                                    break block21;
                                }
                                TestServiceImpl.this.outcome = 5;
                                TestServiceImpl.this.error_message = "Unknown response code " + l;
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                                TestServiceImpl.this.outcome = 3;
                                TestServiceImpl.this.error_message = "Connect timeout";
                            }
                        }
                        catch (Throwable throwable) {
                            TestServiceImpl.this.outcome = 3;
                            TestServiceImpl.this.error_message = Debug.getNestedExceptionMessage(throwable);
                        }
                        finally {
                            TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                        }
                    }
                }
            }.start();
        }

        @Override
        public int getOutcome() {
            return this.outcome;
        }

        @Override
        public String getErrorMessage() {
            return this.error_message;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }
    }
}

