/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.control.impl;

import com.aelitis.azureus.core.peermanager.control.SpeedTokenDispenser;
import com.aelitis.azureus.core.util.FeatureAvailability;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class SpeedTokenDispenserPrioritised
implements SpeedTokenDispenser {
    private int rateKiB;
    private long threshold;
    private long bucket;
    private long lastTime;
    private long currentTime;
    private static final int BUCKET_THRESHOLD_LOWER_BOUND = 32768;
    private static final int BUCKET_RESPONSE_TIME = 1;
    private static final int BUCKET_THRESHOLD_FACTOR = 1024;

    public SpeedTokenDispenserPrioritised() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Max Download Speed KBs", "Use Request Limiting"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                SpeedTokenDispenserPrioritised.this.rateKiB = COConfigurationManager.getIntParameter("Max Download Speed KBs");
                if (!COConfigurationManager.getBooleanParameter("Use Request Limiting") || !FeatureAvailability.isRequestLimitingEnabled()) {
                    SpeedTokenDispenserPrioritised.this.rateKiB = 0;
                }
                if (SpeedTokenDispenserPrioritised.this.rateKiB < 0) {
                    SpeedTokenDispenserPrioritised.this.rateKiB = 0;
                }
                SpeedTokenDispenserPrioritised.this.threshold = Math.max(1024 * SpeedTokenDispenserPrioritised.this.rateKiB, 32768);
                SpeedTokenDispenserPrioritised.this.lastTime = SpeedTokenDispenserPrioritised.this.currentTime - 1L;
                SpeedTokenDispenserPrioritised.this.refill();
            }
        });
        this.bucket = 0L;
        this.lastTime = SystemTime.getCurrentTime();
    }

    public void update(long l) {
        this.currentTime = l;
    }

    public void refill() {
        if (this.lastTime == this.currentTime || this.rateKiB == 0) {
            return;
        }
        if (this.lastTime > this.currentTime) {
            this.lastTime = this.currentTime;
            return;
        }
        if (this.bucket < 0L) {
            Debug.out("Bucket is more than empty! - " + this.bucket);
            this.bucket = 0L;
        }
        long l = this.currentTime - this.lastTime;
        this.lastTime = this.currentTime;
        long l2 = (long)this.rateKiB * 1024L * l / 1000L;
        this.bucket += l2;
        if (this.bucket > this.threshold) {
            this.bucket = this.threshold;
        }
    }

    @Override
    public int dispense(int n, int n2) {
        if (this.rateKiB == 0) {
            return n;
        }
        if ((long)n2 > this.bucket) {
            return 0;
        }
        if ((long)(n2 * n) <= this.bucket) {
            this.bucket -= (long)(n2 * n);
            return n;
        }
        int n3 = (int)(this.bucket / (long)n2);
        this.bucket -= (long)(n2 * n3);
        return n3;
    }

    @Override
    public void returnUnusedChunks(int n, int n2) {
        this.bucket += (long)(n * n2);
    }

    @Override
    public int peek(int n) {
        if (this.rateKiB != 0) {
            return (int)(this.bucket / (long)n);
        }
        return Integer.MAX_VALUE;
    }
}

