/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging;

import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class MessagingUtil {
    public static DirectByteBuffer convertPayloadToBencodedByteStream(Map map, byte by) {
        byte[] byArray;
        try {
            byArray = BEncoder.encode(map);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            byArray = new byte[]{};
        }
        DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer(by, byArray.length);
        directByteBuffer.put((byte)11, byArray);
        directByteBuffer.flip((byte)11);
        return directByteBuffer;
    }

    public static Map convertBencodedByteStreamToPayload(DirectByteBuffer directByteBuffer, int n, String string) throws MessageException {
        if (directByteBuffer == null) {
            throw new MessageException("[" + string + "] decode error: stream == null");
        }
        if (directByteBuffer.remaining((byte)11) < n) {
            throw new MessageException("[" + string + "] decode error: stream.remaining[" + directByteBuffer.remaining((byte)11) + "] < " + n);
        }
        byte[] byArray = new byte[directByteBuffer.remaining((byte)11)];
        directByteBuffer.get((byte)11, byArray);
        try {
            Map map = BDecoder.decode(byArray);
            directByteBuffer.returnToPool();
            return map;
        }
        catch (Throwable throwable) {
            throw new MessageException("[" + string + "] payload stream b-decode error: " + throwable.getMessage());
        }
    }
}

