/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTLTMessage;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageFactory;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessage;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;

public class LTMessageEncoder
implements MessageStreamEncoder {
    protected static final LogIDs LOGID = LogIDs.PEER;
    private Object log_object;
    private HashMap extension_map;

    public LTMessageEncoder(Object object) {
        this.log_object = object;
        this.extension_map = null;
    }

    @Override
    public RawMessage[] encodeMessage(Message message) {
        Byte by;
        if (!(message instanceof LTMessage)) {
            return new RawMessage[]{BTMessageFactory.createBTRawMessage(message)};
        }
        if (message instanceof LTHandshake) {
            return new RawMessage[]{BTMessageFactory.createBTRawMessage(new BTLTMessage(message, 0))};
        }
        if (this.extension_map != null && (by = (Byte)this.extension_map.get(message.getID())) != null) {
            return new RawMessage[]{BTMessageFactory.createBTRawMessage(new BTLTMessage(message, by))};
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.log_object, LOGID, "Unable to send LT message of type " + message.getID() + ", not supported by peer - dropping message."));
        }
        return new RawMessage[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSupportedExtensions(Map map) {
        try {
            for (Map.Entry entry : map.entrySet()) {
                int n;
                String string;
                Object k = entry.getKey();
                if (k instanceof byte[]) {
                    string = new String((byte[])k, "UTF8");
                } else {
                    if (!(k instanceof String)) throw new RuntimeException("unexpected type for extension name: " + k.getClass());
                    string = (String)k;
                }
                Object v = entry.getValue();
                if (v instanceof Long) {
                    n = ((Long)entry.getValue()).intValue();
                } else {
                    if (!(v instanceof byte[])) throw new RuntimeException("unsupported extension id type: " + v.getClass().getName());
                    byte[] byArray = (byte[])v;
                    if (byArray.length != 1) throw new RuntimeException("extension id byte array format length != 1: " + byArray.length);
                    n = byArray[0];
                }
                if (this.extension_map == null) {
                    this.extension_map = new HashMap();
                }
                if (n == 0) {
                    this.extension_map.remove(string);
                    continue;
                }
                this.extension_map.put(string, new Byte((byte)n));
            }
            return;
        }
        catch (Exception exception) {
            if (!Logger.isEnabled()) return;
            Logger.log(new LogEvent(this.log_object, LOGID, "Unable to update LT extension list for peer", (Throwable)exception));
        }
    }

    public boolean supportsUTPEX() {
        if (this.extension_map == null) {
            return false;
        }
        return this.extension_map.containsKey("ut_pex");
    }

    public boolean supportsUTMETADATA() {
        if (this.extension_map == null) {
            return false;
        }
        return this.extension_map.containsKey("ut_metadata") && (Byte)this.extension_map.get("ut_metadata") > 0;
    }
}

