/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.RandomUtils;

public class UnchokerUtil {
    public static boolean isUnchokable(PEPeer pEPeer, boolean bl) {
        return pEPeer.getPeerState() == 30 && !pEPeer.isSeed() && !pEPeer.isRelativeSeed() && pEPeer.isInterested() && (!pEPeer.isSnubbed() || bl);
    }

    public static void updateLargestValueFirstSort(long l, long[] lArray, PEPeer pEPeer, ArrayList arrayList, int n) {
        arrayList.ensureCapacity(lArray.length);
        for (int i = n; i < lArray.length; ++i) {
            if (l < lArray[i]) continue;
            for (int j = lArray.length - 2; j >= i; --j) {
                lArray[j + 1] = lArray[j];
            }
            if (arrayList.size() == lArray.length) {
                arrayList.remove(lArray.length - 1);
            }
            lArray[i] = l;
            arrayList.add(i, pEPeer);
            return;
        }
    }

    public static PEPeer getNextOptimisticPeer(ArrayList<PEPeer> arrayList, boolean bl, boolean bl2) {
        ArrayList<PEPeer> arrayList2 = UnchokerUtil.getNextOptimisticPeers(arrayList, bl, bl2, 1);
        if (arrayList2 != null) {
            return (PEPeerTransport)arrayList2.get(0);
        }
        return null;
    }

    public static ArrayList<PEPeer> getNextOptimisticPeers(ArrayList<PEPeer> arrayList, boolean bl, boolean bl2, int n) {
        Object object;
        int n2;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object = arrayList.get(n2);
            if (!UnchokerUtil.isUnchokable((PEPeer)object, false) || !object.isChokedByMe()) continue;
            arrayList2.add(object);
        }
        if (arrayList2.isEmpty() && bl2) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object = arrayList.get(n2);
                if (!UnchokerUtil.isUnchokable((PEPeer)object, true) || !object.isChokedByMe()) continue;
                arrayList2.add(object);
            }
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        ArrayList<PEPeer> arrayList3 = new ArrayList<PEPeer>(arrayList2.size());
        if (bl) {
            int n3;
            object = new ArrayList(arrayList2.size());
            long[] lArray = new long[arrayList2.size()];
            Arrays.fill(lArray, Long.MIN_VALUE);
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                PEPeer pEPeer = (PEPeer)arrayList2.get(n3);
                long l = pEPeer.getStats().getTotalDataBytesSent() - pEPeer.getStats().getTotalDataBytesReceived();
                UnchokerUtil.updateLargestValueFirstSort(l, lArray, pEPeer, (ArrayList)object, 0);
            }
            for (n3 = 0; n3 < n && ((ArrayList)object).size() > 0; ++n3) {
                double d = 1.0 / (0.8 + 0.2 * Math.pow(RandomUtils.nextFloat(), -1.0));
                int n4 = (int)(d * (double)((ArrayList)object).size());
                arrayList3.add((PEPeer)((ArrayList)object).remove(n4));
            }
        } else {
            for (int i = 0; i < n && arrayList2.size() > 0; ++i) {
                int n5 = new Random().nextInt(arrayList2.size());
                arrayList3.add((PEPeer)arrayList2.remove(n5));
            }
        }
        return arrayList3;
    }

    public static void performChokes(ArrayList<PEPeer> arrayList, ArrayList<PEPeer> arrayList2) {
        PEPeer pEPeer;
        int n;
        if (arrayList != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                pEPeer = (PEPeerTransport)arrayList.get(n);
                if (pEPeer.isChokedByMe()) continue;
                pEPeer.sendChoke();
            }
        }
        if (arrayList2 != null) {
            for (n = 0; n < arrayList2.size(); ++n) {
                pEPeer = arrayList2.get(n);
                if (!pEPeer.isChokedByMe()) continue;
                pEPeer.sendUnChoke();
            }
        }
    }

    public static void performChokeUnchoke(PEPeer pEPeer, PEPeer pEPeer2) {
        if (pEPeer != null && !pEPeer.isChokedByMe()) {
            pEPeer.sendChoke();
        }
        if (pEPeer2 != null && pEPeer2.isChokedByMe()) {
            pEPeer2.sendUnChoke();
        }
    }
}

