/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoder;
import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.gudy.azureus2.core3.internat.MessageText;

public class BTPeerIDByteDecoderDefinitions {
    private static HashMap az_style_code_map = new HashMap();
    private static HashMap az_client_version_map = new HashMap();
    private static HashMap shadow_style_code_map = new HashMap();
    private static HashMap shadow_client_version_map = new HashMap();
    private static HashMap mainline_style_code_map = new HashMap();
    private static ArrayList custom_style_client_list = new ArrayList();
    static String VER_AZ_THREE_DIGITS = "1.2.3";
    static String VER_AZ_THREE_DIGITS_PLUS_MNEMONIC = "1.2.3 [4]";
    static String VER_AZ_ONE_MAJ_TWO_MIN_PLUS_MNEMONIC = "1.23 [4]";
    static String VER_AZ_FOUR_DIGITS = "1.2.3.4";
    static String VER_AZ_TWO_MAJ_TWO_MIN = "12.34";
    static String VER_AZ_SKIP_FIRST_ONE_MAJ_TWO_MIN = "2.34";
    static String VER_AZ_KTORRENT_STYLE = "1.2.3=[RD].4";
    static String VER_AZ_TRANSMISSION_STYLE = "transmission";
    static String VER_AZ_LAST_THREE_DIGITS = "2.3.4";
    static String VER_AZ_THREE_ALPHANUMERIC_DIGITS = "2.33.4";
    static String VER_BLOCK = "abcde";
    static String VER_DOTTED_BLOCK = "a.b.c.d.e";
    static String VER_BYTE_BLOCK_DOTTED_CHAR = "abcde -> a.b.c.d.e";
    static String VER_BITS_ON_WHEELS = "BOW-STYLE";
    static String VER_TWO_BYTE_THREE_PART = "ab -> a . b/10 . b%10";
    static String NO_VERSION = "NO_VERSION";

    private static void addAzStyle(String string, String string2) {
        BTPeerIDByteDecoderDefinitions.addAzStyle(string, string2, VER_AZ_FOUR_DIGITS);
    }

    private static void addAzStyle(String string, String string2, String string3) {
        if (string.length() != 2) {
            throw new RuntimeException("not two chars long - " + string);
        }
        az_style_code_map.put(string, string2);
        az_client_version_map.put(string2, string3);
    }

    private static void addShadowStyle(char c, String string) {
        BTPeerIDByteDecoderDefinitions.addShadowStyle(c, string, VER_AZ_THREE_DIGITS);
    }

    private static void addShadowStyle(char c, String string, String string2) {
        shadow_style_code_map.put("" + c, string);
        shadow_client_version_map.put(string, string2);
    }

    private static void addMainlineStyle(char c, String string) {
        mainline_style_code_map.put("" + c, string);
    }

    private static ClientData addSimpleClient(String string, String string2) {
        return BTPeerIDByteDecoderDefinitions.addSimpleClient(string, string2, 0);
    }

    private static ClientData addSimpleClient(String string, String string2, int n) {
        ClientData clientData = new ClientData(string, string2, n);
        custom_style_client_list.add(clientData);
        return clientData;
    }

    private static void addVersionedClient(ClientData clientData, String string, int n) {
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, string, n, null);
    }

    private static void addVersionedClient(ClientData clientData, String string, int n, String string2) {
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, string, n, string2, clientData.simple_string.length() + clientData.simple_string_pos);
    }

    private static void addVersionedClient(ClientData clientData, String string, int n, int n2) {
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, string, n, null, n2);
    }

    private static void addVersionedClient(ClientData clientData, String string, int n, String string2, int n2) {
        clientData.version_data = new VersionNumberData(string, n, string2, n2);
    }

    public static String getAzStyleClientName(String string) {
        return (String)az_style_code_map.get(string.substring(1, 3));
    }

    public static String getShadowStyleClientName(String string) {
        return (String)shadow_style_code_map.get(string.substring(0, 1));
    }

    public static String getMainlineStyleClientName(String string) {
        return (String)mainline_style_code_map.get(string.substring(0, 1));
    }

    public static String getAzStyleClientVersion(String string, String string2) {
        String string3 = (String)az_client_version_map.get(string);
        if (string3 == NO_VERSION) {
            return null;
        }
        try {
            return string + " " + BTPeerIDByteDecoderUtils.decodeAzStyleVersionNumber(string2.substring(3, 7), string3);
        }
        catch (Exception exception) {
            BTPeerIDByteDecoder.logUnknownClient(string2);
            return null;
        }
    }

    public static ClientData getSubstringStyleClient(String string) {
        ClientData clientData = null;
        for (int i = 0; i < custom_style_client_list.size(); ++i) {
            clientData = (ClientData)custom_style_client_list.get(i);
            if (!string.startsWith(clientData.simple_string, clientData.simple_string_pos)) continue;
            return clientData;
        }
        return null;
    }

    public static String getSubstringStyleClientVersion(ClientData clientData, String string, byte[] byArray) {
        VersionNumberData versionNumberData = clientData.version_data;
        if (versionNumberData == null) {
            return null;
        }
        String string2 = versionNumberData.type;
        String string3 = null;
        try {
            if (string2 == VER_TWO_BYTE_THREE_PART) {
                int n = versionNumberData.pos;
                string3 = BTPeerIDByteDecoderUtils.getTwoByteThreePartVersion(byArray[n], byArray[n + 1]);
            } else {
                string3 = string2 == VER_BLOCK && versionNumberData.length == -1 ? BTPeerIDByteDecoderUtils.extractReadableVersionSubstringFromPeerID(string.substring(versionNumberData.pos, string.length())) : BTPeerIDByteDecoderUtils.decodeCustomVersionNumber(string.substring(versionNumberData.pos, versionNumberData.pos + versionNumberData.length), string2);
            }
            if (versionNumberData.fmt == null) {
                return clientData.client_name + " " + string3;
            }
            return clientData.client_name + versionNumberData.fmt.replaceFirst("%s", string3);
        }
        catch (Exception exception) {
            BTPeerIDByteDecoder.logUnknownClient(string);
            return null;
        }
    }

    public static String formatUnknownAzStyleClient(String string) {
        String string2 = string.substring(3, 7);
        try {
            string2 = BTPeerIDByteDecoderUtils.decodeAzStyleVersionNumber(string2, VER_AZ_FOUR_DIGITS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MessageText.getString("PeerSocket.unknown_az_style", new String[]{string.substring(1, 3), string2});
    }

    public static String formatUnknownShadowStyleClient(String string) {
        String string2 = BTPeerIDByteDecoderUtils.getShadowStyleVersionNumber(string);
        return MessageText.getString("PeerSocket.unknown_shadow_style", new String[]{string.substring(0, 1), string2});
    }

    static {
        BTPeerIDByteDecoderDefinitions.addAzStyle("AZ", "Azureus", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("A~", "Ares", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("AG", "Ares", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("AR", "Ares");
        BTPeerIDByteDecoderDefinitions.addAzStyle("AV", "Avicora");
        BTPeerIDByteDecoderDefinitions.addAzStyle("AX", "BitPump", VER_AZ_TWO_MAJ_TWO_MIN);
        BTPeerIDByteDecoderDefinitions.addAzStyle("AT", "Artemis");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BB", "BitBuddy", "1.234");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BC", "BitComet", VER_AZ_SKIP_FIRST_ONE_MAJ_TWO_MIN);
        BTPeerIDByteDecoderDefinitions.addAzStyle("BE", "BitTorrent SDK");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BF", "BitFlu", NO_VERSION);
        BTPeerIDByteDecoderDefinitions.addAzStyle("BG", "BTG", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("bk", "BitKitten (libtorrent)");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BR", "BitRocket", "1.2(34)");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BS", "BTSlave");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BW", "BitWombat");
        BTPeerIDByteDecoderDefinitions.addAzStyle("BX", "BittorrentX");
        BTPeerIDByteDecoderDefinitions.addAzStyle("CB", "Shareaza Plus");
        BTPeerIDByteDecoderDefinitions.addAzStyle("CD", "Enhanced CTorrent", VER_AZ_TWO_MAJ_TWO_MIN);
        BTPeerIDByteDecoderDefinitions.addAzStyle("CT", "CTorrent", "1.2.34");
        BTPeerIDByteDecoderDefinitions.addAzStyle("DP", "Propogate Data Client");
        BTPeerIDByteDecoderDefinitions.addAzStyle("DE", "Deluge", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("EB", "EBit");
        BTPeerIDByteDecoderDefinitions.addAzStyle("ES", "Electric Sheep", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("FC", "FileCroc");
        BTPeerIDByteDecoderDefinitions.addAzStyle("FG", "FlashGet", VER_AZ_SKIP_FIRST_ONE_MAJ_TWO_MIN);
        BTPeerIDByteDecoderDefinitions.addAzStyle("FT", "FoxTorrent/RedSwoosh");
        BTPeerIDByteDecoderDefinitions.addAzStyle("GR", "GetRight", "1.2");
        BTPeerIDByteDecoderDefinitions.addAzStyle("GS", "GSTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("HL", "Halite", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("HN", "Hydranode");
        BTPeerIDByteDecoderDefinitions.addAzStyle("KT", "KTorrent", VER_AZ_KTORRENT_STYLE);
        BTPeerIDByteDecoderDefinitions.addAzStyle("LC", "LeechCraft");
        BTPeerIDByteDecoderDefinitions.addAzStyle("LH", "LH-ABC");
        BTPeerIDByteDecoderDefinitions.addAzStyle("LK", "linkage", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("LP", "Lphant", VER_AZ_TWO_MAJ_TWO_MIN);
        BTPeerIDByteDecoderDefinitions.addAzStyle("LT", "libtorrent (Rasterbar)", VER_AZ_THREE_ALPHANUMERIC_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("lt", "libTorrent (Rakshasa)", VER_AZ_THREE_ALPHANUMERIC_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("LW", "LimeWire", NO_VERSION);
        BTPeerIDByteDecoderDefinitions.addAzStyle("MO", "MonoTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("MP", "MooPolice", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("MR", "Miro");
        BTPeerIDByteDecoderDefinitions.addAzStyle("MT", "MoonlightTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("NE", "BT Next Evolution", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("NX", "Net Transport");
        BTPeerIDByteDecoderDefinitions.addAzStyle("OS", "OneSwarm", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("OT", "OmegaTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("PC", "CacheLogic", "12.3-4");
        BTPeerIDByteDecoderDefinitions.addAzStyle("PD", "Pando");
        BTPeerIDByteDecoderDefinitions.addAzStyle("PE", "PeerProject");
        BTPeerIDByteDecoderDefinitions.addAzStyle("pX", "pHoeniX");
        BTPeerIDByteDecoderDefinitions.addAzStyle("qB", "qBittorrent", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("QD", "qqdownload");
        BTPeerIDByteDecoderDefinitions.addAzStyle("RT", "Retriever");
        BTPeerIDByteDecoderDefinitions.addAzStyle("RZ", "RezTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("S~", "Shareaza alpha/beta");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SB", "SwiftBit");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SD", "\u8fc5\u96f7\u5728\u7ebf (Xunlei)");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SG", "GS Torrent", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("SN", "ShareNET");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SP", "BitSpirit");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SS", "SwarmScope");
        BTPeerIDByteDecoderDefinitions.addAzStyle("ST", "SymTorrent", "2.34");
        BTPeerIDByteDecoderDefinitions.addAzStyle("st", "SharkTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("SZ", "Shareaza");
        BTPeerIDByteDecoderDefinitions.addAzStyle("TN", "Torrent.NET");
        BTPeerIDByteDecoderDefinitions.addAzStyle("TR", "Transmission", VER_AZ_TRANSMISSION_STYLE);
        BTPeerIDByteDecoderDefinitions.addAzStyle("TS", "TorrentStorm");
        BTPeerIDByteDecoderDefinitions.addAzStyle("TT", "TuoTu", VER_AZ_THREE_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("UL", "uLeecher!");
        BTPeerIDByteDecoderDefinitions.addAzStyle("UT", "\u00b5Torrent", VER_AZ_THREE_DIGITS_PLUS_MNEMONIC);
        BTPeerIDByteDecoderDefinitions.addAzStyle("UM", "\u00b5Torrent Mac", VER_AZ_THREE_DIGITS_PLUS_MNEMONIC);
        BTPeerIDByteDecoderDefinitions.addAzStyle("WT", "Bitlet");
        BTPeerIDByteDecoderDefinitions.addAzStyle("WY", "FireTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("VG", "\u54c7\u560e (Vagaa)", VER_AZ_FOUR_DIGITS);
        BTPeerIDByteDecoderDefinitions.addAzStyle("XL", "\u8fc5\u96f7\u5728\u7ebf (Xunlei)");
        BTPeerIDByteDecoderDefinitions.addAzStyle("XT", "XanTorrent");
        BTPeerIDByteDecoderDefinitions.addAzStyle("XX", "XTorrent", "1.2.34");
        BTPeerIDByteDecoderDefinitions.addAzStyle("XC", "XTorrent", "1.2.34");
        BTPeerIDByteDecoderDefinitions.addAzStyle("ZT", "ZipTorrent");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('A', "ABC");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('O', "Osprey Permaseed");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('Q', "BTQueue");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('R', "Tribler");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('S', "Shad0w");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('T', "BitTornado");
        BTPeerIDByteDecoderDefinitions.addShadowStyle('U', "UPnP NAT");
        BTPeerIDByteDecoderDefinitions.addMainlineStyle('M', "Mainline");
        BTPeerIDByteDecoderDefinitions.addMainlineStyle('Q', "Queen Bee");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("\u00b5Torrent 1.7.0 RC", "-UT170-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Azureus 1", "Azureus");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Azureus 2.0.3.2", "Azureus", 5);
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Aria 2", "-aria2-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BitTorrent Plus! II", "PRC.P---");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BitTorrent Plus!", "P87.P---");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BitTorrent Plus!", "S587Plus");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BitTyrant (Azureus Mod)", "AZ2500BT");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Blizzard Downloader", "BLZ");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BTGetit", "BG", 10);
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BTugaXP", "btuga");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BTugaXP", "BTuga", 5);
        BTPeerIDByteDecoderDefinitions.addSimpleClient("BTugaXP", "oernu");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Deadman Walking", "BTDWV-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Deadman", "Deadman Walking-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("External Webseed", "Ext");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("G3 Torrent", "-G3");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("GreedBT 2.7.1", "271-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Hurricane Electric", "arclight");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("HTTP Seed", "-WS");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("JVtorrent", "10-------");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Limewire", "LIME");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Martini Man", "martini");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Pando", "Pando");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("PeerApp", "PEERAPP");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("SimpleBT", "btfans", 4);
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Swarmy", "a00---0");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Swarmy", "a02---0");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Teeweety", "T00---0");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("TorrentTopia", "346-");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("XanTorrent", "DansClient");
        BTPeerIDByteDecoderDefinitions.addSimpleClient("Amazon AWS S3", "S3-");
        ClientData clientData = null;
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("BitTorrent DNA", "DNA");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BYTE_BLOCK_DOTTED_CHAR, 2, 4);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("Opera", "OP");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BLOCK, 4, " (Build %s)");
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("Opera", "O");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BLOCK, 5, " (Build %s)");
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("Burst!", "Mbrst");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_DOTTED_BLOCK, 5);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("TurboBT", "turbobt");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BLOCK, 5);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("BT Protocol Daemon", "btpd");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BLOCK, 3, 5);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("Plus!", "Plus");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BYTE_BLOCK_DOTTED_CHAR, 3);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("XBT", "XBT");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BYTE_BLOCK_DOTTED_CHAR, 3);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("BitsOnWheels", "-BOW");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BITS_ON_WHEELS, 3);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("eXeem", "eX");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BLOCK, 18, " [%s]");
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("MLdonkey", "-ML");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_DOTTED_BLOCK, 5);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("Bitlet", "BitLet");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BYTE_BLOCK_DOTTED_CHAR, 2);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("AllPeers", "AP");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BLOCK, -1);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("BTuga Revolution", "BTM");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BYTE_BLOCK_DOTTED_CHAR, 2);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("Rufus", "RS", 2);
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_TWO_BYTE_THREE_PART, 2, 0);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("BitMagnet", "BM", 2);
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_TWO_BYTE_THREE_PART, 2, 0);
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("QVOD", "QVOD");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BLOCK, 4, " (Build %s)");
        clientData = BTPeerIDByteDecoderDefinitions.addSimpleClient("Top-BT", "TB");
        BTPeerIDByteDecoderDefinitions.addVersionedClient(clientData, VER_BYTE_BLOCK_DOTTED_CHAR, 3);
    }

    static class VersionNumberData {
        private String type;
        private int pos;
        private String fmt;
        private int length;

        VersionNumberData(String string, int n, String string2, int n2) {
            this.type = string;
            this.pos = n2;
            this.fmt = string2;
            this.length = n;
        }
    }

    static class ClientData {
        String client_name;
        private int simple_string_pos;
        private String simple_string;
        private VersionNumberData version_data;

        ClientData(String string, String string2, int n) {
            this.simple_string_pos = n;
            this.simple_string = string2;
            this.client_name = string;
            this.version_data = null;
        }
    }
}

