/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl;

import com.aelitis.azureus.core.proxy.AEProxyConnection;
import com.aelitis.azureus.core.proxy.AEProxyConnectionListener;
import com.aelitis.azureus.core.proxy.AEProxyHandler;
import com.aelitis.azureus.core.proxy.AEProxyState;
import com.aelitis.azureus.core.proxy.impl.AEProxyImpl;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEProxyConnectionImpl
implements AEProxyConnection {
    private static final LogIDs LOGID = LogIDs.NET;
    protected AEProxyImpl server;
    protected SocketChannel source_channel;
    protected volatile AEProxyState proxy_read_state = null;
    protected volatile AEProxyState proxy_write_state = null;
    protected volatile AEProxyState proxy_connect_state = null;
    protected long time_stamp;
    protected boolean is_connected;
    protected boolean is_closed;
    protected List listeners = new ArrayList(1);

    protected AEProxyConnectionImpl(AEProxyImpl aEProxyImpl, SocketChannel socketChannel, AEProxyHandler aEProxyHandler) {
        this.server = aEProxyImpl;
        this.source_channel = socketChannel;
        this.setTimeStamp();
        try {
            this.proxy_read_state = aEProxyHandler.getInitialState(this);
        }
        catch (Throwable throwable) {
            this.failed(throwable);
        }
    }

    @Override
    public String getName() {
        String string = this.source_channel.socket().getInetAddress() + ":" + this.source_channel.socket().getPort() + " -> ";
        return string;
    }

    @Override
    public SocketChannel getSourceChannel() {
        return this.source_channel;
    }

    @Override
    public void setReadState(AEProxyState aEProxyState) {
        this.proxy_read_state = aEProxyState;
    }

    @Override
    public void setWriteState(AEProxyState aEProxyState) {
        this.proxy_write_state = aEProxyState;
    }

    @Override
    public void setConnectState(AEProxyState aEProxyState) {
        this.proxy_connect_state = aEProxyState;
    }

    protected boolean read(SocketChannel socketChannel) {
        try {
            return this.proxy_read_state.read(socketChannel);
        }
        catch (Throwable throwable) {
            this.failed(throwable);
            return false;
        }
    }

    protected boolean write(SocketChannel socketChannel) {
        try {
            return this.proxy_write_state.write(socketChannel);
        }
        catch (Throwable throwable) {
            this.failed(throwable);
            return false;
        }
    }

    protected boolean connect(SocketChannel socketChannel) {
        try {
            return this.proxy_connect_state.connect(socketChannel);
        }
        catch (Throwable throwable) {
            this.failed(throwable);
            return false;
        }
    }

    @Override
    public void requestWriteSelect(SocketChannel socketChannel) {
        this.server.requestWriteSelect(this, socketChannel);
    }

    @Override
    public void cancelWriteSelect(SocketChannel socketChannel) {
        this.server.cancelWriteSelect(socketChannel);
    }

    @Override
    public void requestConnectSelect(SocketChannel socketChannel) {
        this.server.requestConnectSelect(this, socketChannel);
    }

    @Override
    public void cancelConnectSelect(SocketChannel socketChannel) {
        this.server.cancelConnectSelect(socketChannel);
    }

    @Override
    public void requestReadSelect(SocketChannel socketChannel) {
        this.server.requestReadSelect(this, socketChannel);
    }

    @Override
    public void cancelReadSelect(SocketChannel socketChannel) {
        this.server.cancelReadSelect(socketChannel);
    }

    @Override
    public void failed(Throwable throwable) {
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "AEProxyProcessor: " + this.getName() + " failed", throwable));
            }
            this.close();
        }
        catch (Throwable throwable2) {
            Debug.printStackTrace(throwable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.is_closed = true;
        try {
            try {
                this.cancelReadSelect(this.source_channel);
                this.cancelWriteSelect(this.source_channel);
                this.source_channel.close();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    ((AEProxyConnectionListener)this.listeners.get(i)).connectionClosed(this);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        finally {
            this.server.close(this);
        }
    }

    @Override
    public boolean isClosed() {
        return this.is_closed;
    }

    @Override
    public void setConnected() {
        this.setTimeStamp();
        this.is_connected = true;
    }

    protected boolean isConnected() {
        return this.is_connected;
    }

    @Override
    public void setTimeStamp() {
        this.time_stamp = SystemTime.getCurrentTime();
    }

    protected long getTimeStamp() {
        return this.time_stamp;
    }

    @Override
    public void addListener(AEProxyConnectionListener aEProxyConnectionListener) {
        this.listeners.add(aEProxyConnectionListener);
    }

    @Override
    public void removeListener(AEProxyConnectionListener aEProxyConnectionListener) {
        this.listeners.remove(aEProxyConnectionListener);
    }

    protected String getStateString() {
        return this.getName() + "connected = " + this.is_connected + ", closed = " + this.is_closed + ", " + "chan: reg = " + this.source_channel.isRegistered() + ", open = " + this.source_channel.isOpen() + ", " + "read:" + (this.proxy_read_state == null ? null : this.proxy_read_state.getStateName()) + ", " + "write:" + (this.proxy_write_state == null ? null : this.proxy_write_state.getStateName()) + ", " + "connect:" + (this.proxy_connect_state == null ? null : this.proxy_connect_state.getStateName());
    }
}

