/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProvider;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.PingSourceManager;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMInstance;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMUpdate;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedLimitMonitor;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;

public class SpeedManagerAlgorithmProviderDHTPing
implements SpeedManagerAlgorithmProvider,
COConfigurationListener {
    private SpeedManagerAlgorithmProviderAdapter adapter;
    private PluginInterface dhtPlugin;
    private long timeSinceLastUpdate;
    private static int metricGoodResult = 100;
    private static int metricGoodTolerance = 300;
    private static int metricBadResult = 1300;
    private static int metricBadTolerance = 300;
    private int consecutiveUpticks = 0;
    private int consecutiveDownticks = 0;
    private SpeedLimitMonitor limitMonitor;
    private int lastMetricValue;
    private static int numIntervalsBetweenCal = 2;
    private static boolean skipIntervalAfterAdjustment = true;
    private List pingTimeList = new ArrayList();
    private boolean hadAdjustmentLastInterval = false;
    private int intervalCount = 0;
    PingSourceManager pingSourceManager = new PingSourceManager();
    int sessionMaxUploadRate = 0;

    SpeedManagerAlgorithmProviderDHTPing(SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter) {
        this.adapter = speedManagerAlgorithmProviderAdapter;
        SpeedManagerLogger.setAdapter("dht", this.adapter);
        this.limitMonitor = new SpeedLimitMonitor(this.adapter.getSpeedManager());
        COConfigurationManager.addListener(this);
        SMInstance.init(speedManagerAlgorithmProviderAdapter);
        try {
            this.dhtPlugin = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
        }
        catch (AzureusCoreException azureusCoreException) {
            this.log("Warning: AzureusCore was not initialized on startup.");
        }
        if (this.dhtPlugin == null) {
            this.log(" Error: failed to get DHT Plugin ");
        }
        this.limitMonitor.initPingSpaceMap(metricGoodResult + metricGoodTolerance, metricBadResult - metricBadTolerance);
    }

    @Override
    public void destroy() {
        COConfigurationManager.removeListener(this);
    }

    @Override
    public void configurationSaved() {
        try {
            this.limitMonitor.readFromPersistentMap();
            this.limitMonitor.updateFromCOConfigManager();
            metricGoodResult = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.dht.good.setpoint");
            metricGoodTolerance = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.dht.good.tolerance");
            metricBadResult = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.dht.bad.setpoint");
            metricBadTolerance = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.dht.bad.tolerance");
            skipIntervalAfterAdjustment = COConfigurationManager.getBooleanParameter("SpeedManagerAlgorithmProviderV2.setting.wait.after.adjust");
            numIntervalsBetweenCal = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.intervals.between.adjust");
            this.limitMonitor.initPingSpaceMap(metricGoodResult + metricGoodTolerance, metricBadResult - metricBadTolerance);
            SpeedManagerLogger.trace("..DHTPing - configurationSaved called.");
        }
        catch (Throwable throwable) {
            SpeedManagerLogger.log(throwable.getMessage());
        }
    }

    @Override
    public void reset() {
        this.log("reset");
        this.log("curr-data: curr-down-rate : curr-down-limit : down-capacity : down-bandwith-mode : down-limit-mode : curr-up-rate : curr-up-limit : up-capacity : upload-bandwidth-mode : upload-limit-mode : transfer-mode");
        this.log("new-limit:newLimit:currStep:signalStrength:multiple:currUpLimit:maxStep:uploadLimitMax:uploadLimitMin:transferMode");
        this.log("consecutive:up:down");
        this.log("metric:value:type");
        this.log("user-comment:log");
        this.log("pin:upload-status,download-status,upload-unpin-timer,download-unpin-timer");
        this.log("limits:down-max:down-min:down-conf:up-max:up-min:up-conf");
        this.limitMonitor.resetPingSpace();
    }

    @Override
    public void updateStats() {
        int n = this.adapter.getCurrentUploadLimit();
        int n2 = this.adapter.getCurrentDataUploadSpeed();
        int n3 = this.adapter.getCurrentProtocolUploadSpeed();
        int n4 = n2 + n3;
        int n5 = this.adapter.getCurrentDownloadLimit();
        int n6 = this.adapter.getCurrentDataDownloadSpeed();
        int n7 = this.adapter.getCurrentProtocolDownloadSpeed();
        int n8 = n6 + n7;
        this.limitMonitor.setDownloadBandwidthMode(n8, n5);
        this.limitMonitor.setUploadBandwidthMode(n4, n);
        this.limitMonitor.setDownloadLimitSettingMode(n5);
        this.limitMonitor.setUploadLimitSettingMode(n);
        this.limitMonitor.updateTransferMode();
        if (this.limitMonitor.isConfTestingLimits()) {
            this.limitMonitor.updateLimitTestingData(n8, n4);
        }
        this.limitMonitor.setCurrentTransferRates(n8, n4);
        if (n4 > this.sessionMaxUploadRate) {
            this.sessionMaxUploadRate = n4;
        }
        this.logCurrentData(n8, n5, n4, n);
    }

    private void logCurrentData(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer("curr-data-v:" + n + ":" + n2 + ":");
        stringBuffer.append(this.limitMonitor.getDownloadMaxLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getDownloadBandwidthMode()).append(":");
        stringBuffer.append(this.limitMonitor.getDownloadLimitSettingMode()).append(":");
        stringBuffer.append(n3).append(":").append(n4).append(":");
        stringBuffer.append(this.limitMonitor.getUploadMaxLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getUploadBandwidthMode()).append(":");
        stringBuffer.append(this.limitMonitor.getUploadLimitSettingMode()).append(":");
        stringBuffer.append(this.limitMonitor.getTransferModeAsString());
        SpeedManagerLogger.log(stringBuffer.toString());
    }

    @Override
    public void pingSourceFound(SpeedManagerPingSource speedManagerPingSource, boolean bl) {
        this.log("pingSourceFound");
        this.pingSourceManager.pingSourceFound(speedManagerPingSource, bl);
    }

    @Override
    public void pingSourceFailed(SpeedManagerPingSource speedManagerPingSource) {
        this.log("pingSourceFailed");
        this.pingSourceManager.pingSourceFailed(speedManagerPingSource);
    }

    @Override
    public void calculate(SpeedManagerPingSource[] speedManagerPingSourceArray) {
        this.limitMonitor.logPMDataEx();
        int n = speedManagerPingSourceArray.length;
        for (int i = 0; i < n; ++i) {
            this.pingSourceManager.addPingTime(speedManagerPingSourceArray[i]);
            int n2 = speedManagerPingSourceArray[i].getPingTime();
            if (n2 <= 0) continue;
            this.pingTimeList.add(new Integer(speedManagerPingSourceArray[i].getPingTime()));
            ++this.intervalCount;
        }
        if (this.limitMonitor.isConfTestingLimits()) {
            if (this.limitMonitor.isConfLimitTestFinished()) {
                this.endLimitTesting();
                return;
            }
            SMUpdate sMUpdate = this.limitMonitor.rampTestingLimit(this.adapter.getCurrentUploadLimit(), this.adapter.getCurrentDownloadLimit());
            this.logNewLimits(sMUpdate);
            this.setNewLimits(sMUpdate);
        }
        long l = SystemTime.getCurrentTime();
        if (this.timeSinceLastUpdate == 0L) {
            this.timeSinceLastUpdate = l;
        }
        if (this.calculateMediaDHTPingTime()) {
            return;
        }
        this.log("metric:" + this.lastMetricValue);
        this.logLimitStatus();
        this.limitMonitor.addToPingMapData(this.lastMetricValue);
        float f = this.determineSignalStrength(this.lastMetricValue);
        if (f != 0.0f && !this.limitMonitor.isConfTestingLimits()) {
            this.hadAdjustmentLastInterval = true;
            float f2 = this.consectiveMultiplier();
            int n3 = this.adapter.getCurrentUploadLimit();
            int n4 = this.adapter.getCurrentDownloadLimit();
            this.limitMonitor.checkForUnpinningCondition();
            SMUpdate sMUpdate = this.limitMonitor.modifyLimits(f, f2, n3, n4);
            this.logNewLimits(sMUpdate);
            this.setNewLimits(sMUpdate);
        } else {
            int n5;
            this.hadAdjustmentLastInterval = false;
            int n6 = this.adapter.getCurrentUploadLimit();
            if (!this.limitMonitor.areSettingsInSpec(n6, n5 = this.adapter.getCurrentDownloadLimit())) {
                SMUpdate sMUpdate = this.limitMonitor.adjustLimitsToSpec(n6, n5);
                this.logNewLimits(sMUpdate);
                this.setNewLimits(sMUpdate);
            }
        }
        this.pingSourceManager.checkPingSources(speedManagerPingSourceArray);
    }

    private void endLimitTesting() {
        int n = this.limitMonitor.guessDownloadLimit();
        int n2 = this.limitMonitor.guessUploadLimit();
        SMUpdate sMUpdate = this.limitMonitor.endLimitTesting(n, n2);
        this.limitMonitor.logPingMapData();
        this.limitMonitor.resetPingSpace();
        this.logNewLimits(sMUpdate);
        this.setNewLimits(sMUpdate);
    }

    private void logLimitStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("limits:");
        stringBuffer.append(this.limitMonitor.getUploadMaxLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getUploadMinLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getUploadConfidence()).append(":");
        stringBuffer.append(this.limitMonitor.getDownloadMaxLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getDownloadMinLimit()).append(":");
        stringBuffer.append(this.limitMonitor.getDownloadConfidence());
        SpeedManagerLogger.log(stringBuffer.toString());
    }

    private boolean calculateMediaDHTPingTime() {
        if (skipIntervalAfterAdjustment && this.hadAdjustmentLastInterval) {
            this.hadAdjustmentLastInterval = false;
            this.pingTimeList = new ArrayList();
            this.intervalCount = 0;
            return true;
        }
        if (this.intervalCount < numIntervalsBetweenCal) {
            return true;
        }
        Collections.sort(this.pingTimeList);
        if (this.pingTimeList.size() == 0) {
            this.lastMetricValue = 10000;
        } else {
            int n = this.pingTimeList.size() / 2;
            Integer n2 = (Integer)this.pingTimeList.get(n);
            this.lastMetricValue = n2;
        }
        this.intervalCount = 0;
        this.pingTimeList = new ArrayList();
        return false;
    }

    private void logNewLimits(SMUpdate sMUpdate) {
        int n;
        if (sMUpdate.hasNewUploadLimit) {
            n = sMUpdate.newUploadLimit / 1024;
            this.log(" new up limit  : " + n + " kb/s");
        }
        if (sMUpdate.hasNewDownloadLimit) {
            n = sMUpdate.newDownloadLimit / 1024;
            this.log(" new down limit: " + n + " kb/s");
        }
    }

    private void setNewLimits(SMUpdate sMUpdate) {
        this.adapter.setCurrentUploadLimit(sMUpdate.newUploadLimit);
        this.adapter.setCurrentDownloadLimit(sMUpdate.newDownloadLimit);
    }

    private float determineSignalStrength(int n) {
        float f = 0.0f;
        if (n < metricGoodResult) {
            f = 1.0f;
            ++this.consecutiveUpticks;
            this.consecutiveDownticks = 0;
        } else if (n < metricGoodResult + metricGoodTolerance) {
            f = (float)(n - metricGoodResult) / (float)metricGoodTolerance;
            ++this.consecutiveUpticks;
            this.consecutiveDownticks = 0;
        } else if (n > metricBadResult) {
            f = -1.0f;
            this.consecutiveUpticks = 0;
            ++this.consecutiveDownticks;
        } else if (n > metricBadResult - metricBadTolerance) {
            this.consecutiveUpticks = 0;
            ++this.consecutiveDownticks;
            int n2 = metricBadResult - metricBadTolerance;
            f = (n - n2) / metricBadTolerance;
            f -= 1.0f;
        }
        this.log("consecutive:" + this.consecutiveUpticks + ":" + this.consecutiveDownticks);
        return f;
    }

    private float consectiveMultiplier() {
        float f;
        if (this.consecutiveUpticks > this.consecutiveDownticks) {
            if (this.limitMonitor.bandwidthUsageLow()) {
                this.consecutiveUpticks = 0;
            }
            f = this.calculateUpTickMultiple(this.consecutiveUpticks);
        } else {
            f = this.calculateDownTickMultiple(this.consecutiveDownticks);
            this.limitMonitor.notifyOfDownSignal();
        }
        return f;
    }

    private float calculateUpTickMultiple(int n) {
        float f = 0.0f;
        if (n < 0) {
            return f;
        }
        switch (n) {
            case 0: 
            case 1: {
                f = 0.25f;
                break;
            }
            case 2: {
                f = 0.5f;
                break;
            }
            case 3: {
                f = 1.0f;
                break;
            }
            case 4: {
                f = 1.25f;
                break;
            }
            case 5: {
                f = 1.5f;
                break;
            }
            case 6: {
                f = 1.75f;
                break;
            }
            case 7: {
                f = 2.0f;
                break;
            }
            case 8: {
                f = 2.25f;
                break;
            }
            case 9: {
                f = 2.5f;
                break;
            }
            default: {
                f = 3.0f;
            }
        }
        if (this.limitMonitor.bandwidthUsageMedium()) {
            f /= 2.0f;
        }
        return f;
    }

    private float calculateDownTickMultiple(int n) {
        float f = 0.0f;
        if (n < 0) {
            return f;
        }
        switch (n) {
            case 0: 
            case 1: {
                f = 0.25f;
                break;
            }
            case 2: {
                f = 0.5f;
                break;
            }
            case 3: {
                f = 1.0f;
                break;
            }
            case 4: {
                f = 2.0f;
                break;
            }
            case 5: {
                f = 3.0f;
                break;
            }
            case 6: {
                f = 4.0f;
                break;
            }
            case 7: {
                f = 6.0f;
                break;
            }
            case 8: {
                f = 9.0f;
                break;
            }
            case 9: {
                f = 15.0f;
                break;
            }
            default: {
                f = 20.0f;
            }
        }
        return f;
    }

    @Override
    public int getIdlePingMillis() {
        return this.lastMetricValue;
    }

    @Override
    public int getCurrentPingMillis() {
        return 0;
    }

    @Override
    public int getMaxPingMillis() {
        return 912;
    }

    @Override
    public int getCurrentChokeSpeed() {
        return 0;
    }

    @Override
    public int getMaxUploadSpeed() {
        return this.sessionMaxUploadRate;
    }

    @Override
    public boolean getAdjustsDownloadLimits() {
        return true;
    }

    protected void log(String string) {
        SpeedManagerLogger.log(string);
    }
}

