/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.magnet;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.magnet.MagnetPluginListener;
import com.aelitis.azureus.plugins.magnet.MagnetPluginProgressListener;
import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerException;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;

public class MagnetPlugin
implements Plugin {
    private static final String SECONDARY_LOOKUP = "http://magnet.vuze.com/";
    private static final int SECONDARY_LOOKUP_DELAY = 20000;
    private static final int SECONDARY_LOOKUP_MAX_TIME = 120000;
    private static final String PLUGIN_NAME = "Magnet URI Handler";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.magnetplugin";
    private PluginInterface plugin_interface;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private boolean first_download = true;
    private BooleanParameter secondary_lookup;

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    @Override
    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        BasicPluginConfigModel basicPluginConfigModel = this.plugin_interface.getUIManager().createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        this.secondary_lookup = basicPluginConfigModel.addBooleanParameter2("MagnetPlugin.use.lookup.service", "MagnetPlugin.use.lookup.service", true);
        MagnetURIHandler.getSingleton().addListener(new MagnetURIHandlerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] badge() {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/aelitis/azureus/plugins/magnet/Magnet.gif");
                if (inputStream == null) {
                    return null;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        int n;
                        byte[] byArray = new byte[8192];
                        while ((n = inputStream.read(byArray)) > 0) {
                            byteArrayOutputStream.write(byArray, 0, n);
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                    return byteArrayOutputStream.toByteArray();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    return null;
                }
            }

            @Override
            public byte[] download(final MagnetURIHandlerProgressListener magnetURIHandlerProgressListener, byte[] byArray, String string, InetSocketAddress[] inetSocketAddressArray, long l) throws MagnetURIHandlerException {
                try {
                    Torrent torrent;
                    Download download = MagnetPlugin.this.plugin_interface.getDownloadManager().getDownload(byArray);
                    if (download != null && (torrent = download.getTorrent()) != null) {
                        return torrent.writeToBEncodedData();
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
                return MagnetPlugin.this.download(new MagnetPluginProgressListener(){

                    @Override
                    public void reportSize(long l) {
                        magnetURIHandlerProgressListener.reportSize(l);
                    }

                    @Override
                    public void reportActivity(String string) {
                        magnetURIHandlerProgressListener.reportActivity(string);
                    }

                    @Override
                    public void reportCompleteness(int n) {
                        magnetURIHandlerProgressListener.reportCompleteness(n);
                    }

                    @Override
                    public void reportContributor(InetSocketAddress inetSocketAddress) {
                    }

                    @Override
                    public boolean verbose() {
                        return magnetURIHandlerProgressListener.verbose();
                    }
                }, byArray, string, inetSocketAddressArray, l);
            }

            @Override
            public boolean download(URL uRL) throws MagnetURIHandlerException {
                try {
                    MagnetPlugin.this.plugin_interface.getDownloadManager().addDownload(uRL, false);
                    return true;
                }
                catch (DownloadException downloadException) {
                    throw new MagnetURIHandlerException("Operation failed", downloadException);
                }
            }

            @Override
            public boolean set(String string, Map map) {
                List list = MagnetPlugin.this.listeners.getList();
                for (int i = 0; i < list.size(); ++i) {
                    if (!((MagnetPluginListener)list.get(i)).set(string, map)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int get(String string, Map map) {
                List list = MagnetPlugin.this.listeners.getList();
                for (int i = 0; i < list.size(); ++i) {
                    int n = ((MagnetPluginListener)list.get(i)).get(string, map);
                    if (n == Integer.MIN_VALUE) continue;
                    return n;
                }
                return Integer.MIN_VALUE;
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                AEThread2 aEThread2 = new AEThread2("MagnetPlugin:init", true){

                    @Override
                    public void run() {
                        MagnetPlugin.this.plugin_interface.getDistributedDatabase();
                    }
                };
                aEThread2.start();
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(UIInstance uIInstance) {
            }

            @Override
            public void UIDetached(UIInstance uIInstance) {
            }
        });
    }

    public URL getMagnetURL(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return null;
        }
        return this.getMagnetURL(torrent.getHash());
    }

    public URL getMagnetURL(byte[] byArray) {
        try {
            return new URL("magnet:?xt=urn:btih:" + Base32.encode(byArray));
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    public byte[] badge() {
        return null;
    }

    public byte[] download(MagnetPluginProgressListener magnetPluginProgressListener, byte[] byArray, String string, InetSocketAddress[] inetSocketAddressArray, long l) throws MagnetURIHandlerException {
        byte[] byArray2 = this.downloadSupport(magnetPluginProgressListener, byArray, string, inetSocketAddressArray, l);
        if (string != null) {
            Object object;
            String[] stringArray = string.split("&");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String object2 : stringArray) {
                object = object2.split("=");
                if (((String[])object).length != 2 || !object[0].equalsIgnoreCase("ws")) continue;
                try {
                    arrayList.add(new URL(UrlUtils.decode(object[1])).toExternalForm());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (arrayList.size() > 0) {
                try {
                    boolean bl;
                    TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(byArray2);
                    Object object3 = tOTorrent.getAdditionalProperty("url-list");
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    if (object3 instanceof byte[]) {
                        try {
                            arrayList.remove(new URL(new String((byte[])object3, "UTF-8")).toExternalForm());
                        }
                        catch (Throwable throwable) {}
                    } else if (object3 instanceof List) {
                        List bl2 = (List)object3;
                        for (byte[] byArray3 : bl2) {
                            try {
                                arrayList2.add(new URL(new String(byArray3, "UTF-8")).toExternalForm());
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    boolean bl3 = false;
                    for (String string2 : arrayList) {
                        if (arrayList2.contains(string2)) continue;
                        arrayList2.add(string2);
                        bl = true;
                    }
                    if (bl) {
                        object = new ArrayList();
                        for (String string3 : arrayList2) {
                            object.add(string3.getBytes("UTF-8"));
                        }
                        tOTorrent.setAdditionalProperty("url-list", object);
                        byArray2 = BEncoder.encode(tOTorrent.serialiseToMap());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] downloadSupport(final MagnetPluginProgressListener magnetPluginProgressListener, byte[] byArray, String string, final InetSocketAddress[] inetSocketAddressArray, long l) throws MagnetURIHandlerException {
        try {
            if (this.first_download) {
                magnetPluginProgressListener.reportActivity(this.getMessageText("report.waiting_ddb"));
                this.first_download = false;
            }
            final DistributedDatabase distributedDatabase = this.plugin_interface.getDistributedDatabase();
            final ArrayList arrayList = new ArrayList();
            final AESemaphore aESemaphore = new AESemaphore("MagnetPlugin:liveones");
            final AEMonitor aEMonitor = new AEMonitor("MagnetPlugin:liveones");
            final int[] nArray = new int[]{0};
            final boolean[] blArray = new boolean[]{false};
            magnetPluginProgressListener.reportActivity(this.getMessageText("report.searching"));
            DistributedDatabaseListener distributedDatabaseListener = new DistributedDatabaseListener(){
                private Set found_set = new HashSet();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void event(DistributedDatabaseEvent distributedDatabaseEvent) {
                    int n = distributedDatabaseEvent.getType();
                    if (n == 7) {
                        if (inetSocketAddressArray.length > 0) {
                            new DelayedEvent("MP:sourceAdd", 10000L, new AERunnable(){

                                @Override
                                public void runSupport() {
                                    this.addExplicitSources();
                                }
                            });
                        }
                    } else if (n == 2) {
                        this.contactFound(distributedDatabaseEvent.getValue().getContact());
                    } else if (n == 4 || n == 5) {
                        magnetPluginProgressListener.reportActivity(MagnetPlugin.this.getMessageText("report.found", String.valueOf(this.found_set.size())));
                        this.addExplicitSources();
                        try {
                            aEMonitor.enter();
                            blArray[0] = true;
                        }
                        finally {
                            aEMonitor.exit();
                        }
                        aESemaphore.release();
                    }
                }

                protected void addExplicitSources() {
                    for (int i = 0; i < inetSocketAddressArray.length; ++i) {
                        try {
                            this.contactFound(distributedDatabase.importContact(inetSocketAddressArray[i]));
                            continue;
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void contactFound(final DistributedDatabaseContact distributedDatabaseContact) {
                    String string = distributedDatabaseContact.getAddress().toString();
                    Set set = this.found_set;
                    synchronized (set) {
                        if (this.found_set.contains(string)) {
                            return;
                        }
                        this.found_set.add(string);
                    }
                    if (magnetPluginProgressListener.verbose()) {
                        magnetPluginProgressListener.reportActivity(MagnetPlugin.this.getMessageText("report.found", distributedDatabaseContact.getName()));
                    }
                    try {
                        aEMonitor.enter();
                        nArray[0] = nArray[0] + 1;
                    }
                    finally {
                        aEMonitor.exit();
                    }
                    distributedDatabaseContact.isAlive(20000L, new DistributedDatabaseListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void event(DistributedDatabaseEvent distributedDatabaseEvent) {
                            try {
                                boolean bl;
                                boolean bl2 = bl = distributedDatabaseEvent.getType() == 4;
                                if (magnetPluginProgressListener.verbose()) {
                                    magnetPluginProgressListener.reportActivity(MagnetPlugin.this.getMessageText(bl ? "report.alive" : "report.dead", distributedDatabaseContact.getName()));
                                }
                                try {
                                    aEMonitor.enter();
                                    Object[] objectArray = new Object[]{new Boolean(bl), distributedDatabaseContact};
                                    boolean bl3 = false;
                                    if (bl) {
                                        for (int i = 0; i < arrayList.size(); ++i) {
                                            if (((Boolean)((Object[])arrayList.get(i))[0]).booleanValue()) continue;
                                            arrayList.add(i, objectArray);
                                            bl3 = true;
                                            break;
                                        }
                                    }
                                    if (!bl3) {
                                        arrayList.add(objectArray);
                                    }
                                }
                                finally {
                                    aEMonitor.exit();
                                }
                            }
                            finally {
                                try {
                                    aEMonitor.enter();
                                    nArray[0] = nArray[0] - 1;
                                }
                                finally {
                                    aEMonitor.exit();
                                }
                                aESemaphore.release();
                            }
                        }
                    });
                }
            };
            distributedDatabase.read(distributedDatabaseListener, distributedDatabase.createKey(byArray, "Torrent download lookup for '" + ByteFormatter.encodeString(byArray) + "'"), l, 3);
            long l2 = l;
            long l3 = SystemTime.getMonotonousTime();
            boolean bl = true;
            long l4 = -1L;
            long l5 = -1L;
            Object[] objectArray = new Object[]{null};
            while (l2 > 0L) {
                DistributedDatabaseContact distributedDatabaseContact;
                boolean bl2;
                Object object;
                try {
                    aEMonitor.enter();
                    if (blArray[0] && arrayList.size() == 0 && nArray[0] == 0) {
                        break;
                    }
                }
                finally {
                    aEMonitor.exit();
                }
                while (l2 > 0L) {
                    long l6 = SystemTime.getMonotonousTime();
                    boolean bl3 = aESemaphore.reserve(1000L);
                    long l7 = SystemTime.getMonotonousTime();
                    l2 -= l7 - l6;
                    if (bl3) {
                        l5 = l7;
                        break;
                    }
                    if (!bl) continue;
                    if (l4 == -1L) {
                        long l8 = l5 == -1L || l7 - l3 > 60000L ? l3 : l5;
                        long l9 = l7 - l8;
                        if (l9 <= 20000L) continue;
                        l4 = SystemTime.getMonotonousTime();
                        this.doSecondaryLookup(magnetPluginProgressListener, objectArray, byArray, string);
                        continue;
                    }
                    try {
                        byte[] byArray2 = this.getSecondaryLookupResult(objectArray);
                        if (byArray2 == null) continue;
                        return byArray2;
                    }
                    catch (ResourceDownloaderException resourceDownloaderException) {
                    }
                }
                try {
                    aEMonitor.enter();
                    if (arrayList.size() == 0) {
                        if (nArray[0] != 0) continue;
                        break;
                    }
                    object = (Object[])arrayList.remove(0);
                    bl2 = (Boolean)object[0];
                    distributedDatabaseContact = (DistributedDatabaseContact)object[1];
                }
                finally {
                    aEMonitor.exit();
                    continue;
                }
                if (!bl2) {
                    magnetPluginProgressListener.reportActivity(this.getMessageText("report.tunnel", distributedDatabaseContact.getName()));
                    distributedDatabaseContact.openTunnel();
                }
                try {
                    magnetPluginProgressListener.reportActivity(this.getMessageText("report.downloading", distributedDatabaseContact.getName()));
                    object = distributedDatabaseContact.read(new DistributedDatabaseProgressListener(){

                        @Override
                        public void reportSize(long l) {
                            magnetPluginProgressListener.reportSize(l);
                        }

                        @Override
                        public void reportActivity(String string) {
                            magnetPluginProgressListener.reportActivity(string);
                        }

                        @Override
                        public void reportCompleteness(int n) {
                            magnetPluginProgressListener.reportCompleteness(n);
                        }
                    }, distributedDatabase.getStandardTransferType(1), distributedDatabase.createKey(byArray, "Torrent download content for '" + ByteFormatter.encodeString(byArray) + "'"), l);
                    if (object == null) continue;
                    byte[] byArray3 = (byte[])object.getValue(byte[].class);
                    try {
                        TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(byArray3);
                        if (Arrays.equals(byArray, tOTorrent.getHash())) {
                            magnetPluginProgressListener.reportContributor(distributedDatabaseContact.getAddress());
                            return byArray3;
                        }
                        magnetPluginProgressListener.reportActivity(this.getMessageText("report.error", "torrent invalid (hash mismatch)"));
                    }
                    catch (Throwable throwable) {
                        magnetPluginProgressListener.reportActivity(this.getMessageText("report.error", "torrent invalid (decode failed)"));
                    }
                }
                catch (Throwable throwable) {
                    magnetPluginProgressListener.reportActivity(this.getMessageText("report.error", Debug.getNestedExceptionMessage(throwable)));
                    Debug.printStackTrace(throwable);
                }
            }
            if (bl) {
                if (l4 == -1L) {
                    l4 = SystemTime.getMonotonousTime();
                    this.doSecondaryLookup(magnetPluginProgressListener, objectArray, byArray, string);
                }
                while (SystemTime.getMonotonousTime() - l4 < 120000L) {
                    try {
                        byte[] byArray4 = this.getSecondaryLookupResult(objectArray);
                        if (byArray4 != null) {
                            return byArray4;
                        }
                        Thread.sleep(500L);
                    }
                    catch (ResourceDownloaderException resourceDownloaderException) {
                        // empty catch block
                        break;
                    }
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            magnetPluginProgressListener.reportActivity(this.getMessageText("report.error", Debug.getNestedExceptionMessage(throwable)));
            throw new MagnetURIHandlerException("MagnetURIHandler failed", throwable);
        }
    }

    protected void doSecondaryLookup(final MagnetPluginProgressListener magnetPluginProgressListener, final Object[] objectArray, byte[] byArray, String string) {
        magnetPluginProgressListener.reportActivity(this.getMessageText("report.secondarylookup", null));
        try {
            ResourceDownloaderFactory resourceDownloaderFactory = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
            URL uRL = new URL("http://magnet.vuze.com/magnetLookup?hash=" + Base32.encode(byArray) + (string.length() == 0 ? "" : "&args=" + UrlUtils.encode(string)));
            ResourceDownloader resourceDownloader = resourceDownloaderFactory.create(uRL);
            resourceDownloader.addListener(new ResourceDownloaderAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
                    magnetPluginProgressListener.reportActivity(MagnetPlugin.this.getMessageText("report.secondarylookup.ok", null));
                    Object[] objectArray2 = objectArray;
                    synchronized (objectArray) {
                        objectArray[0] = inputStream;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return true;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
                    Object[] objectArray2 = objectArray;
                    synchronized (objectArray) {
                        objectArray[0] = resourceDownloaderException;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        magnetPluginProgressListener.reportActivity(MagnetPlugin.this.getMessageText("report.secondarylookup.fail"));
                        return;
                    }
                }
            });
            resourceDownloader.asyncDownload();
        }
        catch (Throwable throwable) {
            magnetPluginProgressListener.reportActivity(this.getMessageText("report.secondarylookup.fail", Debug.getNestedExceptionMessage(throwable)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getSecondaryLookupResult(Object[] objectArray) throws ResourceDownloaderException {
        Object object = objectArray;
        synchronized (objectArray) {
            Object object2 = objectArray[0];
            objectArray[0] = null;
            // ** MonitorExit[var3_2 /* !! */ ] (shouldn't be in output)
            if (object2 instanceof InputStream) {
                object = (InputStream)object2;
                try {
                    TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedInputStream((InputStream)object);
                    TorrentUtils.setPeerCacheValid(tOTorrent);
                    return BEncoder.encode(tOTorrent.serialiseToMap());
                }
                catch (Throwable throwable) {}
            } else if (object2 instanceof ResourceDownloaderException) {
                throw (ResourceDownloaderException)object2;
            }
            return null;
        }
    }

    protected String getMessageText(String string) {
        return this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("MagnetPlugin." + string);
    }

    protected String getMessageText(String string, String string2) {
        return this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("MagnetPlugin." + string, new String[]{string2});
    }

    public void addListener(MagnetPluginListener magnetPluginListener) {
        this.listeners.add(magnetPluginListener);
    }

    public void removeListener(MagnetPluginListener magnetPluginListener) {
        this.listeners.remove(magnetPluginListener);
    }
}

