/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPMappingListener;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManagerListener;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;

public class UPnPMappingManager {
    private static UPnPMappingManager singleton;
    private UPnPPlugin plugin;
    private List mappings = new ArrayList();
    private List listeners = new ArrayList();
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher();

    protected static synchronized UPnPMappingManager getSingleton(UPnPPlugin uPnPPlugin) {
        if (singleton == null) {
            singleton = new UPnPMappingManager(uPnPPlugin);
        }
        return singleton;
    }

    protected UPnPMappingManager(UPnPPlugin uPnPPlugin) {
        this.plugin = uPnPPlugin;
        this.addConfigPort("upnp.mapping.dataport", false, "UDP.Listen.Port.Enable", "UDP.Listen.Port");
        this.addConfigPort("upnp.mapping.trackerclientudp", false, "Server Enable UDP", "UDP.NonData.Listen.Port");
        this.addConfigPort("upnp.mapping.dataport", true, "TCP.Listen.Port.Enable", "TCP.Listen.Port");
        this.addConfigPort("upnp.mapping.dataport", true, "HTTP.Data.Listen.Port.Enable", "HTTP.Data.Listen.Port");
        this.addConfigPort("upnp.mapping.tcptrackerport", true, "Tracker Port Enable", "Tracker Port");
        this.addConfigPortX("upnp.mapping.tcptrackerport", true, "Tracker Port Enable", "Tracker Port Backups");
        this.addConfigPort("upnp.mapping.tcpssltrackerport", true, "Tracker Port SSL Enable", "Tracker Port SSL");
        this.addConfigPortX("upnp.mapping.tcpssltrackerport", true, "Tracker Port SSL Enable", "Tracker Port SSL Backups");
        this.addConfigPort("upnp.mapping.udptrackerport", false, "Tracker Port UDP Enable", "Tracker Port");
    }

    protected void serviceFound(UPnPWANConnection uPnPWANConnection) {
        boolean bl = false;
        if ((uPnPWANConnection.getCapabilities() & 1) == 0) {
            UPnPMapping[] uPnPMappingArray = this.getMappings();
            for (int i = 0; i < uPnPMappingArray.length; ++i) {
                UPnPMapping uPnPMapping;
                int n;
                int n2;
                int n3;
                List list;
                UPnPMapping uPnPMapping2 = uPnPMappingArray[i];
                if (!uPnPMapping2.isEnabled() || !uPnPMapping2.isTCP() || (list = this.getMappingEx(false, uPnPMapping2.getPort())).size() == 0) continue;
                boolean bl2 = false;
                for (n3 = 0; n3 < list.size(); ++n3) {
                    UPnPMapping uPnPMapping3 = (UPnPMapping)list.get(n3);
                    if (!uPnPMapping3.isEnabled()) continue;
                    bl2 = true;
                }
                if (!bl2) continue;
                while (this.getMapping(true, n2 = RandomUtils.generateRandomNetworkListenPort()) != null || this.getMapping(false, n2) != null) {
                }
                n3 = n2;
                while (this.getMapping(true, n2 = RandomUtils.generateRandomNetworkListenPort()) != null || this.getMapping(false, n2) != null || n3 == n2) {
                }
                int n4 = n2;
                String string = "";
                for (n = 0; n < list.size(); ++n) {
                    uPnPMapping = (UPnPMapping)list.get(n);
                    if (!uPnPMapping.isEnabled()) continue;
                    string = string + (string.length() == 0 ? "" : ",") + uPnPMapping.getString(n4);
                }
                this.plugin.logAlert(2, "upnp.portchange.alert", new String[]{uPnPMapping2.getString(n3), String.valueOf(uPnPMapping2.getPort()), string, String.valueOf(uPnPMapping2.getPort())});
                uPnPMapping2.setPort(n3);
                for (n = 0; n < list.size(); ++n) {
                    uPnPMapping = (UPnPMapping)list.get(n);
                    if (!uPnPMapping.isEnabled()) continue;
                    uPnPMapping.setPort(n4);
                }
                bl = true;
            }
        }
        if (bl) {
            COConfigurationManager.save();
        }
    }

    protected UPnPMapping addConfigPort(String string, boolean bl, boolean bl2, final String string2) {
        int n = COConfigurationManager.getIntParameter(string2);
        final UPnPMapping uPnPMapping = this.addMapping(string, bl, n, bl2);
        uPnPMapping.addListener(new UPnPMappingListener(){

            @Override
            public void mappingChanged(UPnPMapping uPnPMapping) {
                COConfigurationManager.setParameter(string2, uPnPMapping.getPort());
            }

            @Override
            public void mappingDestroyed(UPnPMapping uPnPMapping) {
            }
        });
        this.addConfigListener(string2, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                uPnPMapping.setPort(COConfigurationManager.getIntParameter(string2));
            }
        });
        return uPnPMapping;
    }

    protected void addConfigPort(String string, boolean bl, final String string2, final String string3) {
        boolean bl2 = COConfigurationManager.getBooleanParameter(string2);
        final UPnPMapping uPnPMapping = this.addConfigPort(string, bl, bl2, string3);
        uPnPMapping.addListener(new UPnPMappingListener(){

            @Override
            public void mappingChanged(UPnPMapping uPnPMapping) {
                COConfigurationManager.setParameter(string3, uPnPMapping.getPort());
            }

            @Override
            public void mappingDestroyed(UPnPMapping uPnPMapping) {
            }
        });
        this.addConfigListener(string2, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                uPnPMapping.setEnabled(COConfigurationManager.getBooleanParameter(string2));
            }
        });
    }

    protected void addConfigPortX(final String string, final boolean bl, final String string2, final String string3) {
        final ArrayList arrayList = new ArrayList();
        ParameterListener parameterListener = new ParameterListener(){

            @Override
            public void parameterChanged(String string4) {
                int n;
                boolean bl2 = COConfigurationManager.getBooleanParameter(string2);
                List list = UPnPMappingManager.this.stringToPorts(COConfigurationManager.getStringParameter(string3));
                for (n = 0; n < list.size(); ++n) {
                    int n2 = (Integer)list.get(n);
                    if (arrayList.size() <= n) {
                        UPnPMapping uPnPMapping = UPnPMappingManager.this.addMapping(string, bl, n2, bl2);
                        uPnPMapping.setEnabled(bl2);
                        arrayList.add(uPnPMapping);
                        continue;
                    }
                    ((UPnPMapping)arrayList.get(n)).setPort(n2);
                }
                for (n = list.size(); n < arrayList.size(); ++n) {
                    ((UPnPMapping)arrayList.get(n)).setEnabled(false);
                }
            }
        };
        this.addConfigListener(string3, parameterListener);
        ParameterListener parameterListener2 = new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                List list = UPnPMappingManager.this.stringToPorts(COConfigurationManager.getStringParameter(string3));
                boolean bl = COConfigurationManager.getBooleanParameter(string2);
                for (int i = 0; i < (bl ? list.size() : arrayList.size()); ++i) {
                    ((UPnPMapping)arrayList.get(i)).setEnabled(bl);
                }
            }
        };
        this.addConfigListener(string2, parameterListener2);
        parameterListener.parameterChanged(null);
        parameterListener2.parameterChanged(null);
    }

    protected List stringToPorts(String string) {
        string = string.replace(',', ';');
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                arrayList.add(new Integer(stringTokenizer.nextToken().trim()));
            }
            catch (Throwable throwable) {
                Debug.out("Invalid port entry in '" + string + "'", throwable);
            }
        }
        return arrayList;
    }

    public UPnPMapping addMapping(String string, boolean bl, int n, boolean bl2) {
        UPnPMapping uPnPMapping = new UPnPMapping(string, bl, n, bl2);
        this.mappings.add(uPnPMapping);
        this.added(uPnPMapping);
        return uPnPMapping;
    }

    public UPnPMapping[] getMappings() {
        UPnPMapping[] uPnPMappingArray = new UPnPMapping[this.mappings.size()];
        this.mappings.toArray(uPnPMappingArray);
        return uPnPMappingArray;
    }

    public UPnPMapping getMapping(boolean bl, int n) {
        for (int i = 0; i < this.mappings.size(); ++i) {
            UPnPMapping uPnPMapping = (UPnPMapping)this.mappings.get(i);
            if (uPnPMapping.isTCP() != bl || uPnPMapping.getPort() != n) continue;
            return uPnPMapping;
        }
        return null;
    }

    public List getMappingEx(boolean bl, int n) {
        ArrayList<UPnPMapping> arrayList = new ArrayList<UPnPMapping>();
        for (int i = 0; i < this.mappings.size(); ++i) {
            UPnPMapping uPnPMapping = (UPnPMapping)this.mappings.get(i);
            if (uPnPMapping.isTCP() != bl || uPnPMapping.getPort() != n) continue;
            arrayList.add(uPnPMapping);
        }
        return arrayList;
    }

    protected void added(UPnPMapping uPnPMapping) {
        uPnPMapping.addListener(new UPnPMappingListener(){

            @Override
            public void mappingChanged(UPnPMapping uPnPMapping) {
            }

            @Override
            public void mappingDestroyed(UPnPMapping uPnPMapping) {
                UPnPMappingManager.this.mappings.remove(uPnPMapping);
            }
        });
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((UPnPMappingManagerListener)this.listeners.get(i)).mappingAdded(uPnPMapping);
        }
    }

    public void addListener(UPnPMappingManagerListener uPnPMappingManagerListener) {
        this.listeners.add(uPnPMappingManagerListener);
    }

    public void removeListener(UPnPMappingManagerListener uPnPMappingManagerListener) {
        this.listeners.remove(uPnPMappingManagerListener);
    }

    protected void addConfigListener(final String string, final ParameterListener parameterListener) {
        COConfigurationManager.addParameterListener(string, new ParameterListener(){

            @Override
            public void parameterChanged(String string2) {
                UPnPMappingManager.this.async_dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        parameterListener.parameterChanged(string);
                    }
                });
            }
        });
    }
}

