/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.utils;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class ImageBytesDownloader {
    static final Map<String, List<ImageDownloaderListener>> map = new HashMap<String, List<ImageDownloaderListener>>();
    static final AEMonitor mon_map = new AEMonitor("ImageDownloaderMap");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadImage(final String string, ImageDownloaderListener imageDownloaderListener) {
        Object object;
        mon_map.enter();
        try {
            object = map.get(string);
            if (object != null) {
                object.add((ImageDownloaderListener)imageDownloaderListener);
                return;
            }
            object = new ArrayList<ImageDownloaderListener>(1);
            object.add((ImageDownloaderListener)imageDownloaderListener);
            map.put(string, (List<ImageDownloaderListener>)object);
        }
        finally {
            mon_map.exit();
        }
        try {
            object = ResourceDownloaderFactoryImpl.getSingleton().create(new URL(string));
            object.addListener(new ResourceDownloaderAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
                    mon_map.enter();
                    try {
                        List<ImageDownloaderListener> list = map.get(string);
                        if (list != null) {
                            try {
                                if (inputStream != null && inputStream.available() > 0) {
                                    byte[] byArray = new byte[inputStream.available()];
                                    inputStream.read(byArray);
                                    for (ImageDownloaderListener imageDownloaderListener : list) {
                                        try {
                                            imageDownloaderListener.imageDownloaded(byArray);
                                        }
                                        catch (Exception exception) {
                                            Debug.out(exception);
                                        }
                                    }
                                }
                            }
                            catch (Exception exception) {
                                Debug.out(exception);
                            }
                        }
                        map.remove(string);
                    }
                    finally {
                        mon_map.exit();
                    }
                    return false;
                }
            });
            object.asyncDownload();
        }
        catch (Exception exception) {
            Debug.out(string, exception);
        }
    }

    public static interface ImageDownloaderListener {
        public void imageDownloaded(byte[] var1);
    }
}

