/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;

public class MapUtils {
    public static int getMapInt(Map map, String string, int n) {
        if (map == null) {
            return n;
        }
        try {
            Number number = (Number)map.get(string);
            if (number == null) {
                return n;
            }
            return number.intValue();
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return n;
        }
    }

    public static long getMapLong(Map map, String string, long l) {
        if (map == null) {
            return l;
        }
        try {
            Number number = (Number)map.get(string);
            if (number == null) {
                return l;
            }
            return number.longValue();
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return l;
        }
    }

    public static String getMapString(Map map, String string, String string2) {
        if (map == null) {
            return string2;
        }
        try {
            Object v = map.get(string);
            if (v == null && !map.containsKey(string)) {
                return string2;
            }
            if (v instanceof String) {
                return (String)v;
            }
            if (v instanceof byte[]) {
                return new String((byte[])v, "utf-8");
            }
            return string2;
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return string2;
        }
    }

    public static byte[] getMapByteArray(Map map, String string, byte[] byArray) {
        if (map == null) {
            return byArray;
        }
        try {
            Object v = map.get(string);
            if (v instanceof byte[]) {
                return (byte[])v;
            }
            String string2 = string + ".B64";
            if (map.containsKey(string2) && (v = map.get(string2)) instanceof String) {
                return Base64.decode((String)v);
            }
            String string3 = string + ".B32";
            if (map.containsKey(string3) && (v = map.get(string3)) instanceof String) {
                return Base32.decode((String)v);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return byArray;
        }
    }

    public static Object getMapObject(Map map, String string, Object object, Class clazz) {
        if (map == null) {
            return object;
        }
        try {
            Object v = map.get(string);
            if (clazz.isInstance(v)) {
                return v;
            }
            return object;
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return object;
        }
    }

    public static boolean getMapBoolean(Map map, String string, boolean bl) {
        if (map == null) {
            return bl;
        }
        try {
            Object v = map.get(string);
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
            if (v instanceof Long) {
                return (Long)v == 1L;
            }
            return bl;
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return bl;
        }
    }

    public static List getMapList(Map map, String string, List list) {
        if (map == null) {
            return list;
        }
        try {
            List list2 = (List)map.get(string);
            if (list2 == null && !map.containsKey(string)) {
                return list;
            }
            return list2;
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return list;
        }
    }

    public static Map getMapMap(Map map, String string, Map map2) {
        if (map == null) {
            return map2;
        }
        try {
            Map map3 = (Map)map.get(string);
            if (map3 == null && !map.containsKey(string)) {
                return map2;
            }
            return map3;
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return map2;
        }
    }
}

